/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypePredicateTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    public static final char NO_NAME_HOLDER = '?';
    @Nullable
    private final JSType myType;
    @Nullable
    private final String myParameterName;
    private final int myParameterIndex;

    @Nullable
    public JSType getGuardType() {
        return this.myType;
    }

    @Nullable
    public String getParameterName() {
        return this.myParameterName;
    }

    public boolean isThisParameter() {
        return "this".equals(this.myParameterName);
    }

    public int getParameterIndex() {
        return this.myParameterIndex;
    }

    public TypeScriptTypePredicateTypeImpl(@Nullable JSType guardType, @NotNull JSTypeSource source, @Nullable String parameterName, int parameterIndex) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl", "<init>"));
        }
        super(source);
        this.myType = guardType;
        this.myParameterName = parameterName;
        this.myParameterIndex = parameterIndex;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.PRESENTABLE) {
            if ("boolean" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl", "getTypeText"));
            }
            return "boolean";
        }
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            StringBuilder result = new StringBuilder();
            result.append("#guard");
            result.append(StringUtil.isEmpty((String)this.myParameterName) ? Character.valueOf('?') : this.myParameterName);
            result.append(" ");
            result.append(this.myParameterIndex);
            result.append(" ");
            boolean shouldWrap = JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
            if (shouldWrap) {
                result.append("(");
            }
            result.append(this.myType != null ? this.myType.getTypeText(format) : "any");
            if (shouldWrap) {
                result.append(")");
            }
            String string = result.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl", "getTypeText"));
            }
            return string;
        }
        String string = (this.myParameterName == null ? "param" : this.myParameterName) + " is " + (this.myType == null ? "" : this.myType.getTypeText(format));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        if (this.isEquivalentTo(elementType, processingContext)) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl", "isEquivalentToImpl"));
        }
        if (!(type instanceof TypeScriptTypePredicateTypeImpl)) {
            return false;
        }
        TypeScriptTypePredicateTypeImpl typePredicateType = (TypeScriptTypePredicateTypeImpl)type;
        if (typePredicateType.getParameterIndex() == this.getParameterIndex()) {
            if (this.myType == null || typePredicateType.getGuardType() == null) {
                return this.myType == typePredicateType;
            }
            return this.myType.isEquivalentTo(typePredicateType.getGuardType(), processingContext, allowResolve);
        }
        return false;
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        if (this.myType != null) {
            this.myType.accept(visitor);
        }
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        JSType newGuardType;
        if (childTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTransform", "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl", "copyTypeHierarchy"));
        }
        JSType oldGuard = this.getGuardType();
        if (oldGuard == (newGuardType = JSTypeUtils.transformTypeHierarchySafe(oldGuard, childTransform))) {
            TypeScriptTypePredicateTypeImpl typeScriptTypePredicateTypeImpl = this;
            if (typeScriptTypePredicateTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl", "copyTypeHierarchy"));
            }
            return typeScriptTypePredicateTypeImpl;
        }
        TypeScriptTypePredicateTypeImpl typeScriptTypePredicateTypeImpl = new TypeScriptTypePredicateTypeImpl(newGuardType, this.getSource(), this.getParameterName(), this.getParameterIndex());
        if (typeScriptTypePredicateTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl", "copyTypeHierarchy"));
        }
        return typeScriptTypePredicateTypeImpl;
    }

    public JSType asBoolean() {
        return JSNamedType.createType("boolean", this.getSource(), JSContext.INSTANCE);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl", "copyWithNewSource"));
        }
        TypeScriptTypePredicateTypeImpl typeScriptTypePredicateTypeImpl = new TypeScriptTypePredicateTypeImpl(this.getGuardType(), source, this.getParameterName(), this.getParameterIndex());
        if (typeScriptTypePredicateTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl", "copyWithNewSource"));
        }
        return typeScriptTypePredicateTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType jSType = this.asBoolean();
        if (jSType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl", "substitute"));
        }
        return jSType;
    }
}

