/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.watcher;

import com.intellij.ide.macro.FileDirMacro;
import com.intellij.ide.macro.FileNameMacro;
import com.intellij.ide.macro.FileNameWithoutExtension;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UglifyJSTaskConsumer
extends BackgroundTaskConsumer {
    public boolean isAvailable(PsiFile file) {
        return false;
    }

    @NotNull
    public TaskOptions getOptionsTemplate() {
        TaskOptions options = new TaskOptions();
        options.setName("UglifyJS");
        options.setDescription("Compress .js files");
        options.setFileExtension(JavaScriptFileType.INSTANCE.getDefaultExtension());
        options.setScopeName(PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]));
        String nameWithoutExtensionMacro = new FileNameWithoutExtension().getName();
        options.setArguments("$" + new FileNameMacro().getName() + "$ -o $" + nameWithoutExtensionMacro + "$.min.js");
        options.setWorkingDir("$" + new FileDirMacro().getName() + "$");
        options.setOutput("$" + nameWithoutExtensionMacro + "$.min.js");
        TaskOptions taskOptions = options;
        if (taskOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/watcher/UglifyJSTaskConsumer", "getOptionsTemplate"));
        }
        return taskOptions;
    }

    public void additionalConfiguration(@NotNull Project project, @Nullable PsiFile file, @NotNull TaskOptions options) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/watcher/UglifyJSTaskConsumer", "additionalConfiguration"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/lang/javascript/watcher/UglifyJSTaskConsumer", "additionalConfiguration"));
        }
        super.additionalConfiguration(project, file, options);
        options.setProgram(UglifyJSTaskConsumer.findExecutableInPath((String)(SystemInfo.isWindows ? "uglifyjs.cmd" : "uglifyjs")));
    }
}

