/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigUtil {
    public static final String TWO_ASTERISK = "**";
    private static final Key<ParameterizedCachedValue<TypeScriptConfig, PsiFile>> CACHE_KEY = Key.create((String)"TypeScript.PsiFile.To.Config");
    private static final ParameterizedCachedValueProvider<TypeScriptConfig, PsiFile> CACHED_CONFIG_PROVIDER = new ParameterizedCachedValueProvider<TypeScriptConfig, PsiFile>(){

        @Nullable
        public CachedValueProvider.Result<TypeScriptConfig> compute(PsiFile param) {
            VirtualFile file = param.getOriginalFile().getVirtualFile();
            Project project = param.getProject();
            TypeScriptConfig config = file == null ? null : TypeScriptConfigUtil.getConfigForFile(project, file);
            return CachedValueProvider.Result.create((Object)config, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    };

    @Nullable
    private static JsonProperty getFilesProperty(Project project, TypeScriptConfig config) {
        PsiFile file = PsiManager.getInstance((Project)project).findFile(config.getConfigFile());
        return TypeScriptConfigUtil.getProperty(file, "files");
    }

    @Nullable
    private static JsonProperty getIncludeProperty(Project project, TypeScriptConfig config) {
        PsiFile file = PsiManager.getInstance((Project)project).findFile(config.getConfigFile());
        return TypeScriptConfigUtil.getProperty(file, "include");
    }

    @Nullable
    private static JsonProperty getProperty(@Nullable PsiFile file, @NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil", "getProperty"));
        }
        if (file == null) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)PsiTreeUtil.getChildOfType((PsiElement)file, JsonObject.class);
        if (jsonObject == null) {
            return null;
        }
        return jsonObject.findProperty(propertyName);
    }

    public static boolean addVirtualFileToConfigFiles(Project project, VirtualFile file, TypeScriptConfig config) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        assert (!config.isDirectoryBased());
        JsonProperty property = TypeScriptConfigUtil.getFilesProperty(project, config);
        if (property == null && (property = TypeScriptConfigUtil.getIncludeProperty(project, config)) == null) {
            return false;
        }
        JsonArray value = (JsonArray)property.getValue();
        if (value == null) {
            return false;
        }
        List list = value.getValueList();
        if (list.isEmpty()) {
            return false;
        }
        String text = value.getText();
        StringBuilder builder = new StringBuilder(text);
        String path = VfsUtil.getPath((VirtualFile)config.getConfigFile(), (VirtualFile)file, (char)(text.indexOf("/") > 0 ? (char)'/' : (char)File.separatorChar));
        int i = text.lastIndexOf("]");
        builder.insert(i, ",\"" + path + "\"");
        value.replace((PsiElement)TypeScriptConfigUtil.createJSONAndGetPropertyValue(project, builder.toString()));
        return true;
    }

    private static JsonValue createJSONAndGetPropertyValue(Project project, String propertyValue) {
        String tempName = "tempName";
        String json = String.format("{ \"" + tempName + "\":%s }", propertyValue);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)JsonLanguage.INSTANCE, (CharSequence)json);
        JsonProperty property = TypeScriptConfigUtil.getProperty(psiFile, tempName);
        assert (property != null);
        return property.getValue();
    }

    public static String getOutDirectory(VirtualFile baseFile, String relativeOrAbsolutePath) {
        if (StringUtil.isEmpty((String)relativeOrAbsolutePath)) {
            return null;
        }
        if (FileUtil.isAbsolute((String)relativeOrAbsolutePath)) {
            return relativeOrAbsolutePath;
        }
        VirtualFile file = VfsUtil.findRelativeFile((VirtualFile)baseFile, (String[])ArrayUtil.toStringArray((Collection)FileUtil.splitPath((String)FileUtil.toCanonicalPath((String)relativeOrAbsolutePath))));
        return file == null ? null : file.getCanonicalPath();
    }

    @Nullable
    public static TypeScriptConfig getConfigForPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil", "getConfigForPsiFile"));
        }
        if (DumbService.isDumb((Project)file.getProject())) {
            return null;
        }
        return (TypeScriptConfig)CachedValuesManager.getManager((Project)file.getProject()).getParameterizedCachedValue((UserDataHolder)file, CACHE_KEY, CACHED_CONFIG_PROVIDER, false, (Object)file);
    }

    @Nullable
    public static TypeScriptConfig getConfigForFile(@Nullable Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil", "getConfigForFile"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<TypeScriptConfig> filteredConfigs = TypeScriptConfigService.Provider.getConfigInclude(project, file);
        if (filteredConfigs.isEmpty()) {
            return null;
        }
        assert (project != null);
        if (1 == filteredConfigs.size() || filteredConfigs.isEmpty()) {
            return (TypeScriptConfig)ContainerUtil.getFirstItem(filteredConfigs);
        }
        Map configToDirectory = ContainerUtil.newMapFromKeys(filteredConfigs.iterator(), (Convertor)new Convertor<TypeScriptConfig, VirtualFile>(){

            public VirtualFile convert(TypeScriptConfig o) {
                return o.getConfigFile().getParent();
            }
        });
        for (VirtualFile toSearch = file.getParent(); toSearch != null; toSearch = toSearch.getParent()) {
            for (Map.Entry entry : configToDirectory.entrySet()) {
                VirtualFile configDirectory = (VirtualFile)entry.getValue();
                if (!configDirectory.equals(toSearch)) continue;
                return (TypeScriptConfig)entry.getKey();
            }
        }
        return (TypeScriptConfig)ContainerUtil.getFirstItem(filteredConfigs);
    }

    public static String getRegularExpressionForGlobPattern(@NotNull Collection<String> specs, @NotNull VirtualFile baseDirectory, @NotNull WildCardType usage) {
        if (specs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specs", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil", "getRegularExpressionForGlobPattern"));
        }
        if (baseDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDirectory", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil", "getRegularExpressionForGlobPattern"));
        }
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil", "getRegularExpressionForGlobPattern"));
        }
        if (ContainerUtil.isEmpty(specs)) {
            return null;
        }
        StringBuilder pattern = new StringBuilder();
        boolean hasWrittenSubPattern = false;
        block0: for (String spec : specs) {
            if (StringUtil.isEmpty((String)spec)) continue;
            StringBuilder subPattern = new StringBuilder();
            boolean hasRecursiveDirectoryWildcard = false;
            boolean hasWrittenComponent = false;
            List<String> components = TypeScriptConfigUtil.getNormalizedPathComponents(FileUtil.toSystemIndependentName((String)spec), baseDirectory);
            if (usage != WildCardType.EXCLUDE && TWO_ASTERISK.equals(components.get(components.size() - 1))) continue;
            int optionalCount = 0;
            for (String component : components) {
                if (TWO_ASTERISK.equals(component)) {
                    if (hasRecursiveDirectoryWildcard) continue block0;
                    subPattern.append("(\\/.+?)?");
                    hasRecursiveDirectoryWildcard = true;
                    hasWrittenComponent = true;
                    continue;
                }
                if (usage == WildCardType.DIRECTORIES) {
                    subPattern.append('(');
                    ++optionalCount;
                }
                if (hasWrittenComponent) {
                    subPattern.append("\\/");
                }
                subPattern.append(TypeScriptConfigUtil.escapeSymbols(component));
                hasWrittenComponent = true;
            }
            while (optionalCount > 0) {
                subPattern.append(")?");
                --optionalCount;
            }
            if (hasWrittenSubPattern) {
                pattern.append("|");
            }
            pattern.append("(").append((CharSequence)subPattern).append(")");
            hasWrittenSubPattern = true;
        }
        if (StringUtil.isEmpty((CharSequence)pattern)) {
            return null;
        }
        return "^(" + pattern + (usage == WildCardType.EXCLUDE ? ")($|\\/)" : ")$");
    }

    private static String escapeSymbols(String component) {
        String escapedString = StringUtil.escapeToRegexp((String)component);
        escapedString = escapedString.replace("\\*", "[^\\/]*");
        escapedString = escapedString.replace("\\?", "[^\\/]");
        return escapedString;
    }

    private static List<String> getNormalizedPathComponents(String spec, VirtualFile baseDirectory) {
        String stringPath = JSPathMappingsUtil.getStringPathRelativeBaseUrl(baseDirectory, spec);
        int rootLength = TypeScriptConfigUtil.getRootLength(stringPath);
        String root = stringPath.substring(0, rootLength);
        ArrayList result = ContainerUtil.newArrayList((Object[])new String[]{StringUtil.trimEnd((String)root, (char)'/')});
        result.addAll(StringUtil.split((String)stringPath.substring(rootLength), (String)"/"));
        return result;
    }

    private static int getRootLength(@NotNull String absoluteNormalizedPath) {
        if (absoluteNormalizedPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "absoluteNormalizedPath", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil", "getRootLength"));
        }
        if (StringUtil.isEmpty((String)absoluteNormalizedPath)) {
            return 0;
        }
        if (absoluteNormalizedPath.charAt(0) == '/') {
            int p2;
            int p1;
            if (absoluteNormalizedPath.length() > 1 && absoluteNormalizedPath.charAt(1) != '/') {
                return 1;
            }
            int n = p1 = absoluteNormalizedPath.length() > 2 ? absoluteNormalizedPath.indexOf("/", 2) : -1;
            if (p1 < 0) {
                return 2;
            }
            int n2 = p2 = absoluteNormalizedPath.length() > p1 + 1 ? absoluteNormalizedPath.indexOf("/", p1 + 1) : -1;
            if (p2 < 0) {
                return p1 + 1;
            }
            return p2 + 1;
        }
        if (absoluteNormalizedPath.charAt(1) == ':') {
            if (absoluteNormalizedPath.charAt(2) == '/') {
                return 3;
            }
            return 2;
        }
        if (absoluteNormalizedPath.lastIndexOf("file:///", 0) == 0) {
            return "file:///".length();
        }
        int idx = absoluteNormalizedPath.indexOf("://");
        if (idx != -1) {
            return idx + "://".length();
        }
        return 0;
    }

    public static enum WildCardType {
        EXCLUDE,
        DIRECTORIES,
        FILES;

    }
}

