/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class TailRecursionJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TailRecursionJSInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("tail.recursion.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TailRecursionJSInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("tail.recursion.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/TailRecursionJSInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TailRecursionVisitor();
    }

    private static class TailRecursionVisitor
    extends BaseInspectionVisitor {
        private TailRecursionVisitor() {
        }

        public void visitJSReturnStatement(@NotNull JSReturnStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/TailRecursionJSInspection$TailRecursionVisitor", "visitJSReturnStatement"));
            }
            super.visitJSReturnStatement(statement);
            JSExpression returnValue = statement.getExpression();
            if (!(returnValue instanceof JSCallExpression)) {
                return;
            }
            JSFunction containingMethod = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)statement, JSFunction.class);
            if (containingMethod == null) {
                return;
            }
            JSCallExpression returnCall = (JSCallExpression)returnValue;
            JSExpression methodExpression = returnCall.getMethodExpression();
            if (!(methodExpression instanceof JSReferenceExpression)) {
                return;
            }
            JSReferenceExpression reference = (JSReferenceExpression)methodExpression;
            PsiElement referent = reference.resolve();
            if (!(referent instanceof JSFunction)) {
                return;
            }
            JSFunction method = (JSFunction)referent;
            if (!method.equals(containingMethod)) {
                return;
            }
            this.registerFunctionCallError(returnCall);
        }
    }
}

