/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.exception;

import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

class CatchParameterUsedVisitor
extends JSRecursiveElementVisitor {
    private final JSParameter parameter;
    private boolean used = false;

    CatchParameterUsedVisitor(JSParameter variable) {
        this.parameter = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/sixrr/inspectjs/exception/CatchParameterUsedVisitor", "visitElement"));
        }
        if (!this.used) {
            super.visitElement(element);
        }
    }

    public void visitJSReferenceExpression(@NotNull JSReferenceExpression reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/sixrr/inspectjs/exception/CatchParameterUsedVisitor", "visitJSReferenceExpression"));
        }
        if (this.used) {
            return;
        }
        super.visitJSReferenceExpression(reference);
        PsiElement element = reference.resolve();
        if (this.parameter.equals(element)) {
            this.used = true;
        }
    }

    public boolean isUsed() {
        return this.used;
    }
}

