/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionWithInconsistentReturnsJSInspectionBase
extends JavaScriptInspection {
    protected static boolean missingReturnStatementProblem(JSFunction function) {
        return function.getReturnType() != null && DialectDetector.isActionScript((PsiElement)function);
    }

    private static boolean functionHasReturnValues(JSFunction function) {
        ReturnValuesVisitor visitor = new ReturnValuesVisitor(function);
        function.acceptChildren((PsiElementVisitor)visitor);
        return visitor.hasReturnValues();
    }

    private static boolean functionHasValuelessReturns(JSFunction function) {
        PsiElement lastChild = function.getLastChild();
        if (lastChild instanceof JSBlockStatement && ControlFlowUtils.statementMayCompleteNormally((JSStatement)lastChild)) {
            return true;
        }
        ValuelessReturnVisitor visitor = new ValuelessReturnVisitor();
        function.acceptChildren((PsiElementVisitor)visitor);
        return visitor.hasValuelessReturns();
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("function.with.inconsistent.returns.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/validity/FunctionWithInconsistentReturnsJSInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.VALIDITY_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/validity/FunctionWithInconsistentReturnsJSInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)args[0]), JSFunction.class);
        assert (function != null);
        if (FunctionWithInconsistentReturnsJSInspectionBase.missingReturnStatementProblem(function)) {
            return InspectionJSBundle.message("missing.return.statement.error.string", new Object[0]);
        }
        if (this.functionHasIdentifier(function)) {
            return InspectionJSBundle.message("function.has.inconsistent.return.points.error.string", new Object[0]);
        }
        return InspectionJSBundle.message("anonymous.function.has.inconsistent.return.points.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class ValuelessReturnVisitor
    extends JSRecursiveWalkingElementVisitor {
        private boolean hasValuelessReturns = false;

        ValuelessReturnVisitor() {
        }

        public void visitJSReturnStatement(JSReturnStatement statement) {
            super.visitJSReturnStatement(statement);
            if (statement.getExpression() == null) {
                this.hasValuelessReturns = true;
            }
        }

        public void visitJSFunctionDeclaration(JSFunction function) {
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
        }

        public boolean hasValuelessReturns() {
            return this.hasValuelessReturns;
        }
    }

    private static class ReturnValuesVisitor
    extends JSRecursiveWalkingElementVisitor {
        private final JSFunction function;
        private boolean hasReturnValues = false;

        ReturnValuesVisitor(JSFunction function) {
            this.function = function;
        }

        public void visitJSReturnStatement(JSReturnStatement statement) {
            super.visitJSReturnStatement(statement);
            JSExpression expression = statement.getExpression();
            if (expression != null) {
                JSExpression methodExpression;
                if (expression instanceof JSNewExpression && (methodExpression = ((JSNewExpression)expression).getMethodExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).resolve() == this.function) {
                    return;
                }
                this.hasReturnValues = true;
            }
        }

        public void visitJSFunctionDeclaration(JSFunction function) {
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
        }

        public void visitES6FunctionProperty(ES6FunctionProperty functionProperty) {
        }

        public boolean hasReturnValues() {
            return this.hasReturnValues;
        }
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        protected ProblemHighlightType getProblemHighlightType(PsiElement location) {
            DialectOptionHolder dialect = DialectDetector.dialectOfFile(location.getContainingFile());
            return dialect != null && dialect.isECMA4 ? ProblemHighlightType.GENERIC_ERROR : super.getProblemHighlightType(location);
        }

        @Override
        protected void registerFunctionError(JSFunction function) {
            JSSourceElement[] body;
            if (FunctionWithInconsistentReturnsJSInspectionBase.missingReturnStatementProblem(function) && (body = function.getBody()).length > 0 && body[0] instanceof JSBlockStatement) {
                this.registerError(Visitor.findValidEditorLocation(body[0].getLastChild()));
                return;
            }
            super.registerFunctionError(function);
        }

        public void visitJSFunctionDeclaration(JSFunction function) {
            if (DialectDetector.isTypeScript((PsiElement)function)) {
                return;
            }
            super.visitJSFunctionDeclaration(function);
            if (Visitor.functionHasReturnsErrors(function)) {
                this.registerFunctionError(function);
            }
        }

        private static boolean functionHasReturnsErrors(JSFunction function) {
            JSExpression qualifierQualifier;
            JSReferenceExpression referenceExpression;
            JSExpression qualifier;
            JSExpression expression;
            JSAssignmentExpression assignmentExpression;
            JSExpression lOperand;
            JSType type = function.getReturnType();
            if (type == null && !FunctionWithInconsistentReturnsJSInspectionBase.functionHasReturnValues(function)) {
                return false;
            }
            if (type != null && ValidateTypesUtil.emptyReturnIsAcceptable(function, type) || !FunctionWithInconsistentReturnsJSInspectionBase.functionHasValuelessReturns(function)) {
                return false;
            }
            PsiElement parent = function.getParent();
            return !(parent instanceof JSAssignmentExpression) || !((lOperand = (assignmentExpression = (JSAssignmentExpression)parent).getLOperand()) instanceof JSDefinitionExpression) || !((expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression) || !((qualifier = (referenceExpression = (JSReferenceExpression)expression).getQualifier()) instanceof JSReferenceExpression) || !"prototype".equals(((JSReferenceExpression)qualifier).getReferencedName()) || !((qualifierQualifier = ((JSReferenceExpression)qualifier).getQualifier()) instanceof JSReferenceExpression) || !JSSymbolUtil.referencesInterface((JSReferenceExpression)qualifierQualifier, false);
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
            super.visitJSFunctionExpression(node);
            if (Visitor.functionHasReturnsErrors((JSFunction)node)) {
                this.registerFunctionError((JSFunction)node);
            }
        }
    }
}

