/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.JSR45PositionManager;
import com.intellij.debugger.engine.SourcesFinder;
import com.intellij.javaee.deployment.JspDeploymentManager;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultJSPPositionManager
extends JSR45PositionManager<JavaeeFacet[]> {
    @NonNls
    private static final String JSP_STRATUM = "JSP";

    public DefaultJSPPositionManager(DebugProcess debugProcess) {
        this(debugProcess, JavaeeFacetUtil.getInstance().getAllJavaeeFacets(debugProcess.getProject()));
    }

    public DefaultJSPPositionManager(DebugProcess debugProcess, JavaeeFacet[] scope) {
        super(debugProcess, (Object)scope, JSP_STRATUM, new LanguageFileType[]{StdFileTypes.JSP, StdFileTypes.JSPX}, (SourcesFinder)new SourceFinderAdapter());
    }

    private static final class SourceFinderAdapter
    implements SourcesFinder<JavaeeFacet[]> {
        private final JspDeploymentManager myJspDeploymentManager = JspDeploymentManager.getInstance();

        @Nullable
        public PsiFile findSourceFile(String relPath, Project project, JavaeeFacet[] scope) {
            if (this.isJava(relPath)) {
                return null;
            }
            return this.myJspDeploymentManager.getDeployedJspSource(relPath, project, scope);
        }

        private boolean isJava(String relPath) {
            for (FileNameMatcher matcher : FileTypeManager.getInstance().getAssociations((FileType)StdFileTypes.JAVA)) {
                if (!matcher.accept(relPath)) continue;
                return true;
            }
            return false;
        }
    }
}

