/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.javaee.model.JavaeeResolvingConverter;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ModuleContextProvider;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EjbResolveConverter
extends JavaeeResolvingConverter<EnterpriseBean> {
    private boolean myAllowEntityBeans;
    private boolean myAllowSessionBeans;
    private boolean myAllowMessageDrivenBeans;

    public EjbResolveConverter() {
        this(true, true, true);
    }

    protected EjbResolveConverter(boolean allowEntityBeans, boolean allowMessageDrivenBeans, boolean allowSessionBeans) {
        this.myAllowEntityBeans = allowEntityBeans;
        this.myAllowMessageDrivenBeans = allowMessageDrivenBeans;
        this.myAllowSessionBeans = allowSessionBeans;
    }

    public EnterpriseBean fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        EnterpriseBean[] result = new EnterpriseBean[]{null};
        this.processBeans(context, (Processor<EnterpriseBean>)((Processor)enterpriseBean -> {
            if (Comparing.equal((String)s, (String)((String)enterpriseBean.getEjbName().getValue()))) {
                result[0] = enterpriseBean;
                return false;
            }
            return true;
        }));
        return result[0];
    }

    private Module[] getContextModules(ConvertContext context) {
        DomElement domElement = context.getInvocationElement();
        if (domElement.getManager().isMockElement(domElement)) {
            return new Module[]{domElement.getModule()};
        }
        return ModuleContextProvider.getModules((PsiFile)context.getFile());
    }

    private void processBeans(ConvertContext context, Processor<EnterpriseBean> processor) {
        for (Module contextModule : this.getContextModules(context)) {
            List<EnterpriseBean> list = EjbCommonModelUtil.getAllEjbs(context.getProject(), contextModule, null);
            for (EnterpriseBean bean : list) {
                if (this.myAllowEntityBeans && bean instanceof EntityBean && !processor.process((Object)bean)) {
                    return;
                }
                if (this.myAllowSessionBeans && bean instanceof SessionBean && !processor.process((Object)bean)) {
                    return;
                }
                if (!this.myAllowMessageDrivenBeans || !(bean instanceof MessageDrivenBean) || processor.process((Object)bean)) continue;
                return;
            }
        }
    }

    public String getErrorMessage(String s, ConvertContext context) {
        return CodeInsightBundle.message((String)"error.cannot.resolve.0.1", (Object[])new Object[]{"EJB", s});
    }

    @NotNull
    public Collection<? extends EnterpriseBean> getVariants(ConvertContext context) {
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processBeans(context, (Processor<EnterpriseBean>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/EjbResolveConverter", "getVariants"));
        }
        return collection;
    }
}

