/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.guice.constants.GuiceAnnotations;
import com.intellij.guice.model.InjectionPointDescriptor;
import com.intellij.guice.model.beans.BindDescriptor;
import com.intellij.guice.model.jam.GuiceInject;
import com.intellij.guice.model.jam.GuiceProvides;
import com.intellij.guice.utils.GuiceUtils;
import com.intellij.jam.JamService;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiceInjectionUtil {
    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/guice/model/GuiceInjectionUtil", "getInjectionPoints"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/guice/model/GuiceInjectionUtil", "getInjectionPoints"));
        }
        HashSet ips = new HashSet();
        JamService service = JamService.getJamService((Project)project);
        for (String injectAnno : GuiceAnnotations.INJECTS) {
            for (GuiceInject inject : service.getJamFieldElements(GuiceInject.FIELD_META, injectAnno, scope)) {
                ips.addAll(inject.getInjectionPoints());
            }
            for (GuiceInject inject : service.getJamMethodElements(GuiceInject.METHOD_META, injectAnno, scope)) {
                ips.addAll(inject.getInjectionPoints());
            }
        }
        return ips;
    }

    @NotNull
    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/guice/model/GuiceInjectionUtil", "getInjectionPoints"));
        }
        Set<InjectionPointDescriptor> set = GuiceInjectionUtil.getInjectionPoints(psiClass, true);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectionUtil", "getInjectionPoints"));
        }
        return set;
    }

    @NotNull
    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull PsiClass psiClass, boolean checkDeep) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/guice/model/GuiceInjectionUtil", "getInjectionPoints"));
        }
        HashSet ips = new HashSet();
        JamService service = JamService.getJamService((Project)psiClass.getProject());
        if (psiClass.isValid()) {
            for (GuiceInject inject : service.getAnnotatedMembersList(psiClass, GuiceInject.SEM_KEY, true, true, true, checkDeep)) {
                ips.addAll(inject.getInjectionPoints());
            }
        }
        HashSet hashSet = ips;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectionUtil", "getInjectionPoints"));
        }
        return hashSet;
    }

    @NotNull
    public static List<GuiceProvides> getProvides(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/guice/model/GuiceInjectionUtil", "getProvides"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/guice/model/GuiceInjectionUtil", "getProvides"));
        }
        JamService service = JamService.getJamService((Project)project);
        List list = service.getJamMethodElements(GuiceProvides.METHOD_META, "com.google.inject.Provides", scope);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectionUtil", "getProvides"));
        }
        return list;
    }

    @NotNull
    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull BindDescriptor descriptor, @NotNull Set<InjectionPointDescriptor> allInjectionPointDescriptors) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/guice/model/GuiceInjectionUtil", "getInjectionPoints"));
        }
        if (allInjectionPointDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allInjectionPointDescriptors", "com/intellij/guice/model/GuiceInjectionUtil", "getInjectionPoints"));
        }
        java.util.HashSet ips = ContainerUtil.newHashSet();
        for (InjectionPointDescriptor ip : allInjectionPointDescriptors) {
            PsiClass psiClass;
            PsiType type = ip.getType();
            if (!(type instanceof PsiClassType) || (psiClass = ((PsiClassType)type).resolve()) == null || !psiClass.equals(descriptor.getBoundClass()) || !GuiceInjectionUtil.checkBindingAnnotations(ip, descriptor)) continue;
            ips.add(ip);
        }
        java.util.HashSet hashSet = ips;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectionUtil", "getInjectionPoints"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull GuiceProvides provides, @NotNull Set<InjectionPointDescriptor> allInjectionPointDescriptors) {
        if (provides == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provides", "com/intellij/guice/model/GuiceInjectionUtil", "getInjectionPoints"));
        }
        if (allInjectionPointDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allInjectionPointDescriptors", "com/intellij/guice/model/GuiceInjectionUtil", "getInjectionPoints"));
        }
        java.util.HashSet ips = ContainerUtil.newHashSet();
        PsiType productType = provides.getProductType();
        if (productType != null) {
            for (InjectionPointDescriptor ip : allInjectionPointDescriptors) {
                PsiType type = ip.getType();
                if (type == null || !productType.isAssignableFrom(type) || !GuiceInjectionUtil.checkBindingAnnotations(ip.getBindingAnnotations(), provides.getBindingAnnotations())) continue;
                ips.add(ip);
            }
        }
        java.util.HashSet hashSet = ips;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectionUtil", "getInjectionPoints"));
        }
        return hashSet;
    }

    public static boolean checkBindingAnnotations(@NotNull Set<PsiAnnotation> annotations, @NotNull Set<PsiAnnotation> candidateAnnotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/guice/model/GuiceInjectionUtil", "checkBindingAnnotations"));
        }
        if (candidateAnnotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateAnnotations", "com/intellij/guice/model/GuiceInjectionUtil", "checkBindingAnnotations"));
        }
        if (annotations.size() != candidateAnnotations.size()) {
            return false;
        }
        for (PsiAnnotation psiAnnotation : annotations) {
            boolean hasAnno = false;
            for (PsiAnnotation annotation : candidateAnnotations) {
                if (!GuiceInjectionUtil.compareAnnotations(psiAnnotation, annotation)) continue;
                hasAnno = true;
                break;
            }
            if (hasAnno) continue;
            return false;
        }
        return true;
    }

    private static boolean compareAnnotations(@NotNull PsiAnnotation anno, @NotNull PsiAnnotation candidateAnno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/guice/model/GuiceInjectionUtil", "compareAnnotations"));
        }
        if (candidateAnno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateAnno", "com/intellij/guice/model/GuiceInjectionUtil", "compareAnnotations"));
        }
        String fqn1 = anno.getQualifiedName();
        if (fqn1 != null && fqn1.equals(candidateAnno.getQualifiedName())) {
            return GuiceInjectionUtil.compareAnnotationAttributes(GuiceInjectionUtil.getAnnotationAttributeValues(anno), GuiceInjectionUtil.getAnnotationAttributeValues(candidateAnno));
        }
        return false;
    }

    private static boolean compareAnnotationAttributes(@NotNull Set<Pair<String, PsiAnnotationMemberValue>> attrs, @NotNull Set<Pair<String, PsiAnnotationMemberValue>> candidateAttrs) {
        if (attrs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrs", "com/intellij/guice/model/GuiceInjectionUtil", "compareAnnotationAttributes"));
        }
        if (candidateAttrs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateAttrs", "com/intellij/guice/model/GuiceInjectionUtil", "compareAnnotationAttributes"));
        }
        if (attrs.size() == 0 && candidateAttrs.size() == 0) {
            return true;
        }
        for (Pair<String, PsiAnnotationMemberValue> valuePair_1 : attrs) {
            for (Pair<String, PsiAnnotationMemberValue> valuePair_2 : candidateAttrs) {
                if (!((String)valuePair_1.first).equals(valuePair_2.first)) continue;
                PsiAnnotationMemberValue value_1 = (PsiAnnotationMemberValue)valuePair_1.getSecond();
                PsiAnnotationMemberValue value_2 = (PsiAnnotationMemberValue)valuePair_2.getSecond();
                if (value_1 instanceof PsiReference) {
                    if (value_2 instanceof PsiReference) {
                        PsiElement element1 = ((PsiReference)value_1).resolve();
                        PsiElement element2 = ((PsiReference)value_2).resolve();
                        return element1 != null && element2 != null && element1.equals(element2);
                    }
                } else {
                    Object attrValue = JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)value_1, Object.class);
                    Object candidateAttrValue = JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)value_2, Object.class);
                    return attrValue != null && candidateAttrValue != null && attrValue.equals(candidateAttrValue);
                }
                return false;
            }
        }
        return false;
    }

    @NotNull
    private static Set<Pair<String, PsiAnnotationMemberValue>> getAnnotationAttributeValues(@NotNull PsiAnnotation annotation) {
        PsiElement resolved;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/guice/model/GuiceInjectionUtil", "getAnnotationAttributeValues"));
        }
        java.util.HashSet<Pair<String, PsiAnnotationMemberValue>> pairs = new java.util.HashSet<Pair<String, PsiAnnotationMemberValue>>();
        PsiJavaCodeReferenceElement referenceElement = annotation.getNameReferenceElement();
        if (referenceElement != null && (resolved = referenceElement.resolve()) != null) {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = ((PsiClass)resolved).getMethods()) {
                if (!PsiUtil.isAnnotationMethod((PsiElement)psiMethod)) continue;
                String attributeName = psiMethod.getName();
                pairs.add((Pair<String, PsiAnnotationMemberValue>)Pair.create((Object)attributeName, (Object)annotation.findAttributeValue(attributeName)));
            }
        }
        java.util.HashSet<Pair<String, PsiAnnotationMemberValue>> hashSet = pairs;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/model/GuiceInjectionUtil", "getAnnotationAttributeValues"));
        }
        return hashSet;
    }

    public static boolean checkBindingAnnotations(InjectionPointDescriptor ip, @NotNull BindDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/guice/model/GuiceInjectionUtil", "checkBindingAnnotations"));
        }
        Set<PsiAnnotation> bindingAnnotations = ip.getBindingAnnotations();
        if (bindingAnnotations.size() > 1) {
            return false;
        }
        PsiMethodCallExpression expression = descriptor.getBindExpression();
        PsiClass annotatedWith = GuiceInjectionUtil.getCallExpressionType(expression, "annotatedWith");
        if (annotatedWith == null && bindingAnnotations.size() == 0) {
            return true;
        }
        if (annotatedWith != null && bindingAnnotations.size() == 1) {
            PsiAnnotation bindingAnno = bindingAnnotations.iterator().next();
            if ("com.google.inject.name.Named".equals(annotatedWith.getQualifiedName())) {
                PsiExpression annotatedWithExpression;
                if ("com.google.inject.name.Named".equals(bindingAnno.getQualifiedName()) && (annotatedWithExpression = GuiceUtils.getArgumentOfCallInChain(expression, "annotatedWith")) != null) {
                    String nameValue = GuiceInjectionUtil.getNameValue(annotatedWithExpression);
                    if (nameValue == null) {
                        return true;
                    }
                    return nameValue.equals(AnnotationUtil.getStringAttributeValue((PsiAnnotation)bindingAnno, (String)"value"));
                }
                return false;
            }
            String bindingAnnoQualifiedName = bindingAnno.getQualifiedName();
            if (bindingAnnoQualifiedName != null) {
                return bindingAnnoQualifiedName.equals(annotatedWith.getQualifiedName());
            }
        }
        return false;
    }

    @Nullable
    private static String getNameValue(@NotNull PsiExpression annotatedWithExpression) {
        Pair pair;
        if (annotatedWithExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotatedWithExpression", "com/intellij/guice/model/GuiceInjectionUtil", "getNameValue"));
        }
        PsiExpression namedExpression = GuiceInjectionUtil.findNamedExpression(annotatedWithExpression);
        if (namedExpression != null && (pair = StringExpressionHelper.evaluateExpression((PsiElement)namedExpression)) != null) {
            return (String)pair.getSecond();
        }
        return null;
    }

    @Nullable
    public static PsiExpression findNamedExpression(PsiExpression annotatedWithExpression) {
        PsiExpression initializer;
        PsiElement resolve;
        if (annotatedWithExpression instanceof PsiMethodCallExpression) {
            PsiExpression named;
            PsiMethodCallExpression expression = (PsiMethodCallExpression)annotatedWithExpression;
            PsiMethod method = expression.resolveMethod();
            if (method != null) {
                if ("named".equals(method.getName())) {
                    PsiExpression[] expressions = expression.getArgumentList().getExpressions();
                    return expressions.length > 0 ? expressions[0] : null;
                }
                PsiCodeBlock body = method.getBody();
                if (body != null) {
                    HashSet returns = new HashSet();
                    body.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((Set)returns){
                        final /* synthetic */ Set val$returns;
                        {
                            this.val$returns = set;
                        }

                        public void visitClass(PsiClass aClass) {
                        }

                        public void visitLambdaExpression(PsiLambdaExpression expression) {
                        }

                        public void visitReturnStatement(PsiReturnStatement statement) {
                            PsiExpression returnValue = statement.getReturnValue();
                            if (returnValue != null) {
                                this.val$returns.add(returnValue);
                            }
                        }
                    });
                    for (PsiExpression psiExpression : returns) {
                        PsiExpression namedExpression = GuiceInjectionUtil.findNamedExpression(psiExpression);
                        if (namedExpression == null) continue;
                        return namedExpression;
                    }
                }
            }
            if ((named = GuiceUtils.getArgumentOfCallInChain(expression, "named")) != null) {
                return named;
            }
        }
        if (annotatedWithExpression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)annotatedWithExpression).resolve()) instanceof PsiVariable && (initializer = ((PsiVariable)resolve).getInitializer()) != null) {
            return GuiceInjectionUtil.findNamedExpression(initializer);
        }
        return null;
    }

    @Nullable
    public static PsiClass getCallExpressionType(@NotNull PsiMethodCallExpression expression, String name) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/guice/model/GuiceInjectionUtil", "getCallExpressionType"));
        }
        PsiClass aClass = null;
        PsiExpression psiExpression = GuiceUtils.getArgumentOfCallInChain(expression, name);
        if (psiExpression != null) {
            if (psiExpression instanceof PsiClassObjectAccessExpression) {
                PsiType classType = ((PsiClassObjectAccessExpression)psiExpression).getOperand().getType();
                if (classType instanceof PsiClassType) {
                    aClass = ((PsiClassType)classType).resolve();
                }
            } else {
                PsiType psiType = psiExpression.getType();
                if (psiType instanceof PsiClassType) {
                    aClass = ((PsiClassType)psiType).resolve();
                }
            }
        }
        return aClass;
    }
}

