/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.graph;

import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.builder.components.BasicNodesGroup;
import com.intellij.openapi.graph.view.NodeLabel;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.action.Result;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.dom.struts.strutspackage.StrutsPackage;
import com.intellij.struts2.graph.beans.ActionNode;
import com.intellij.struts2.graph.beans.BasicStrutsEdge;
import com.intellij.struts2.graph.beans.BasicStrutsNode;
import com.intellij.struts2.graph.beans.ResultNode;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsDataModel
extends GraphDataModel<BasicStrutsNode, BasicStrutsEdge> {
    private final Set<BasicStrutsNode> myNodes = new HashSet();
    private final Set<BasicStrutsEdge> myEdges = new HashSet();
    private final Map<PsiFile, NodesGroup> myGroups = new HashMap<PsiFile, NodesGroup>();
    private final Project myProject;
    private final XmlFile myFile;
    @NonNls
    private static final String UNKNOWN = "???";

    public StrutsDataModel(XmlFile file) {
        this.myFile = file;
        this.myProject = file.getProject();
    }

    @NotNull
    public Collection<BasicStrutsNode> getNodes() {
        this.refreshDataModel();
        Set<BasicStrutsNode> set = this.myNodes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/graph/StrutsDataModel", "getNodes"));
        }
        return set;
    }

    @NotNull
    public Collection<BasicStrutsEdge> getEdges() {
        Set<BasicStrutsEdge> set = this.myEdges;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/graph/StrutsDataModel", "getEdges"));
        }
        return set;
    }

    @NotNull
    public BasicStrutsNode getSourceNode(BasicStrutsEdge edge) {
        BasicStrutsNode basicStrutsNode = edge.getSource();
        if (basicStrutsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/graph/StrutsDataModel", "getSourceNode"));
        }
        return basicStrutsNode;
    }

    @NotNull
    public BasicStrutsNode getTargetNode(BasicStrutsEdge edge) {
        BasicStrutsNode basicStrutsNode = edge.getTarget();
        if (basicStrutsNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/graph/StrutsDataModel", "getTargetNode"));
        }
        return basicStrutsNode;
    }

    @NotNull
    public String getNodeName(BasicStrutsNode node) {
        String string = node.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/graph/StrutsDataModel", "getNodeName"));
        }
        return string;
    }

    @NotNull
    public String getEdgeName(BasicStrutsEdge edge) {
        String string = edge.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/graph/StrutsDataModel", "getEdgeName"));
        }
        return string;
    }

    public BasicStrutsEdge createEdge(@NotNull BasicStrutsNode from, @NotNull BasicStrutsNode to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/struts2/graph/StrutsDataModel", "createEdge"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/struts2/graph/StrutsDataModel", "createEdge"));
        }
        return null;
    }

    public void dispose() {
    }

    private void refreshDataModel() {
        this.myNodes.clear();
        this.myEdges.clear();
        this.updateDataModel();
    }

    public NodesGroup getGroup(BasicStrutsNode basicStrutsNode) {
        if (this.isGroupElements()) {
            XmlElement xmlElement = basicStrutsNode.getIdentifyingElement().getXmlElement();
            assert (xmlElement != null);
            return this.myGroups.get(xmlElement.getContainingFile());
        }
        return super.getGroup((Object)basicStrutsNode);
    }

    private void addNode(BasicStrutsNode node) {
        if (!node.getIdentifyingElement().isValid()) {
            return;
        }
        this.myNodes.add(node);
        if (this.isGroupElements()) {
            XmlElement element = node.getIdentifyingElement().getXmlElement();
            assert (element != null);
            PsiFile file = element.getContainingFile();
            if (file != null && !this.myGroups.containsKey(file)) {
                String name = file.getName();
                BasicNodesGroup group = new BasicNodesGroup(name){

                    @Nullable
                    public GroupNodeRealizer getGroupNodeRealizer() {
                        GroupNodeRealizer groupNodeRealizer = super.getGroupNodeRealizer();
                        assert (groupNodeRealizer != null);
                        NodeLabel nodeLabel = groupNodeRealizer.getLabel();
                        nodeLabel.setText("      " + this.getGroupName());
                        nodeLabel.setModel(NodeLabel.INTERNAL);
                        nodeLabel.setPosition(NodeLabel.TOP_RIGHT);
                        return groupNodeRealizer;
                    }
                };
                group.setClosed(file != this.myFile);
                this.myGroups.put(file, (NodesGroup)group);
            }
        }
    }

    private boolean isGroupElements() {
        return true;
    }

    private void addEdge(BasicStrutsEdge edge) {
        if (!edge.getSource().getIdentifyingElement().isValid() || !edge.getTarget().getIdentifyingElement().isValid()) {
            return;
        }
        this.myEdges.add(edge);
    }

    private void updateDataModel() {
        StrutsModel model = StrutsManager.getInstance(this.myProject).getModelByFile(this.myFile);
        if (model == null) {
            return;
        }
        for (StrutsPackage strutsPackage : model.getStrutsPackages()) {
            for (Action action : strutsPackage.getActions()) {
                ActionNode actionNode = new ActionNode(action, action.getName().getStringValue());
                this.addNode(actionNode);
                for (Result result : action.getResults()) {
                    PathReference pathReference = (PathReference)result.getValue();
                    String path = pathReference != null ? pathReference.getPath() : UNKNOWN;
                    ResultNode resultNode = new ResultNode(result, path);
                    this.addNode(resultNode);
                    String resultName = result.getName().getStringValue();
                    this.addEdge(new BasicStrutsEdge(actionNode, resultNode, resultName != null ? resultName : "success"));
                }
            }
        }
    }
}

