/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.model.constant.contributor;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.struts2.model.constant.ConstantValueConverterClassContributor;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConstantValueClassConverter
extends ResolvingConverter<PsiClass>
implements CustomReferenceConverter {
    private final JavaClassReferenceProvider javaClassReferenceProvider = new JavaClassReferenceProvider();
    private final Map<String, String> shortCutToPsiClassMap;
    private final boolean hasShortCuts;

    ConstantValueClassConverter(@NonNls String baseClass, Map<String, String> shortCutToPsiClassMap) {
        this.shortCutToPsiClassMap = shortCutToPsiClassMap;
        this.hasShortCuts = !shortCutToPsiClassMap.isEmpty();
        this.javaClassReferenceProvider.setSoft(true);
        this.javaClassReferenceProvider.setAllowEmpty(false);
        this.javaClassReferenceProvider.setOption(JavaClassReferenceProvider.CONCRETE, (Object)Boolean.TRUE);
        this.javaClassReferenceProvider.setOption(JavaClassReferenceProvider.NOT_INTERFACE, (Object)Boolean.TRUE);
        this.javaClassReferenceProvider.setOption(JavaClassReferenceProvider.EXTEND_CLASS_NAMES, (Object)new String[]{baseClass});
    }

    @NotNull
    public Collection<? extends PsiClass> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/model/constant/contributor/ConstantValueClassConverter", "getVariants"));
        }
        return list;
    }

    public PsiClass fromString(@Nullable @NonNls String s, ConvertContext convertContext) {
        String string;
        if (s == null) {
            return null;
        }
        if (this.hasShortCuts && StringUtil.isNotEmpty((String)(string = this.shortCutToPsiClassMap.get(s)))) {
            return DomJavaUtil.findClass((String)string, (DomElement)convertContext.getInvocationElement());
        }
        for (ConstantValueConverterClassContributor converterClassContributor : (ConstantValueConverterClassContributor[])Extensions.getExtensions(ConstantValueConverterClassContributor.EP_NAME)) {
            PsiClass contributorClass = converterClassContributor.fromString(s, convertContext);
            if (contributorClass == null) continue;
            return contributorClass;
        }
        PsiClass psiClass = DomJavaUtil.findClass((String)s, (DomElement)convertContext.getInvocationElement());
        if (psiClass == null) {
            return null;
        }
        return !psiClass.isInterface() && !psiClass.hasModifierProperty("abstract") ? psiClass : null;
    }

    public String toString(@Nullable PsiClass aClass, ConvertContext context) {
        return aClass == null ? null : aClass.getName();
    }

    @NotNull
    public Set<String> getAdditionalVariants(@NotNull ConvertContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts2/model/constant/contributor/ConstantValueClassConverter", "getAdditionalVariants"));
        }
        Set<String> set = this.shortCutToPsiClassMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/model/constant/contributor/ConstantValueClassConverter", "getAdditionalVariants"));
        }
        return set;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue value, PsiElement element, ConvertContext context) {
        Object[] references = this.javaClassReferenceProvider.getReferencesByElement(element);
        PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.append((Object[])references, (Object)new GenericDomValueReference(value), (ArrayFactory)PsiReference.ARRAY_FACTORY);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/model/constant/contributor/ConstantValueClassConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return CodeInsightBundle.message((String)"error.cannot.resolve.class", (Object[])new Object[]{s});
    }
}

