/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.structure;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.impl.xml.XmlFileTreeElement;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.StrutsBundle;
import com.intellij.struts2.dom.params.Param;
import com.intellij.struts2.structure.StructureViewTreeElement;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.structure.DomStructureTreeElement;
import com.intellij.util.xml.structure.DomStructureViewTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StructureViewTreeModel
extends DomStructureViewTreeModel
implements StructureViewModel.ElementInfoProvider {
    static final String HIDE_PARAMS_ID = StrutsBundle.message("structure.view.filter.params", new Object[0]);
    private final Class[] alwaysPlus;
    private final Class[] alwaysLeaf;

    StructureViewTreeModel(@NotNull XmlFile xmlFile, @Nullable Editor editor, @NotNull Class[] alwaysPlus, @NotNull Class[] alwaysLeaf, Function<DomElement, DomService.StructureViewMode> descriptor) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/struts2/structure/StructureViewTreeModel", "<init>"));
        }
        if (alwaysPlus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alwaysPlus", "com/intellij/struts2/structure/StructureViewTreeModel", "<init>"));
        }
        if (alwaysLeaf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alwaysLeaf", "com/intellij/struts2/structure/StructureViewTreeModel", "<init>"));
        }
        super(xmlFile, descriptor, editor);
        this.alwaysPlus = alwaysPlus;
        this.alwaysLeaf = alwaysLeaf;
    }

    @NotNull
    public com.intellij.ide.structureView.StructureViewTreeElement getRoot() {
        XmlFile xmlFile = this.getPsiFile();
        DomFileElement fileElement = DomManager.getDomManager((Project)xmlFile.getProject()).getFileElement(xmlFile, DomElement.class);
        if (fileElement == null) {
            XmlFileTreeElement xmlFileTreeElement = new XmlFileTreeElement(xmlFile);
            if (xmlFileTreeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/structure/StructureViewTreeModel", "getRoot"));
            }
            return xmlFileTreeElement;
        }
        StructureViewTreeElement structureViewTreeElement = new StructureViewTreeElement(fileElement.getRootElement().createStableCopy());
        if (structureViewTreeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/structure/StructureViewTreeModel", "getRoot"));
        }
        return structureViewTreeElement;
    }

    @NotNull
    public Filter[] getFilters() {
        Filter[] filterArray = new Filter[]{new Filter(){

            public boolean isVisible(TreeElement treeElement) {
                DomStructureTreeElement domStructureTreeElement = (DomStructureTreeElement)treeElement;
                return !(domStructureTreeElement.getElement() instanceof Param);
            }

            public boolean isReverted() {
                return false;
            }

            @NotNull
            public ActionPresentation getPresentation() {
                ActionPresentationData actionPresentationData = new ActionPresentationData(StrutsBundle.message("structure.view.filter.params", new Object[0]), StrutsBundle.message("structure.view.filter.params", new Object[0]), AllIcons.Actions.Properties);
                if (actionPresentationData == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/structure/StructureViewTreeModel$1", "getPresentation"));
                }
                return actionPresentationData;
            }

            @NotNull
            public String getName() {
                String string = HIDE_PARAMS_ID;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/structure/StructureViewTreeModel$1", "getName"));
                }
                return string;
            }
        }};
        if (filterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/structure/StructureViewTreeModel", "getFilters"));
        }
        return filterArray;
    }

    public boolean isAlwaysShowsPlus(com.intellij.ide.structureView.StructureViewTreeElement element) {
        return StructureViewTreeModel.isDomElementOfKind(element, this.alwaysPlus);
    }

    public boolean isAlwaysLeaf(com.intellij.ide.structureView.StructureViewTreeElement element) {
        return StructureViewTreeModel.isDomElementOfKind(element, this.alwaysLeaf);
    }

    private static boolean isDomElementOfKind(com.intellij.ide.structureView.StructureViewTreeElement element, Class ... kinds) {
        DomElement domElement = ((DomStructureTreeElement)element).getElement();
        for (Class clazz : kinds) {
            if (!clazz.isInstance(domElement)) continue;
            return true;
        }
        return false;
    }
}

