/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.android.ddmlib.IDevice;
import org.jetbrains.annotations.NotNull;

class AndroidDbConnectionInfo {
    private final IDevice myDevice;
    private final String myPackageName;
    private final String myDbName;
    private final boolean myExternal;

    public AndroidDbConnectionInfo(@NotNull IDevice device, @NotNull String packageName, @NotNull String dbName, boolean external) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/database/AndroidDbConnectionInfo", "<init>"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/database/AndroidDbConnectionInfo", "<init>"));
        }
        if (dbName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbName", "org/jetbrains/android/database/AndroidDbConnectionInfo", "<init>"));
        }
        this.myDevice = device;
        this.myPackageName = packageName;
        this.myDbName = dbName;
        this.myExternal = external;
    }

    @NotNull
    public IDevice getDevice() {
        IDevice iDevice = this.myDevice;
        if (iDevice == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbConnectionInfo", "getDevice"));
        }
        return iDevice;
    }

    @NotNull
    public String getPackageName() {
        String string = this.myPackageName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbConnectionInfo", "getPackageName"));
        }
        return string;
    }

    @NotNull
    public String getDbName() {
        String string = this.myDbName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidDbConnectionInfo", "getDbName"));
        }
        return string;
    }

    public boolean isExternal() {
        return this.myExternal;
    }
}

