/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.database.AndroidRemoteDbInfo;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="AndroidRemoteDataBaseManager", storages={@Storage(value="androidRemoteDatabases.xml")})
public class AndroidRemoteDataBaseManager
implements PersistentStateComponent<State> {
    private State myState = new State();

    public static synchronized AndroidRemoteDataBaseManager getInstance() {
        return (AndroidRemoteDataBaseManager)ServiceManager.getService(AndroidRemoteDataBaseManager.class);
    }

    @NotNull
    public static String buildLocalDbFileOsPath(@Nullable String deviceId, @Nullable String packageName, @Nullable String databaseName, boolean external) {
        if (deviceId == null || packageName == null || databaseName == null || deviceId.length() == 0 || packageName.length() == 0 || databaseName.length() == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidRemoteDataBaseManager", "buildLocalDbFileOsPath"));
            }
            return "";
        }
        String string = AndroidUtils.getAndroidSystemDirectoryOsPath() + File.separator + "databases" + File.separator + deviceId + File.separator + packageName + File.separator + (external ? "external" : "internal") + File.separator + databaseName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/database/AndroidRemoteDataBaseManager", "buildLocalDbFileOsPath"));
        }
        return string;
    }

    public synchronized void processRemovedProjects() {
        ArrayList<MyDbKey> keysToRemove = new ArrayList<MyDbKey>();
        for (Map.Entry<MyDbKey, MyDatabaseInfo> entry : this.myState.databases.entrySet()) {
            MyDbKey key = entry.getKey();
            MyDatabaseInfo value = entry.getValue();
            Iterator<String> it = value.referringProjects.iterator();
            while (it.hasNext()) {
                String projectBasePath = it.next();
                if (new File(projectBasePath).exists()) continue;
                it.remove();
                keysToRemove.add(key);
            }
        }
        this.removeUnusedDatabases(keysToRemove);
    }

    public synchronized void updateDbUsagesForProject(@NotNull String projectBasePath, @NotNull Set<AndroidRemoteDbInfo> usedDatabases) {
        if (projectBasePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectBasePath", "org/jetbrains/android/database/AndroidRemoteDataBaseManager", "updateDbUsagesForProject"));
        }
        if (usedDatabases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usedDatabases", "org/jetbrains/android/database/AndroidRemoteDataBaseManager", "updateDbUsagesForProject"));
        }
        ArrayList<MyDbKey> keysToRemove = new ArrayList<MyDbKey>();
        for (Map.Entry<MyDbKey, MyDatabaseInfo> entry : this.myState.databases.entrySet()) {
            MyDbKey key = entry.getKey();
            MyDatabaseInfo value = entry.getValue();
            if (!value.referringProjects.contains(projectBasePath) || usedDatabases.contains(new AndroidRemoteDbInfo(key.deviceId, key.packageName, key.databaseName, key.external))) continue;
            value.referringProjects.remove(projectBasePath);
            keysToRemove.add(key);
        }
        this.removeUnusedDatabases(keysToRemove);
    }

    private synchronized void removeUnusedDatabases(@NotNull List<MyDbKey> keysToRemove) {
        if (keysToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keysToRemove", "org/jetbrains/android/database/AndroidRemoteDataBaseManager", "removeUnusedDatabases"));
        }
        Map<MyDbKey, MyDatabaseInfo> dbMap = this.myState.databases;
        Iterator<MyDbKey> it = keysToRemove.iterator();
        while (it.hasNext()) {
            MyDbKey key = it.next();
            MyDatabaseInfo value = dbMap.get(key);
            if (!value.referringProjects.isEmpty()) continue;
            it.remove();
            String localDbPath = AndroidRemoteDataBaseManager.buildLocalDbFileOsPath(key.deviceId, key.packageName, key.databaseName, key.external);
            File localDbFile = new File(localDbPath);
            if (!localDbFile.exists()) continue;
            FileUtil.delete((File)localDbFile);
        }
    }

    @Nullable
    public synchronized MyDatabaseInfo getDatabaseInfo(@NotNull String deviceId, @NotNull String packageName, @NotNull String databaseName, boolean external) {
        if (deviceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceId", "org/jetbrains/android/database/AndroidRemoteDataBaseManager", "getDatabaseInfo"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/database/AndroidRemoteDataBaseManager", "getDatabaseInfo"));
        }
        if (databaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseName", "org/jetbrains/android/database/AndroidRemoteDataBaseManager", "getDatabaseInfo"));
        }
        return this.myState.databases.get(new MyDbKey(deviceId, packageName, databaseName, external));
    }

    public synchronized void setDatabaseInfo(@NotNull String deviceId, @NotNull String packageName, @NotNull String databaseName, @NotNull MyDatabaseInfo databaseInfo, boolean external) {
        if (deviceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceId", "org/jetbrains/android/database/AndroidRemoteDataBaseManager", "setDatabaseInfo"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/database/AndroidRemoteDataBaseManager", "setDatabaseInfo"));
        }
        if (databaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseName", "org/jetbrains/android/database/AndroidRemoteDataBaseManager", "setDatabaseInfo"));
        }
        if (databaseInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseInfo", "org/jetbrains/android/database/AndroidRemoteDataBaseManager", "setDatabaseInfo"));
        }
        this.myState.databases.put(new MyDbKey(deviceId, packageName, databaseName, external), databaseInfo);
    }

    public synchronized State getState() {
        return this.myState;
    }

    public synchronized void loadState(State state) {
        this.myState = state;
    }

    @Tag(value="db-info")
    public static class MyDatabaseInfo {
        public long modificationTime = 0L;
        public Set<String> referringProjects = new HashSet();
    }

    @Tag(value="db-key")
    public static class MyDbKey {
        public String deviceId;
        public String packageName;
        public String databaseName;
        public boolean external;

        public MyDbKey(@NotNull String deviceId, @NotNull String packageName, @NotNull String databaseName, boolean external) {
            if (deviceId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceId", "org/jetbrains/android/database/AndroidRemoteDataBaseManager$MyDbKey", "<init>"));
            }
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/database/AndroidRemoteDataBaseManager$MyDbKey", "<init>"));
            }
            if (databaseName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseName", "org/jetbrains/android/database/AndroidRemoteDataBaseManager$MyDbKey", "<init>"));
            }
            this.deviceId = "";
            this.packageName = "";
            this.databaseName = "";
            this.deviceId = deviceId;
            this.packageName = packageName;
            this.databaseName = databaseName;
            this.external = external;
        }

        public MyDbKey() {
            this.deviceId = "";
            this.packageName = "";
            this.databaseName = "";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyDbKey key = (MyDbKey)o;
            if (this.external != key.external) {
                return false;
            }
            if (this.databaseName != null ? !this.databaseName.equals(key.databaseName) : key.databaseName != null) {
                return false;
            }
            if (this.deviceId != null ? !this.deviceId.equals(key.deviceId) : key.deviceId != null) {
                return false;
            }
            return !(this.packageName != null ? !this.packageName.equals(key.packageName) : key.packageName != null);
        }

        public int hashCode() {
            int result = this.deviceId != null ? this.deviceId.hashCode() : 0;
            result = 31 * result + (this.packageName != null ? this.packageName.hashCode() : 0);
            result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
            result = 31 * result + (this.external ? 1 : 0);
            return result;
        }
    }

    public static class State {
        @Tag(value="databases")
        @MapAnnotation(surroundWithTag=false)
        public Map<MyDbKey, MyDatabaseInfo> databases = new HashMap();
    }
}

