/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public interface ExecutionListener
extends EventListener {
    default public void processStartScheduled(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/ExecutionListener", "processStartScheduled"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/ExecutionListener", "processStartScheduled"));
        }
    }

    default public void processStarting(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/ExecutionListener", "processStarting"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/ExecutionListener", "processStarting"));
        }
    }

    default public void processNotStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/ExecutionListener", "processNotStarted"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/ExecutionListener", "processNotStarted"));
        }
    }

    default public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/ExecutionListener", "processStarted"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/ExecutionListener", "processStarted"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/ExecutionListener", "processStarted"));
        }
    }

    default public void processTerminating(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/ExecutionListener", "processTerminating"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/ExecutionListener", "processTerminating"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/ExecutionListener", "processTerminating"));
        }
        this.processTerminating(env.getRunProfile(), handler);
    }

    default public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/ExecutionListener", "processTerminated"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/ExecutionListener", "processTerminated"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/ExecutionListener", "processTerminated"));
        }
        this.processTerminated(env.getRunProfile(), handler);
    }

    @Deprecated
    default public void processTerminating(@NotNull RunProfile runProfile, @NotNull ProcessHandler handler) {
        if (runProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProfile", "com/intellij/execution/ExecutionListener", "processTerminating"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/ExecutionListener", "processTerminating"));
        }
    }

    @Deprecated
    default public void processTerminated(@NotNull RunProfile runProfile, @NotNull ProcessHandler handler) {
        if (runProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProfile", "com/intellij/execution/ExecutionListener", "processTerminated"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/execution/ExecutionListener", "processTerminated"));
        }
    }
}

