/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.ide.TypePresentationService;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.psi.DelegatePsiTarget;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=JamElementDelegatingPresentationProvider.class)
public class JamPomTarget
extends DelegatePsiTarget
implements PsiDeclaredTarget,
PomRenameableTarget<JamPomTarget> {
    private final JamElement myElement;
    private final JamStringAttributeElement myNameAttr;

    public JamPomTarget(JamElement element, JamStringAttributeElement nameAttr) {
        super((PsiElement)ObjectUtils.assertNotNull((Object)nameAttr.getPsiElement()));
        this.myElement = element;
        this.myNameAttr = nameAttr;
    }

    @Override
    @NotNull
    public String getName() {
        String value = this.myNameAttr.getStringValue();
        if (value == null) {
            throw new AssertionError((Object)("Null name for " + this.myElement + "; " + this.myElement.getClass()));
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/JamPomTarget", "getName"));
        }
        return string;
    }

    @Override
    public JamPomTarget setName(@NotNull String newName) {
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/jam/JamPomTarget", "setName"));
        }
        this.myNameAttr.setStringValue(newName);
        return this;
    }

    public JamElement getJamElement() {
        return this.myElement;
    }

    @Override
    @Nullable
    public TextRange getNameIdentifierRange() {
        PsiLiteral psiLiteral = this.myNameAttr.getPsiLiteral();
        return psiLiteral == null ? null : ElementManipulators.getValueTextRange(psiLiteral);
    }

    @Override
    public boolean isWritable() {
        return this.getNavigationElement().isWritable();
    }

    public JamStringAttributeElement getNameAttr() {
        return this.myNameAttr;
    }

    public static class JamElementDelegatingPresentationProvider
    extends PresentationProvider<JamPomTarget> {
        @Override
        @Nullable
        public Icon getIcon(JamPomTarget target) {
            return TypePresentationService.getService().getIcon(target.getJamElement());
        }

        @Override
        @Nullable
        public String getTypeName(JamPomTarget target) {
            return TypePresentationService.getService().getTypeName(target.getJamElement());
        }
    }
}

