/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationAttributeMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamPackageMeta;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiAnnotationPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.ref.AnnotationChildLink;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemElement;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamAnnotationMeta
extends JamAnnotationArchetype
implements SemElement {
    private static final PsiJavaElementPattern.Capture<PsiPackageStatement> PACKAGE_STATEMENT = PsiJavaPatterns.psiElement(PsiPackageStatement.class);
    private final AnnotationChildLink myAnnotationChildLink;
    private final SemKey<JamAnnotationMeta> myMetaKey;
    private final PsiAnnotationPattern myAnnoNamePattern;

    public JamAnnotationMeta(@NotNull @NonNls String annoName) {
        if (annoName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annoName", "com/intellij/jam/reflect/JamAnnotationMeta", "<init>"));
        }
        this(annoName, null);
    }

    public JamAnnotationMeta(@NotNull @NonNls String annoName, @Nullable JamAnnotationArchetype archetype) {
        if (annoName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annoName", "com/intellij/jam/reflect/JamAnnotationMeta", "<init>"));
        }
        this(annoName, archetype, JamService.ANNO_META_KEY.subKey("AnnoMeta:" + annoName, new SemKey[0]));
    }

    public JamAnnotationMeta(@NotNull @NonNls String annoName, @Nullable JamAnnotationArchetype archetype, SemKey<JamAnnotationMeta> metaKey) {
        if (annoName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annoName", "com/intellij/jam/reflect/JamAnnotationMeta", "<init>"));
        }
        super(archetype);
        this.myAnnotationChildLink = new AnnotationChildLink(annoName);
        this.myMetaKey = metaKey;
        this.myAnnoNamePattern = PsiJavaPatterns.psiAnnotation().qName(this.myAnnotationChildLink.getAnnotationQualifiedName());
    }

    public SemKey<JamAnnotationMeta> getMetaKey() {
        return this.myMetaKey;
    }

    @Override
    public JamAnnotationMeta addAttribute(JamAttributeMeta<?> attributeMeta) {
        super.addAttribute(attributeMeta);
        return this;
    }

    public String getAnnoName() {
        return this.myAnnotationChildLink.getAnnotationQualifiedName();
    }

    @NotNull
    public <T> T getAttribute(PsiModifierListOwner member, JamAttributeMeta<T> meta) {
        T t = this.getAttribute(PsiElementRef.real(member), meta);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamAnnotationMeta", "getAttribute"));
        }
        return t;
    }

    @NotNull
    public <T> T getAttribute(PsiElementRef<? extends PsiModifierListOwner> member, JamAttributeMeta<T> meta) {
        T t = meta.getJam(this.getAnnotationRef(member));
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamAnnotationMeta", "getAttribute"));
        }
        return t;
    }

    @Nullable
    public PsiAnnotation getAnnotation(PsiModifierListOwner owner) {
        return this.myAnnotationChildLink.findLinkedChild(owner);
    }

    @NotNull
    public PsiElementRef<PsiAnnotation> getAnnotationRef(PsiModifierListOwner owner) {
        PsiElementRef<PsiAnnotation> psiElementRef = this.myAnnotationChildLink.createChildRef(owner);
        if (psiElementRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamAnnotationMeta", "getAnnotationRef"));
        }
        return psiElementRef;
    }

    @NotNull
    public PsiElementRef<PsiAnnotation> getAnnotationRef(PsiElementRef<? extends PsiModifierListOwner> member) {
        PsiElementRef<PsiAnnotation> psiElementRef = this.myAnnotationChildLink.createChildRef(member);
        if (psiElementRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/reflect/JamAnnotationMeta", "getAnnotationRef"));
        }
        return psiElementRef;
    }

    public String toString() {
        return "JamAnnotationMeta:" + this.myAnnotationChildLink.getAnnotationQualifiedName();
    }

    public <T extends PsiModifierListOwner> void registerTopLevelSem(SemRegistrar registrar, final ElementPattern<? extends T> parentPattern, JamMemberMeta<T, ?> parentMeta) {
        boolean isPackage = parentMeta instanceof JamPackageMeta;
        PsiAnnotationPattern annoPattern = (PsiAnnotationPattern)this.myAnnoNamePattern.withSuperParent(2, isPackage ? PACKAGE_STATEMENT.with(new PatternCondition<PsiPackageStatement>("package"){

            @Override
            public boolean accepts(@NotNull PsiPackageStatement psiPackageStatement, ProcessingContext context) {
                if (psiPackageStatement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackageStatement", "com/intellij/jam/reflect/JamAnnotationMeta$1", "accepts"));
                }
                return parentPattern.accepts(psiPackageStatement.getPackageReference().resolve(), context);
            }
        }) : parentPattern);
        registrar.registerSemElementProvider(this.myMetaKey, annoPattern, annotation -> {
            PsiModifierListOwner element;
            PsiElement parent = annotation.getParent().getParent();
            PsiModifierListOwner psiModifierListOwner = element = isPackage && parent instanceof PsiPackageStatement ? (PsiModifierListOwner)((PsiPackageStatement)parent).getPackageReference().resolve() : (PsiModifierListOwner)parent;
            if (element != null && SemService.getSemService(annotation.getProject()).getSemElement(parentMeta.getMetaKey(), element) == parentMeta) {
                return this;
            }
            return null;
        });
        this.registerChildren(registrar, annoPattern);
    }

    public void registerNestedSem(SemRegistrar registrar, ElementPattern<PsiAnnotation> annoPattern, JamAnnotationMeta parentMeta) {
        registrar.registerSemElementProvider(this.myMetaKey, annoPattern, annotation -> {
            PsiAnnotation parentAnno = PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiAnnotation.class, true);
            assert (parentAnno != null);
            if (SemService.getSemService(annotation.getProject()).getSemElement(parentMeta.getMetaKey(), parentAnno) == parentMeta) {
                return this;
            }
            return null;
        });
        this.registerChildren(registrar, annoPattern);
    }

    private void registerChildren(SemRegistrar registrar, ElementPattern<PsiAnnotation> annoPattern) {
        for (JamAnnotationArchetype cur = this; cur != null; cur = cur.getArchetype()) {
            for (JamAttributeMeta<?> attributeMeta : cur.getAttributes()) {
                if (!(attributeMeta instanceof JamAnnotationAttributeMeta)) continue;
                ((JamAnnotationAttributeMeta)attributeMeta).registerSem(registrar, annoPattern, this);
            }
        }
    }
}

