/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThrowableRunnable;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WriteCommandAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.command.WriteCommandAction");
    private static final String DEFAULT_COMMAND_NAME = "Undefined";
    private static final String DEFAULT_GROUP_ID = null;
    private final String myCommandName;
    private final String myGroupID;
    private final Project myProject;
    private final PsiFile[] myPsiFiles;

    @NotNull
    public static Builder writeCommandAction(Project project) {
        BuilderImpl builderImpl = new BuilderImpl(project, new PsiFile[0]);
        if (builderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/WriteCommandAction", "writeCommandAction"));
        }
        return builderImpl;
    }

    @NotNull
    public static Builder writeCommandAction(@NotNull PsiFile first, PsiFile ... others) {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/openapi/command/WriteCommandAction", "writeCommandAction"));
        }
        if (others == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "others", "com/intellij/openapi/command/WriteCommandAction", "writeCommandAction"));
        }
        BuilderImpl builderImpl = new BuilderImpl(first.getProject(), (PsiFile[])ArrayUtil.prepend((Object)first, (Object[])others));
        if (builderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/WriteCommandAction", "writeCommandAction"));
        }
        return builderImpl;
    }

    protected WriteCommandAction(@Nullable Project project, PsiFile ... files) {
        this(project, DEFAULT_COMMAND_NAME, files);
    }

    protected WriteCommandAction(@Nullable Project project, @Nullable String commandName, PsiFile ... files) {
        this(project, commandName, DEFAULT_GROUP_ID, files);
    }

    protected WriteCommandAction(@Nullable Project project, @Nullable String commandName, @Nullable String groupID, PsiFile ... files) {
        this.myCommandName = commandName;
        this.myGroupID = groupID;
        this.myProject = project;
        if (files == null) {
            LOG.warn("'files' parameter must not be null", new Throwable());
        }
        this.myPsiFiles = files == null || files.length == 0 ? PsiFile.EMPTY_ARRAY : files;
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final String getCommandName() {
        return this.myCommandName;
    }

    public String getGroupID() {
        return this.myGroupID;
    }

    @Override
    @NotNull
    public RunResult<T> execute() {
        Application application = ApplicationManager.getApplication();
        boolean dispatchThread = application.isDispatchThread();
        if (!dispatchThread && application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
            throw new IllegalStateException();
        }
        RunResult result = new RunResult(this);
        if (dispatchThread) {
            this.performWriteCommandAction(result);
        } else {
            try {
                TransactionGuard.getInstance().submitTransactionAndWait(() -> this.performWriteCommandAction(result));
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
        RunResult runResult = result;
        if (runResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/WriteCommandAction", "execute"));
        }
        return runResult;
    }

    private void performWriteCommandAction(@NotNull RunResult<T> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction", "performWriteCommandAction"));
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(Arrays.asList(this.myPsiFiles))) {
            return;
        }
        RunResult[] results = new RunResult[]{result};
        this.doExecuteCommand(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            results[0].run();
            results[0] = null;
        }));
    }

    protected boolean isGlobalUndoAction() {
        return false;
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION;
    }

    protected boolean shouldRecordActionForActiveDocument() {
        return true;
    }

    public void performCommand() throws Throwable {
        RunResult[] results = new RunResult[]{new RunResult(this)};
        Ref exception = new Ref();
        this.doExecuteCommand(() -> {
            exception.set((Object)results[0].run().getThrowable());
            results[0] = null;
        });
        Throwable throwable = (Throwable)exception.get();
        if (throwable != null) {
            throw throwable;
        }
    }

    private void doExecuteCommand(Runnable runnable) {
        Runnable wrappedRunnable = () -> {
            if (this.isGlobalUndoAction()) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.getProject());
            }
            runnable.run();
        };
        CommandProcessor.getInstance().executeCommand(this.getProject(), wrappedRunnable, this.getCommandName(), (Object)this.getGroupID(), this.getUndoConfirmationPolicy(), this.shouldRecordActionForActiveDocument());
    }

    public static void runWriteCommandAction(Project project, @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/command/WriteCommandAction", "runWriteCommandAction"));
        }
        WriteCommandAction.runWriteCommandAction(project, DEFAULT_COMMAND_NAME, DEFAULT_GROUP_ID, runnable, new PsiFile[0]);
    }

    public static void runWriteCommandAction(Project project, @Nullable String commandName, @Nullable String groupID, final @NotNull Runnable runnable, PsiFile ... files) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/command/WriteCommandAction", "runWriteCommandAction"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/command/WriteCommandAction", "runWriteCommandAction"));
        }
        new Simple(project, commandName, groupID, files){

            @Override
            protected void run() throws Throwable {
                runnable.run();
            }
        }.execute();
    }

    public static <T> T runWriteCommandAction(Project project, final @NotNull Computable<T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/command/WriteCommandAction", "runWriteCommandAction"));
        }
        return new WriteCommandAction<T>(project, new PsiFile[0]){

            @Override
            protected void run(@NotNull Result<T> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$2", "run"));
                }
                result.setResult(computable.compute());
            }
        }.execute().getResultObject();
    }

    public static <T, E extends Throwable> T runWriteCommandAction(Project project, final @NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/command/WriteCommandAction", "runWriteCommandAction"));
        }
        RunResult<T> result = new WriteCommandAction<T>(project, "", new PsiFile[0]){

            @Override
            protected void run(@NotNull Result<T> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$3", "run"));
                }
                result.setResult(computable.compute());
            }
        }.execute();
        Throwable t = result.getThrowable();
        if (t != null) {
            Throwable e = t;
            throw e;
        }
        return result.throwException().getResultObject();
    }

    public static boolean ensureFilesWritable(@NotNull Project project, @NotNull Collection<PsiFile> psiFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/command/WriteCommandAction", "ensureFilesWritable"));
        }
        if (psiFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFiles", "com/intellij/openapi/command/WriteCommandAction", "ensureFilesWritable"));
        }
        return FileModificationService.getInstance().preparePsiElementsForWrite(psiFiles);
    }

    static /* synthetic */ String access$000() {
        return DEFAULT_GROUP_ID;
    }

    public static abstract class Simple<T>
    extends WriteCommandAction<T> {
        protected Simple(Project project, PsiFile ... files) {
            super(project, files);
        }

        protected Simple(Project project, String commandName, PsiFile ... files) {
            super(project, commandName, files);
        }

        protected Simple(Project project, String name, String groupID, PsiFile ... files) {
            super(project, name, groupID, files);
        }

        @Override
        protected void run(@NotNull Result<T> result) throws Throwable {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$Simple", "run"));
            }
            this.run();
        }

        protected abstract void run() throws Throwable;
    }

    private static class BuilderImpl
    implements Builder {
        private final Project myProject;
        private final PsiFile[] myFiles;
        private String myCommandName = "Undefined";
        private String myGroupId = WriteCommandAction.access$000();

        private BuilderImpl(Project project, PsiFile ... files) {
            this.myProject = project;
            this.myFiles = files;
        }

        @Override
        @NotNull
        public Builder withName(String name) {
            this.myCommandName = name;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/WriteCommandAction$BuilderImpl", "withName"));
            }
            return builderImpl;
        }

        @Override
        @NotNull
        public Builder withGroupId(String groupId) {
            this.myGroupId = groupId;
            BuilderImpl builderImpl = this;
            if (builderImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/WriteCommandAction$BuilderImpl", "withGroupId"));
            }
            return builderImpl;
        }

        @Override
        public <E extends Throwable> void run(final @NotNull ThrowableRunnable<E> action) throws E {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/command/WriteCommandAction$BuilderImpl", "run"));
            }
            new WriteCommandAction(this.myProject, this.myCommandName, this.myGroupId, this.myFiles){

                @Override
                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$BuilderImpl$1", "run"));
                    }
                    action.run();
                }
            }.execute();
        }

        @Override
        public <R, E extends Throwable> R compute(final @NotNull ThrowableComputable<R, E> action) throws E {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/command/WriteCommandAction$BuilderImpl", "compute"));
            }
            return (R)new WriteCommandAction<R>(this.myProject, this.myCommandName, this.myGroupId, this.myFiles){

                @Override
                protected void run(@NotNull Result<R> result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$BuilderImpl$2", "run"));
                    }
                    result.setResult(action.compute());
                }
            }.execute().getResultObject();
        }
    }

    public static interface Builder {
        @NotNull
        public Builder withName(@Nullable String var1);

        @NotNull
        public Builder withGroupId(@Nullable String var1);

        public <E extends Throwable> void run(@NotNull ThrowableRunnable<E> var1) throws E;

        public <R, E extends Throwable> R compute(@NotNull ThrowableComputable<R, E> var1) throws E;
    }
}

