/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class Key<T>
implements Serializable,
Comparable<Key<?>> {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myDataClass;
    private final int myProcessingWeight;

    public Key(@NotNull String dataClass, int processingWeight) {
        if (dataClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataClass", "com/intellij/openapi/externalSystem/model/Key", "<init>"));
        }
        this.myDataClass = dataClass;
        this.myProcessingWeight = processingWeight;
    }

    @NotNull
    public static <T> Key<T> create(@NotNull Class<T> dataClass, int processingWeight) {
        if (dataClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataClass", "com/intellij/openapi/externalSystem/model/Key", "create"));
        }
        Key<T> key = new Key<T>(dataClass.getName(), processingWeight);
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/Key", "create"));
        }
        return key;
    }

    public String getDataType() {
        return this.myDataClass;
    }

    public int getProcessingWeight() {
        return this.myProcessingWeight;
    }

    public int hashCode() {
        return this.myDataClass.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        return this.myDataClass.equals(key.myDataClass);
    }

    @Override
    public int compareTo(@NotNull Key<?> that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/openapi/externalSystem/model/Key", "compareTo"));
        }
        if (this.myProcessingWeight == that.myProcessingWeight) {
            return this.myDataClass.compareTo(that.myDataClass);
        }
        return this.myProcessingWeight - that.myProcessingWeight;
    }

    public String toString() {
        int i2 = this.myDataClass.lastIndexOf(46);
        return i2 > 0 ? this.myDataClass.substring(i2 + 1) : this.myDataClass;
    }
}

