/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.layout.router.polyline;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.geom.YRectangle;
import com.intellij.openapi.graph.layout.Direction;
import com.intellij.openapi.graph.layout.PortCandidate;
import com.intellij.openapi.graph.layout.PortConstraint;
import com.intellij.openapi.graph.layout.router.polyline.OrthogonalInterval;
import com.intellij.openapi.graph.layout.router.polyline.Partition;

public interface PartitionCell {
    public Object putData(Object var1, Object var2);

    public Object getData(Object var1);

    public Object removeData(Object var1);

    public void clearData();

    public Partition getPartition();

    public int getId();

    public YRectangle getBounds();

    public double getMinX();

    public double getMinY();

    public double getMaxX();

    public double getMaxY();

    public double getWidth();

    public double getHeight();

    public OrthogonalInterval createBorderInterval(PartitionCellBorder var1);

    public static interface PartitionCellBorder {
        public static final PartitionCellBorder NORTH = GraphManager.getGraphManager()._PartitionCellBorder_NORTH();
        public static final PartitionCellBorder SOUTH = GraphManager.getGraphManager()._PartitionCellBorder_SOUTH();
        public static final PartitionCellBorder EAST = GraphManager.getGraphManager()._PartitionCellBorder_EAST();
        public static final PartitionCellBorder WEST = GraphManager.getGraphManager()._PartitionCellBorder_WEST();

        public PartitionCellBorder getMirrorBorder();

        public static class Statics {
            public static PartitionCellBorder valueOfExitDirection(Direction direction) {
                return GraphManager.getGraphManager()._PartitionCellBorder_valueOfExitDirection(direction);
            }

            public static PartitionCellBorder valueOfEnterDirection(Direction direction) {
                return GraphManager.getGraphManager()._PartitionCellBorder_valueOfEnterDirection(direction);
            }

            public static PartitionCellBorder valueOfPortConstraint(PortConstraint pc) {
                return GraphManager.getGraphManager()._PartitionCellBorder_valueOfPortConstraint(pc);
            }

            public static PartitionCellBorder valueOfPortCandidate(PortCandidate pc) {
                return GraphManager.getGraphManager()._PartitionCellBorder_valueOfPortCandidate(pc);
            }
        }
    }
}

