/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleColoredText
implements ColoredTextContainer {
    private final ArrayList<String> myTexts;
    private final ArrayList<SimpleTextAttributes> myAttributes;
    private String myCachedToString;

    public SimpleColoredText() {
        this.myCachedToString = null;
        this.myTexts = new ArrayList(3);
        this.myAttributes = new ArrayList(3);
    }

    public SimpleColoredText(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/ui/SimpleColoredText", "<init>"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/ui/SimpleColoredText", "<init>"));
        }
        this();
        this.append(fragment, attributes);
    }

    @Override
    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/ui/SimpleColoredText", "append"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/ui/SimpleColoredText", "append"));
        }
        this.myTexts.add(fragment);
        this.myCachedToString = null;
        this.myAttributes.add(attributes);
    }

    public void insert(int index, @NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/ui/SimpleColoredText", "insert"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/ui/SimpleColoredText", "insert"));
        }
        this.myTexts.add(index, fragment);
        this.myCachedToString = null;
        this.myAttributes.add(index, attributes);
    }

    @Override
    public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/ui/SimpleColoredText", "append"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/ui/SimpleColoredText", "append"));
        }
        this.append(fragment, attributes);
    }

    @Override
    public void setIcon(@Nullable Icon icon) {
    }

    @Override
    public void setToolTipText(@Nullable String text) {
    }

    public void clear() {
        this.myTexts.clear();
        this.myCachedToString = null;
        this.myAttributes.clear();
    }

    public void appendToComponent(@NotNull ColoredTextContainer component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/SimpleColoredText", "appendToComponent"));
        }
        int size = this.myTexts.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String text = this.myTexts.get(i2);
            SimpleTextAttributes attribute = this.myAttributes.get(i2);
            component.append(text, attribute);
        }
    }

    public String toString() {
        if (this.myCachedToString == null) {
            this.myCachedToString = StringUtil.join(this.myTexts, (String)"");
        }
        return this.myCachedToString;
    }

    public ArrayList<String> getTexts() {
        return this.myTexts;
    }

    public ArrayList<SimpleTextAttributes> getAttributes() {
        return this.myAttributes;
    }

    public SimpleColoredText derive(SimpleTextAttributes attributes, boolean override) {
        SimpleColoredText result = new SimpleColoredText();
        for (int i2 = 0; i2 < this.myTexts.size(); ++i2) {
            SimpleTextAttributes overridden = override ? SimpleTextAttributes.merge(this.myAttributes.get(i2), attributes) : SimpleTextAttributes.merge(attributes, this.myAttributes.get(i2));
            result.append(this.myTexts.get(i2), overridden);
        }
        return result;
    }
}

