/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.DelegatingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkippingHandler
extends MatchingHandler
implements DelegatingHandler {
    private final MatchingHandler myDelegate;

    public SkippingHandler(@NotNull MatchingHandler delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/structuralsearch/impl/matcher/handlers/SkippingHandler", "<init>"));
        }
        this.myDelegate = delegate;
    }

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext matchContext) {
        if (patternNode == null || matchedNode == null || matchedNode.getClass() == patternNode.getClass()) {
            return this.myDelegate.match(patternNode, matchedNode, matchContext);
        }
        PsiElement newPatternNode = SkippingHandler.skipNodeIfNeccessary(patternNode);
        matchedNode = SkippingHandler.skipNodeIfNeccessary(matchedNode);
        if (newPatternNode != patternNode) {
            return matchContext.getPattern().getHandler(newPatternNode).match(newPatternNode, matchedNode, matchContext);
        }
        return this.myDelegate.match(patternNode, matchedNode, matchContext);
    }

    @Override
    public boolean canMatch(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
        PsiElement newPatternNode = SkippingHandler.skipNodeIfNeccessary(patternNode);
        if (newPatternNode != patternNode) {
            return context.getPattern().getHandler(newPatternNode).canMatch(newPatternNode, matchedNode, context);
        }
        return this.myDelegate.canMatch(patternNode, matchedNode, context);
    }

    @Override
    public boolean matchSequentially(NodeIterator nodes, NodeIterator nodes2, MatchContext context) {
        return this.myDelegate.matchSequentially(nodes, nodes2, context);
    }

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, int start, int end, MatchContext context) {
        if (patternNode == null || matchedNode == null || patternNode.getClass() == matchedNode.getClass()) {
            return this.myDelegate.match(patternNode, matchedNode, start, end, context);
        }
        PsiElement newPatternNode = SkippingHandler.skipNodeIfNeccessary(patternNode);
        matchedNode = SkippingHandler.skipNodeIfNeccessary(matchedNode);
        if (newPatternNode != patternNode) {
            return context.getPattern().getHandler(newPatternNode).match(newPatternNode, matchedNode, start, end, context);
        }
        return this.myDelegate.match(patternNode, matchedNode, start, end, context);
    }

    @Override
    protected boolean isMatchSequentiallySucceeded(NodeIterator nodes2) {
        return this.myDelegate.isMatchSequentiallySucceeded(nodes2);
    }

    @Override
    public boolean shouldAdvanceTheMatchFor(PsiElement patternElement, PsiElement matchedElement) {
        return true;
    }

    @Override
    public MatchingHandler getDelegate() {
        return this.myDelegate;
    }

    @Nullable
    public static PsiElement getOnlyNonWhitespaceChild(PsiElement element) {
        PsiElement onlyChild = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (DuplocatorUtil.isIgnoredNode(element) || child.getTextLength() == 0) continue;
            if (onlyChild != null) {
                return null;
            }
            onlyChild = child;
        }
        return onlyChild;
    }

    @Nullable
    public static PsiElement skipNodeIfNeccessary(PsiElement element) {
        return SkippingHandler.skipNodeIfNeccessary(element, null, null);
    }

    @Nullable
    public static PsiElement skipNodeIfNeccessary(PsiElement element, EquivalenceDescriptor descriptor, NodeFilter filter) {
        return DuplocatorUtil.skipNodeIfNeccessary(element, descriptor, filter != null ? filter : LexicalNodesFilter.getInstance());
    }
}

