/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.injection.ReferenceInjector;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.FileContentUtil;
import com.intellij.util.Function;
import com.intellij.util.JdomKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.file.Path;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jdom.Parent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectionsSettingsUI
extends SearchableConfigurable.Parent.Abstract
implements Configurable.NoScroll {
    private final Project myProject;
    private final CfgInfo[] myInfos;
    private final JPanel myRoot;
    private final InjectionsTable myInjectionsTable;
    private final Map<String, LanguageInjectionSupport> mySupports = ContainerUtil.newLinkedHashMap();
    private final Map<String, AnAction> myEditActions = ContainerUtil.newLinkedHashMap();
    private final List<AnAction> myAddActions = ContainerUtil.newArrayList();
    private final JLabel myCountLabel;
    private Configuration myConfiguration;

    public InjectionsSettingsUI(Project project, Configuration configuration) {
        CfgInfo[] cfgInfoArray;
        this.myProject = project;
        this.myConfiguration = configuration;
        CfgInfo currentInfo = new CfgInfo(configuration, "Project");
        if (configuration instanceof Configuration.Prj) {
            CfgInfo[] cfgInfoArray2 = new CfgInfo[2];
            cfgInfoArray2[0] = new CfgInfo(((Configuration.Prj)configuration).getParentConfiguration(), "IDE");
            cfgInfoArray = cfgInfoArray2;
            cfgInfoArray2[1] = currentInfo;
        } else {
            CfgInfo[] cfgInfoArray3 = new CfgInfo[1];
            cfgInfoArray = cfgInfoArray3;
            cfgInfoArray3[0] = currentInfo;
        }
        this.myInfos = cfgInfoArray;
        this.myRoot = new JPanel(new BorderLayout());
        this.myInjectionsTable = new InjectionsTable(InjectionsSettingsUI.getInjInfoList(this.myInfos));
        this.myInjectionsTable.getEmptyText().setText("No injections configured");
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)((Object)this.myInjectionsTable));
        this.createActions(decorator);
        this.myRoot.add((Component)decorator.createPanel(), "Center");
        this.myCountLabel = new JLabel();
        this.myCountLabel.setHorizontalAlignment(4);
        this.myCountLabel.setForeground(SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES.getFgColor());
        this.myRoot.add((Component)this.myCountLabel, "South");
        this.updateCountLabel();
    }

    private void createActions(ToolbarDecorator decorator) {
        Consumer consumer = injection -> this.addInjection((BaseInjection)injection);
        NullableFactory producer = () -> {
            InjInfo info = this.getSelectedInjection();
            return info == null ? null : info.injection;
        };
        for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
            ContainerUtil.addAll(this.myAddActions, (Object[])support.createAddActions(this.myProject, (Consumer<BaseInjection>)consumer));
            AnAction action = support.createEditAction(this.myProject, (Factory<BaseInjection>)producer);
            this.myEditActions.put(support.getId(), action == null ? AbstractLanguageInjectionSupport.createDefaultEditAction(this.myProject, (Factory<BaseInjection>)producer) : action);
            this.mySupports.put(support.getId(), support);
        }
        Collections.sort(this.myAddActions, (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getTemplatePresentation().getText()), (Comparable)((Object)o2.getTemplatePresentation().getText())));
        decorator.disableUpDownActions();
        decorator.setAddActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return !InjectionsSettingsUI.this.myAddActions.isEmpty();
            }
        });
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                InjectionsSettingsUI.this.performAdd(button);
            }
        });
        decorator.setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                boolean enabled = false;
                for (InjInfo info : InjectionsSettingsUI.this.getSelectedInjections()) {
                    if (info.bundled) continue;
                    enabled = true;
                    break;
                }
                return enabled;
            }
        });
        decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                InjectionsSettingsUI.this.performRemove();
            }
        });
        decorator.setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                AnAction edit = InjectionsSettingsUI.this.getEditAction();
                if (edit != null) {
                    edit.update(e);
                }
                return edit != null && edit.getTemplatePresentation().isEnabled();
            }
        });
        decorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                InjectionsSettingsUI.this.performEditAction();
            }
        });
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Duplicate", "Duplicate", PlatformIcons.COPY_ICON){

            public boolean isEnabled() {
                return InjectionsSettingsUI.this.getEditAction() != null;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/plugins/intelliLang/InjectionsSettingsUI$7", "actionPerformed"));
                }
                InjInfo injection = InjectionsSettingsUI.this.getSelectedInjection();
                if (injection != null) {
                    InjectionsSettingsUI.this.addInjection(injection.injection.copy());
                }
            }
        });
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Enable Selected Injections", "Enable Selected Injections", PlatformIcons.SELECT_ALL_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/plugins/intelliLang/InjectionsSettingsUI$8", "actionPerformed"));
                }
                InjectionsSettingsUI.this.performSelectedInjectionsEnabled(true);
            }
        });
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Disable Selected Injections", "Disable Selected Injections", PlatformIcons.UNSELECT_ALL_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/plugins/intelliLang/InjectionsSettingsUI$9", "actionPerformed"));
                }
                InjectionsSettingsUI.this.performSelectedInjectionsEnabled(false);
            }
        });
        new DumbAwareAction("Toggle"){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/plugins/intelliLang/InjectionsSettingsUI$10", "update"));
                }
                SpeedSearchSupply supply = SpeedSearchSupply.getSupply((JComponent)((Object)InjectionsSettingsUI.this.myInjectionsTable));
                e.getPresentation().setEnabled(supply == null || !supply.isPopupActive());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/plugins/intelliLang/InjectionsSettingsUI$10", "actionPerformed"));
                }
                InjectionsSettingsUI.this.performToggleAction();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)((Object)this.myInjectionsTable));
        if (this.myInfos.length > 1) {
            DumbAwareActionButton shareAction = new DumbAwareActionButton("Move to IDE Scope", null, PlatformIcons.IMPORT_ICON){
                {
                    this.addCustomUpdater(new AnActionButtonUpdater(){

                        public boolean isEnabled(AnActionEvent e) {
                            CfgInfo cfg = this.getTargetCfgInfo(InjectionsSettingsUI.this.getSelectedInjections());
                            e.getPresentation().setText(cfg == InjectionsSettingsUI.this.getDefaultCfgInfo() ? "Move to IDE Scope" : "Move to Project Scope");
                            return cfg != null;
                        }
                    });
                }

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/plugins/intelliLang/InjectionsSettingsUI$11", "actionPerformed"));
                    }
                    List injections = InjectionsSettingsUI.this.getSelectedInjections();
                    CfgInfo cfg = this.getTargetCfgInfo(injections);
                    if (cfg == null) {
                        return;
                    }
                    for (InjInfo info : injections) {
                        if (info.cfgInfo == cfg || info.bundled) continue;
                        info.cfgInfo.injectionInfos.remove(info);
                        cfg.addInjection(info.injection);
                    }
                    int[] selectedRows = InjectionsSettingsUI.this.myInjectionsTable.getSelectedRows();
                    InjectionsSettingsUI.this.myInjectionsTable.getListTableModel().setItems(InjectionsSettingsUI.getInjInfoList(InjectionsSettingsUI.this.myInfos));
                    TableUtil.selectRows((JTable)((Object)InjectionsSettingsUI.this.myInjectionsTable), (int[])selectedRows);
                }

                @Nullable
                private CfgInfo getTargetCfgInfo(List<InjInfo> injections) {
                    CfgInfo cfg = null;
                    for (InjInfo info : injections) {
                        if (info.bundled) continue;
                        if (cfg == null) {
                            cfg = info.cfgInfo;
                            continue;
                        }
                        if (cfg == info.cfgInfo) continue;
                        return info.cfgInfo;
                    }
                    if (cfg == null) {
                        return null;
                    }
                    for (CfgInfo info : InjectionsSettingsUI.this.myInfos) {
                        if (info == cfg) continue;
                        return info;
                    }
                    throw new AssertionError();
                }
            };
            shareAction.setShortcut((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 64)));
            decorator.addExtraAction((AnActionButton)shareAction);
        }
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Import", "Import", AllIcons.Actions.Install){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/plugins/intelliLang/InjectionsSettingsUI$12", "actionPerformed"));
                }
                InjectionsSettingsUI.this.doImportAction(e.getDataContext());
                InjectionsSettingsUI.this.updateCountLabel();
            }
        });
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Export", "Export", AllIcons.Actions.Export){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/plugins/intelliLang/InjectionsSettingsUI$13", "actionPerformed"));
                }
                List injections = InjectionsSettingsUI.getInjectionList(InjectionsSettingsUI.this.getSelectedInjections());
                VirtualFileWrapper wrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Export Selected Injections to File...", "", new String[]{"xml"}), InjectionsSettingsUI.this.myProject).save(null, null);
                if (wrapper == null) {
                    return;
                }
                Configuration configuration = new Configuration();
                configuration.setInjections(injections);
                try {
                    JdomKt.write((Parent)configuration.getState(), (Path)wrapper.getFile().toPath());
                }
                catch (IOException ex) {
                    String msg = ex.getLocalizedMessage();
                    Messages.showErrorDialog((Project)InjectionsSettingsUI.this.myProject, (String)(msg != null && msg.length() > 0 ? msg : ex.toString()), (String)"Export Failed");
                }
            }

            public boolean isEnabled() {
                return !InjectionsSettingsUI.this.getSelectedInjections().isEmpty();
            }
        });
    }

    private void performEditAction() {
        AnAction action = this.getEditAction();
        if (action != null) {
            int row = this.myInjectionsTable.getSelectedRow();
            action.actionPerformed(new AnActionEvent(null, DataManager.getInstance().getDataContext((Component)((Object)this.myInjectionsTable)), "unknown", new Presentation(""), ActionManager.getInstance(), 0));
            this.myInjectionsTable.getListTableModel().fireTableDataChanged();
            this.myInjectionsTable.getSelectionModel().setSelectionInterval(row, row);
            this.updateCountLabel();
        }
    }

    private void updateCountLabel() {
        int placesCount = 0;
        int enablePlacesCount = 0;
        List items = this.myInjectionsTable.getListTableModel().getItems();
        if (!items.isEmpty()) {
            for (InjInfo injection : items) {
                for (InjectionPlace place : injection.injection.getInjectionPlaces()) {
                    ++placesCount;
                    if (!place.isEnabled()) continue;
                    ++enablePlacesCount;
                }
            }
            this.myCountLabel.setText(items.size() + " injection" + (items.size() > 1 ? "s" : "") + " (" + enablePlacesCount + " of " + placesCount + " place" + (placesCount > 1 ? "s" : "") + " enabled) ");
        } else {
            this.myCountLabel.setText("no injections configured ");
        }
    }

    @Nullable
    private AnAction getEditAction() {
        InjInfo info = this.getSelectedInjection();
        String supportId = info == null ? null : info.injection.getSupportId();
        return supportId == null ? null : this.myEditActions.get(supportId);
    }

    private void addInjection(BaseInjection injection) {
        InjInfo info = this.getDefaultCfgInfo().addInjection(injection);
        this.myInjectionsTable.getListTableModel().setItems(InjectionsSettingsUI.getInjInfoList(this.myInfos));
        int index = this.myInjectionsTable.convertRowIndexToView(this.myInjectionsTable.getListTableModel().getItems().indexOf(info));
        this.myInjectionsTable.getSelectionModel().setSelectionInterval(index, index);
        TableUtil.scrollSelectionToVisible((JTable)((Object)this.myInjectionsTable));
    }

    private CfgInfo getDefaultCfgInfo() {
        return this.myInfos[0];
    }

    public boolean hasOwnContent() {
        return true;
    }

    protected Configurable[] buildConfigurables() {
        ArrayList configurables = new ArrayList();
        for (LanguageInjectionSupport support : InjectorUtils.getActiveInjectionSupports()) {
            ContainerUtil.addAll(configurables, (Object[])support.createSettings(this.myProject, this.myConfiguration));
        }
        Collections.sort(configurables, (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getDisplayName()), (Comparable)((Object)o2.getDisplayName())));
        return configurables.toArray(new Configurable[configurables.size()]);
    }

    @NotNull
    public String getId() {
        if ("IntelliLang.Configuration" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/InjectionsSettingsUI", "getId"));
        }
        return "IntelliLang.Configuration";
    }

    private static void sortInjections(List<BaseInjection> injections) {
        Collections.sort(injections, (o1, o2) -> {
            int support = Comparing.compare((Comparable)((Object)o1.getSupportId()), (Comparable)((Object)o2.getSupportId()));
            if (support != 0) {
                return support;
            }
            int lang = Comparing.compare((Comparable)((Object)o1.getInjectedLanguageId()), (Comparable)((Object)o2.getInjectedLanguageId()));
            if (lang != 0) {
                return lang;
            }
            return Comparing.compare((Comparable)((Object)o1.getDisplayName()), (Comparable)((Object)o2.getDisplayName()));
        });
    }

    public JComponent createComponent() {
        return this.myRoot;
    }

    public void reset() {
        for (CfgInfo info : this.myInfos) {
            info.reset();
        }
        this.myInjectionsTable.getListTableModel().setItems(InjectionsSettingsUI.getInjInfoList(this.myInfos));
        this.updateCountLabel();
    }

    public void apply() {
        for (CfgInfo info : this.myInfos) {
            info.apply();
        }
        this.reset();
    }

    public boolean isModified() {
        return Arrays.stream(this.myInfos).anyMatch(CfgInfo::isModified);
    }

    private void performSelectedInjectionsEnabled(boolean enabled) {
        for (InjInfo info : this.getSelectedInjections()) {
            info.injection.setPlaceEnabled(null, enabled);
        }
        this.myInjectionsTable.updateUI();
        this.updateCountLabel();
    }

    private void performToggleAction() {
        List<InjInfo> selectedInjections = this.getSelectedInjections();
        boolean enabledExists = false;
        boolean disabledExists = false;
        for (InjInfo info : selectedInjections) {
            if (info.injection.isEnabled()) {
                enabledExists = true;
            } else {
                disabledExists = true;
            }
            if (!enabledExists || !disabledExists) continue;
            break;
        }
        boolean allEnabled = !enabledExists && disabledExists;
        this.performSelectedInjectionsEnabled(allEnabled);
    }

    private void performRemove() {
        int selectedRow = this.myInjectionsTable.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        List<InjInfo> selected = this.getSelectedInjections();
        for (InjInfo info : selected) {
            if (info.bundled) continue;
            info.cfgInfo.injectionInfos.remove(info);
        }
        this.myInjectionsTable.getListTableModel().setItems(InjectionsSettingsUI.getInjInfoList(this.myInfos));
        int index = Math.min(this.myInjectionsTable.getListTableModel().getRowCount() - 1, selectedRow);
        this.myInjectionsTable.getSelectionModel().setSelectionInterval(index, index);
        TableUtil.scrollSelectionToVisible((JTable)((Object)this.myInjectionsTable));
        this.updateCountLabel();
    }

    private List<InjInfo> getSelectedInjections() {
        ArrayList<InjInfo> toRemove = new ArrayList<InjInfo>();
        for (int row : this.myInjectionsTable.getSelectedRows()) {
            toRemove.add((InjInfo)this.myInjectionsTable.getItems().get(this.myInjectionsTable.convertRowIndexToModel(row)));
        }
        return toRemove;
    }

    @Nullable
    private InjInfo getSelectedInjection() {
        int row = this.myInjectionsTable.getSelectedRow();
        return row < 0 ? null : (InjInfo)this.myInjectionsTable.getItems().get(this.myInjectionsTable.convertRowIndexToModel(row));
    }

    private void performAdd(AnActionButton e) {
        DefaultActionGroup group = new DefaultActionGroup(this.myAddActions);
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, e.getDataContext(), JBPopupFactory.ActionSelectionAid.NUMBERING, true, () -> this.updateCountLabel(), -1).show(e.getPreferredPopupPoint());
    }

    @Nls
    public String getDisplayName() {
        return "Language Injections";
    }

    public String getHelpTopic() {
        return "reference.settings.injection.language.injection.settings";
    }

    private ColumnInfo[] createInjectionColumnInfos() {
        BooleanTableCellRenderer booleanCellRenderer = InjectionsSettingsUI.createBooleanCellRenderer();
        final TableCellRenderer displayNameCellRenderer = this.createDisplayNameCellRenderer();
        final TableCellRenderer languageCellRenderer = InjectionsSettingsUI.createLanguageCellRenderer();
        final Comparator languageComparator = (o1, o2) -> Comparing.compare((Comparable)((Object)o1.injection.getInjectedLanguageId()), (Comparable)((Object)o2.injection.getInjectedLanguageId()));
        final Comparator displayNameComparator = (o1, o2) -> {
            int support = Comparing.compare((Comparable)((Object)o1.injection.getSupportId()), (Comparable)((Object)o2.injection.getSupportId()));
            if (support != 0) {
                return support;
            }
            return Comparing.compare((Comparable)((Object)o1.injection.getDisplayName()), (Comparable)((Object)o2.injection.getDisplayName()));
        };
        Object[] columnInfos = new ColumnInfo[]{new ColumnInfo<InjInfo, Boolean>(" ", (TableCellRenderer)booleanCellRenderer){
            final /* synthetic */ TableCellRenderer val$booleanCellRenderer;
            {
                this.val$booleanCellRenderer = tableCellRenderer;
                super(x0);
            }

            public Class getColumnClass() {
                return Boolean.class;
            }

            public Boolean valueOf(InjInfo o) {
                return o.injection.isEnabled();
            }

            public boolean isCellEditable(InjInfo injection) {
                return true;
            }

            public void setValue(InjInfo injection, Boolean value) {
                injection.injection.setPlaceEnabled(null, value);
            }

            public TableCellRenderer getRenderer(InjInfo injection) {
                return this.val$booleanCellRenderer;
            }
        }, new ColumnInfo<InjInfo, InjInfo>("Name"){

            public InjInfo valueOf(InjInfo info) {
                return info;
            }

            public Comparator<InjInfo> getComparator() {
                return displayNameComparator;
            }

            public TableCellRenderer getRenderer(InjInfo injection) {
                return displayNameCellRenderer;
            }
        }, new ColumnInfo<InjInfo, InjInfo>("Language"){

            public InjInfo valueOf(InjInfo info) {
                return info;
            }

            public Comparator<InjInfo> getComparator() {
                return languageComparator;
            }

            public TableCellRenderer getRenderer(InjInfo info) {
                return languageCellRenderer;
            }
        }};
        if (this.myInfos.length > 1) {
            final TableCellRenderer typeRenderer = InjectionsSettingsUI.createTypeRenderer();
            return (ColumnInfo[])ArrayUtil.append((Object[])columnInfos, (Object)new ColumnInfo<InjInfo, String>("Scope"){

                public String valueOf(InjInfo info) {
                    return info.bundled ? "Built-in" : info.cfgInfo.title;
                }

                public TableCellRenderer getRenderer(InjInfo injInfo) {
                    return typeRenderer;
                }

                public int getWidth(JTable table) {
                    return table.getFontMetrics(table.getFont()).stringWidth(StringUtil.repeatSymbol((char)'m', (int)6));
                }

                public Comparator<InjInfo> getComparator() {
                    return (o1, o2) -> Comparing.compare((Comparable)((Object)this.valueOf((InjInfo)o1)), (Comparable)((Object)this.valueOf((InjInfo)o2)));
                }
            });
        }
        return columnInfos;
    }

    private static BooleanTableCellRenderer createBooleanCellRenderer() {
        return new BooleanTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return InjectionsSettingsUI.setLabelColors(super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column), table, isSelected, row);
            }
        };
    }

    private static TableCellRenderer createLanguageCellRenderer() {
        return new TableCellRenderer(){
            final JLabel myLabel = new JLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                InjInfo injection = (InjInfo)value;
                if (injection == null) {
                    return this.myLabel;
                }
                String languageId = injection.injection.getInjectedLanguageId();
                Language language = InjectedLanguage.findLanguageById(languageId);
                LanguageFileType fileType = language == null ? null : language.getAssociatedFileType();
                this.myLabel.setIcon(fileType == null ? null : fileType.getIcon());
                this.myLabel.setText(language == null ? languageId : language.getDisplayName());
                InjectionsSettingsUI.setLabelColors(this.myLabel, table, isSelected, row);
                return this.myLabel;
            }
        };
    }

    private TableCellRenderer createDisplayNameCellRenderer() {
        return new TableCellRenderer(){
            final SimpleColoredComponent myLabel = new SimpleColoredComponent();
            final SimpleColoredText myText = new SimpleColoredText();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.myLabel.clear();
                InjInfo info = (InjInfo)value;
                if (info == null) {
                    return this.myLabel;
                }
                SimpleTextAttributes grayAttrs = isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
                String supportId = info.injection.getSupportId();
                this.myText.append(supportId + ": ", grayAttrs);
                ((LanguageInjectionSupport)InjectionsSettingsUI.this.mySupports.get(supportId)).setupPresentation(info.injection, this.myText, isSelected);
                this.myText.appendToComponent((ColoredTextContainer)this.myLabel);
                this.myText.clear();
                InjectionsSettingsUI.setLabelColors((Component)this.myLabel, table, isSelected, row);
                return this.myLabel;
            }
        };
    }

    private static TableCellRenderer createTypeRenderer() {
        return new TableCellRenderer(){
            final SimpleColoredComponent myLabel = new SimpleColoredComponent();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.myLabel.clear();
                String info = (String)value;
                if (info == null) {
                    return this.myLabel;
                }
                SimpleTextAttributes grayAttrs = isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
                this.myLabel.append(info, grayAttrs);
                InjectionsSettingsUI.setLabelColors((Component)this.myLabel, table, isSelected, row);
                return this.myLabel;
            }
        };
    }

    private static Component setLabelColors(Component label, JTable table, boolean isSelected, int row) {
        if (label instanceof JComponent) {
            ((JComponent)label).setOpaque(true);
        }
        label.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        label.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        return label;
    }

    private void doImportAction(DataContext dataContext) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, false, true, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || "xml".equals(file.getExtension()) || file.getFileType() == FileTypes.ARCHIVE);
            }

            public boolean isFileSelectable(VirtualFile file) {
                return file.getFileType() == StdFileTypes.XML;
            }
        };
        descriptor.setDescription("Please select the configuration file (usually named IntelliLang.xml) to import.");
        descriptor.setTitle("Import Configuration");
        descriptor.putUserData(LangDataKeys.MODULE_CONTEXT, LangDataKeys.MODULE.getData(dataContext));
        SplitterProportionsDataImpl splitterData = new SplitterProportionsDataImpl();
        splitterData.externalizeFromDimensionService("IntelliLang.ImportSettingsKey.SplitterProportions");
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.myProject, null);
        if (file == null) {
            return;
        }
        try {
            Configuration cfg = Configuration.load(file.getInputStream());
            if (cfg == null) {
                Messages.showWarningDialog((Project)this.myProject, (String)"The selected file does not contain any importable configuration.", (String)"Nothing to Import");
                return;
            }
            CfgInfo info = this.getDefaultCfgInfo();
            Map currentMap = ContainerUtil.classify(info.injectionInfos.iterator(), (Convertor)new Convertor<InjInfo, String>(){

                public String convert(InjInfo o) {
                    return o.injection.getSupportId();
                }
            });
            ArrayList<BaseInjection> originalInjections = new ArrayList<BaseInjection>();
            ArrayList<BaseInjection> newInjections = new ArrayList<BaseInjection>();
            for (String supportId : InjectorUtils.getActiveInjectionSupportIds()) {
                ArrayList<InjInfo> list = new ArrayList<InjInfo>((Collection)ObjectUtils.notNull(currentMap.get(supportId), Collections.emptyList()));
                List<BaseInjection> currentInjections = InjectionsSettingsUI.getInjectionList(list);
                List<BaseInjection> importingInjections = cfg.getInjections(supportId);
                if (currentInjections == null) {
                    newInjections.addAll(importingInjections);
                    continue;
                }
                Configuration.importInjections(currentInjections, importingInjections, originalInjections, newInjections);
            }
            info.replace(originalInjections, newInjections);
            this.myInjectionsTable.getListTableModel().setItems(InjectionsSettingsUI.getInjInfoList(this.myInfos));
            int n = newInjections.size();
            if (n > 1) {
                Messages.showInfoMessage((Project)this.myProject, (String)(n + " entries have been successfully imported"), (String)"Import Successful");
            } else if (n == 1) {
                Messages.showInfoMessage((Project)this.myProject, (String)"One entry has been successfully imported", (String)"Import Successful");
            } else {
                Messages.showInfoMessage((Project)this.myProject, (String)"No new entries have been imported", (String)"Import");
            }
        }
        catch (Exception ex) {
            Configuration.LOG.error((Throwable)ex);
            String msg = ex.getLocalizedMessage();
            Messages.showErrorDialog((Project)this.myProject, (String)(msg != null && msg.length() > 0 ? msg : ex.toString()), (String)"Import Failed");
        }
    }

    private static List<InjInfo> getInjInfoList(CfgInfo[] infos) {
        return ContainerUtil.concat((Object[])infos, (Function)new Function<CfgInfo, Collection<? extends InjInfo>>(){

            public Collection<InjInfo> fun(CfgInfo cfgInfo) {
                return cfgInfo.injectionInfos;
            }
        });
    }

    private static List<BaseInjection> getInjectionList(final List<InjInfo> list) {
        return new AbstractList<BaseInjection>(){

            @Override
            public BaseInjection get(int index) {
                return ((InjInfo)list.get((int)index)).injection;
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    private static class InjInfo {
        final BaseInjection injection;
        final CfgInfo cfgInfo;
        final boolean bundled;

        private InjInfo(BaseInjection injection, CfgInfo cfgInfo, boolean bundled) {
            this.injection = injection;
            this.cfgInfo = cfgInfo;
            this.bundled = bundled;
        }
    }

    private static class SameParamsAndPlacesStrategy
    implements TObjectHashingStrategy<BaseInjection> {
        private SameParamsAndPlacesStrategy() {
        }

        public int computeHashCode(BaseInjection object) {
            return object.hashCode();
        }

        public boolean equals(BaseInjection o1, BaseInjection o2) {
            return o1.sameLanguageParameters(o2) && Arrays.equals(o1.getInjectionPlaces(), o2.getInjectionPlaces());
        }
    }

    private static class CfgInfo {
        final Configuration cfg;
        final List<BaseInjection> originalInjections;
        final List<InjInfo> injectionInfos = new ArrayList<InjInfo>();
        final THashSet<BaseInjection> bundledInjections = new THashSet((TObjectHashingStrategy)new SameParamsAndPlacesStrategy());
        final String title;

        public CfgInfo(Configuration cfg, String title) {
            this.cfg = cfg;
            this.title = title;
            this.bundledInjections.addAll(cfg.getDefaultInjections());
            this.originalInjections = new ArrayList<BaseInjection>(ContainerUtil.concat(InjectorUtils.getActiveInjectionSupportIds(), s -> {
                List<BaseInjection> injections = this.cfg instanceof Configuration.Prj ? ((Configuration.Prj)this.cfg).getOwnInjections((String)s) : this.cfg.getInjections((String)s);
                return ContainerUtil.findAll(injections, injection -> {
                    String id = injection.getInjectedLanguageId();
                    return InjectedLanguage.findLanguageById(id) != null || ReferenceInjector.findById((String)id) != null;
                });
            }));
            InjectionsSettingsUI.sortInjections(this.originalInjections);
            this.reset();
        }

        public void apply() {
            List injectionList = InjectionsSettingsUI.getInjectionList(this.injectionInfos);
            this.cfg.replaceInjections(injectionList, this.originalInjections, true);
            this.originalInjections.clear();
            this.originalInjections.addAll(injectionList);
            InjectionsSettingsUI.sortInjections(this.originalInjections);
            FileContentUtil.reparseOpenedFiles();
        }

        public void reset() {
            this.injectionInfos.clear();
            for (BaseInjection injection : this.originalInjections) {
                this.injectionInfos.add(new InjInfo(injection.copy(), this, this.bundledInjections.contains((Object)injection)));
            }
        }

        public InjInfo addInjection(BaseInjection injection) {
            InjInfo info = new InjInfo(injection, this, false);
            this.injectionInfos.add(info);
            return info;
        }

        public boolean isModified() {
            ArrayList copy = new ArrayList(InjectionsSettingsUI.getInjectionList(this.injectionInfos));
            InjectionsSettingsUI.sortInjections(copy);
            return !this.originalInjections.equals(copy);
        }

        public void replace(List<BaseInjection> originalInjections, List<BaseInjection> newInjections) {
            Iterator<InjInfo> it = this.injectionInfos.iterator();
            while (it.hasNext()) {
                InjInfo info = it.next();
                if (!originalInjections.contains(info.injection)) continue;
                it.remove();
            }
            for (BaseInjection newInjection : newInjections) {
                this.injectionInfos.add(new InjInfo(newInjection, this, false));
            }
        }
    }

    private class InjectionsTable
    extends TableView<InjInfo> {
        private InjectionsTable(List<InjInfo> injections) {
            super(new ListTableModel(InjectionsSettingsUI.this.createInjectionColumnInfos(), injections, 1));
            this.setAutoResizeMode(3);
            this.getColumnModel().getColumn(2).setCellRenderer(InjectionsSettingsUI.createLanguageCellRenderer());
            this.getColumnModel().getColumn(1).setCellRenderer(InjectionsSettingsUI.this.createDisplayNameCellRenderer());
            this.getColumnModel().getColumn(0).setResizable(false);
            this.setShowGrid(false);
            this.setShowVerticalLines(false);
            this.setGridColor(this.getForeground());
            TableUtil.setupCheckboxColumn((TableColumn)this.getColumnModel().getColumn(0));
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent e) {
                    int row = InjectionsTable.this.rowAtPoint(e.getPoint());
                    if (row < 0) {
                        return false;
                    }
                    if (InjectionsTable.this.columnAtPoint(e.getPoint()) <= 0) {
                        return false;
                    }
                    InjectionsSettingsUI.this.myInjectionsTable.getSelectionModel().setSelectionInterval(row, row);
                    InjectionsSettingsUI.this.performEditAction();
                    return true;
                }
            }.installOn((Component)((Object)this));
            String[] maxName = new String[]{""};
            ContainerUtil.process(injections, injection -> {
                String displayName;
                String languageId = injection.injection.getInjectedLanguageId();
                Language language = InjectedLanguage.findLanguageById(languageId);
                String string = displayName = language == null ? languageId : language.getDisplayName();
                if (maxName[0].length() < displayName.length()) {
                    maxName[0] = displayName;
                }
                return true;
            });
            ContainerUtil.process((Object[])InjectedLanguage.getAvailableLanguages(), language -> {
                String displayName = language.getDisplayName();
                if (maxName[0].length() < displayName.length()) {
                    maxName[0] = displayName;
                }
                return true;
            });
            Icon icon = FileTypes.PLAIN_TEXT.getIcon();
            int preferred = (int)((double)new JLabel((String)maxName[0], (Icon)icon, (int)2).getPreferredSize().width * 1.1);
            this.getColumnModel().getColumn(2).setMinWidth(preferred);
            this.getColumnModel().getColumn(2).setPreferredWidth(preferred);
            this.getColumnModel().getColumn(2).setMaxWidth(preferred);
            new TableViewSpeedSearch<InjInfo>((TableView)this){

                protected String getItemText(@NotNull InjInfo element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/plugins/intelliLang/InjectionsSettingsUI$InjectionsTable$2", "getItemText"));
                    }
                    BaseInjection injection = element.injection;
                    return injection.getSupportId() + " " + injection.getInjectedLanguageId() + " " + injection.getDisplayName();
                }
            };
        }
    }
}

