/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.actions.CssBaseElementAtCaretIntentionAction;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CssExpandShorthandPropertyAction
extends CssBaseElementAtCaretIntentionAction {
    @NotNull
    public String getText() {
        String string = CssBundle.message((String)"expand.shorthand.action", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/CssExpandShorthandPropertyAction", "getText"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/CssExpandShorthandPropertyAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/CssExpandShorthandPropertyAction", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        CssDeclaration cssDeclaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class);
        return cssDeclaration != null && cssDeclaration.isShorthandProperty();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"expand.shorthand.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/actions/CssExpandShorthandPropertyAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/css/actions/CssExpandShorthandPropertyAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/actions/CssExpandShorthandPropertyAction", "invoke"));
        }
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, CssDeclaration.class);
        if (declaration != null && declaration.isShorthandProperty()) {
            String[] properties = declaration.expandShorthandProperty();
            Map<String, String> name2value = CssPropertyUtil.getExpandedShorthandValues(declaration, properties);
            PsiElement parent1 = declaration.getParent();
            if (parent1 instanceof CssBlock) {
                if (!name2value.isEmpty()) {
                    CssBlock block = (CssBlock)parent1;
                    for (String name : name2value.keySet()) {
                        block.addDeclaration(name, name2value.get(name), declaration);
                    }
                    block.removeDeclaration(declaration);
                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                } else {
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message((String)"expand.shorthand.error", (Object[])new Object[0]), (String)"", null);
                }
            }
        }
    }
}

