/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CssHighlightingAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "annotate"));
        }
        if (holder.isBatchMode()) {
            return;
        }
        if (element instanceof CssSimpleSelector) {
            PsiElement identifier = ((CssSimpleSelector)element).getNameIdentifier();
            String elementName = ((CssSimpleSelector)element).getElementName();
            if (identifier != null && CssDescriptorsUtil.isPossibleSelector((String)elementName, (PsiElement)element)) {
                TextAttributesKey key = CssHighlightingAnnotator.getTextAttributesKey(element, CssElementTypes.CSS_TAG_NAME, CssHighlighter.CSS_TAG_NAME);
                String annotationMessage = ApplicationManager.getApplication().isUnitTestMode() ? key.getExternalName() : null;
                holder.createInfoAnnotation(identifier, annotationMessage).setTextAttributes(key);
            }
        }
        if (element.getNode().getElementType() == CssElementTypes.CSS_ATKEYWORD) {
            TextAttributesKey key = CssHighlightingAnnotator.getTextAttributesKey(element, CssElementTypes.CSS_KEYWORD, CssHighlighter.CSS_KEYWORD);
            String annotationMessage = ApplicationManager.getApplication().isUnitTestMode() ? key.getExternalName() : null;
            holder.createInfoAnnotation(element, annotationMessage).setTextAttributes(key);
        }
    }

    private static TextAttributesKey getTextAttributesKey(@NotNull PsiElement element, @NotNull IElementType elementType, @NotNull TextAttributesKey defaultKey) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "getTextAttributesKey"));
        }
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "getTextAttributesKey"));
        }
        if (defaultKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultKey", "com/intellij/psi/css/impl/util/CssHighlightingAnnotator", "getTextAttributesKey"));
        }
        Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)element);
        if (language == null) {
            return defaultKey;
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)element.getProject(), (VirtualFile)element.getContainingFile().getVirtualFile());
        Object[] keys = highlighter.getTokenHighlights(elementType);
        return ArrayUtil.isEmpty((Object[])keys) ? defaultKey : (TextAttributesKey)ArrayUtil.getLastElement((Object[])keys);
    }
}

