/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.impl.util.completion.CssUserLookupBase;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class CssSuffixUserLookup
extends CssUserLookupBase {
    private final String[] mySuffixes;
    private final String myDefaultSuffix;

    public CssSuffixUserLookup(@NotNull String presentableText, @NotNull String[] suffixes) {
        if (presentableText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableText", "com/intellij/psi/css/impl/util/completion/CssSuffixUserLookup", "<init>"));
        }
        if (suffixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffixes", "com/intellij/psi/css/impl/util/completion/CssSuffixUserLookup", "<init>"));
        }
        super(presentableText);
        this.mySuffixes = suffixes;
        this.myDefaultSuffix = StringUtil.notNullize((String)((String)ArrayUtil.getFirstElement((Object[])this.mySuffixes)));
    }

    @Override
    protected void addAdditionalVariablesAfter(Template template) {
        final TextResult textResult = new TextResult(this.myDefaultSuffix);
        Expression expression = new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return textResult;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return null;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>();
                for (String suffix : CssSuffixUserLookup.this.mySuffixes) {
                    result.add(LookupElementBuilder.create((String)suffix));
                }
                return result.toArray(new LookupElement[result.size()]);
            }
        };
        template.addVariable("suffixes", expression, expression, true);
    }
}

