/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.references;

import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssKeyframesRule;
import com.intellij.psi.css.index.CssIndex;
import com.intellij.psi.css.index.CssIndexValue;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssKeyframesReference
extends PsiReferenceBase<PsiElement>
implements PsiPolyVariantReference,
CssReference {
    public CssKeyframesReference(PsiElement psiElement) {
        super(psiElement);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)"unresolved.css.keyframes", (Object[])new Object[]{this.getCanonicalText()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssKeyframesReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        final HashSet result = Sets.newHashSet();
        final Project project = this.myElement.getProject();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        String key = CssIndexValue.KEYFRAMES.indexKey(this.getCanonicalText());
        FileBasedIndex.getInstance().processValues(CssIndex.CSS_INDEX, (Object)key, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<TIntArrayList>(){

            public boolean process(VirtualFile file, TIntArrayList value) {
                final PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                if (psiFile == null) {
                    return true;
                }
                value.forEach(new TIntProcedure(){

                    public boolean execute(int offset) {
                        PsiElement at = PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(offset), CssKeyframesRule.class);
                        if (at != null) {
                            result.add(new PsiElementResolveResult(at));
                        }
                        return true;
                    }
                });
                return true;
            }
        }, scope);
        ResolveResult[] resolveResultArray = !result.isEmpty() ? result.toArray(new ResolveResult[result.size()]) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssKeyframesReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/references/CssKeyframesReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

