/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssPropertyInfo;
import com.intellij.psi.css.CssPropertyValue;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssExpandedValue;
import com.intellij.psi.css.impl.util.table.CssFontFamilyValue;
import com.intellij.psi.css.impl.util.table.CssPropertyDescriptorImpl;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.css.index.CssIndex;
import com.intellij.psi.css.index.CssIndexValue;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.GraphicsEnvironment;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CssFontFamilyDescriptor
extends CssPropertyDescriptorImpl {
    private final CssPropertyValueImpl myInternalValue;

    public CssFontFamilyDescriptor(@NotNull String propertyName, @NotNull CssPropertyInfo[] infos) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/psi/css/impl/util/table/CssFontFamilyDescriptor", "<init>"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/psi/css/impl/util/table/CssFontFamilyDescriptor", "<init>"));
        }
        super(propertyName, infos);
        this.myInternalValue = CssExpandedValue.createGenericFontFamilyValue();
    }

    @Override
    public void setValue(@NotNull CssPropertyValueImpl value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/util/table/CssFontFamilyDescriptor", "setValue"));
        }
        super.setValue(value);
    }

    @Override
    @NotNull
    public Object[] getVariants(@NotNull PsiElement contextElement) {
        CssTermList termList;
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/psi/css/impl/util/table/CssFontFamilyDescriptor", "getVariants"));
        }
        CssDeclaration cssDeclaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)contextElement, CssDeclaration.class);
        CssTermList cssTermList = termList = cssDeclaration != null ? cssDeclaration.getValue() : null;
        if (termList != null) {
            PsiLanguageInjectionHost injectionHost;
            CssElement topmostParentOfType;
            boolean lastComma = false;
            PsiElement[] children = termList.getChildren();
            for (int i = children.length - 1; i >= 0 && !(children[i] instanceof CssTerm); --i) {
                if (!(children[i] instanceof LeafElement) || !",".equals(children[i].getText())) continue;
                lastComma = true;
                break;
            }
            HashSet exclude = ContainerUtil.newHashSet();
            CssPropertyValueImpl internalValue = this.getInternalValue();
            for (CssPropertyValue value : internalValue.getChildren()) {
                Object excludeValue = value.getValue();
                if (!(excludeValue instanceof String)) continue;
                exclude.add((String)excludeValue);
            }
            CssFontFamilyValue fontFamilyValue = new CssFontFamilyValue();
            boolean wrappedWithDoubleQuote = false;
            if (!(contextElement.getContainingFile() instanceof StylesheetFile) && (topmostParentOfType = (CssElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)contextElement, CssElement.class)) != null) {
                PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)topmostParentOfType);
                boolean bl = wrappedWithDoubleQuote = prev != null && StringUtil.endsWithChar((CharSequence)prev.getText(), (char)'\"');
            }
            if ((injectionHost = InjectedLanguageUtil.findInjectionHost((PsiElement)contextElement)) != null && StringUtil.startsWithChar((CharSequence)injectionHost.getText(), (char)'\"') && StringUtil.endsWithChar((CharSequence)injectionHost.getText(), (char)'\"')) {
                wrappedWithDoubleQuote = true;
            }
            String quote = wrappedWithDoubleQuote ? "'" : "\"";
            HashSet fontNames = ContainerUtil.newHashSet();
            Collections.addAll(fontNames, CssFontFamilyDescriptor.getPopularFontFamilies(contextElement, termList));
            Collections.addAll(fontNames, CssFontFamilyDescriptor.getPopularFontPacks(termList));
            Collections.addAll(fontNames, CssFontFamilyDescriptor.getSystemFontFamilies());
            for (String s : fontNames) {
                if (exclude.contains(s)) continue;
                fontFamilyValue.addChild(CssFontFamilyDescriptor.createPropertyValue(quote, s));
            }
            if (lastComma) {
                Object[] objectArray = CssFontFamilyDescriptor.gatherVariants(contextElement, fontFamilyValue, internalValue);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssFontFamilyDescriptor", "getVariants"));
                }
                return objectArray;
            }
            Object[] objectArray = CssFontFamilyDescriptor.gatherVariants(contextElement, fontFamilyValue, internalValue, new CssPropertyValueImpl("inherit"));
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssFontFamilyDescriptor", "getVariants"));
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/table/CssFontFamilyDescriptor", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public static String[] getSystemFontFamilies() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            return graphicsEnvironment.getAvailableFontFamilyNames();
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    private static CssPropertyValueImpl createPropertyValue(final String quote, String fontName) {
        LookupElementBuilder builder = LookupElementBuilder.create((String)fontName).withLookupString(fontName.toLowerCase(Locale.US));
        if (StringUtil.containsChar((String)fontName, (char)' ') && !StringUtil.containsAnyChar((String)fontName, (String)"'\",")) {
            LookupElementBuilder v = builder.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    Document document = context.getDocument();
                    int offset = context.getEditor().getCaretModel().getOffset();
                    document.insertString(offset, (CharSequence)quote);
                    int startOffset = context.getStartOffset();
                    document.insertString(startOffset, (CharSequence)quote);
                    context.getEditor().getCaretModel().moveToOffset(offset + 2);
                    PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
                }
            });
            return new CssPropertyValueImpl(v);
        }
        return new CssPropertyValueImpl(builder);
    }

    public static String[] getPopularFontFamilies(PsiElement context, @NotNull CssTermList termList) {
        if (termList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termList", "com/intellij/psi/css/impl/util/table/CssFontFamilyDescriptor", "getPopularFontFamilies"));
        }
        com.intellij.util.containers.HashSet values = new com.intellij.util.containers.HashSet();
        for (PsiElement child : termList.getChildren()) {
            String text;
            PsiElement originalChild = CompletionUtil.getOriginalElement((PsiElement)child);
            if (!(originalChild instanceof CssTerm) || (text = originalChild.getText()) == null) continue;
            values.add(StringUtil.unquoteString((String)text).toLowerCase(Locale.US));
        }
        String currentValue = CssFontFamilyDescriptor.getCurrentValue(context);
        HashSet result = Sets.newHashSet();
        Processor collectProcessor = arg_0 -> CssFontFamilyDescriptor.lambda$getPopularFontFamilies$0((Set)values, currentValue, result, arg_0);
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)termList);
        CssIndexUtil.processKeysInScope(CssIndex.CSS_INDEX, termList.getProject(), scope, (Processor<String>)collectProcessor);
        return ArrayUtil.toStringArray((Collection)result);
    }

    public static String[] getPopularFontPacks(@NotNull CssTermList termList) {
        if (termList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "termList", "com/intellij/psi/css/impl/util/table/CssFontFamilyDescriptor", "getPopularFontPacks"));
        }
        CssTermList originalTermList = (CssTermList)CompletionUtil.getOriginalElement((PsiElement)termList);
        String currentValue = originalTermList != null ? originalTermList.getText().trim() : "";
        HashSet result = Sets.newHashSet();
        Processor collectProcessor = s -> {
            CssIndexValue type = CssIndexValue.keyType(s);
            if (type == CssIndexValue.FONT_FAMILY_PACK) {
                String key = CssIndexValue.realKey(s);
                String keyLowerCase = key.toLowerCase(Locale.US);
                if (!key.isEmpty() && !currentValue.toLowerCase(Locale.US).startsWith(keyLowerCase)) {
                    result.add(key);
                }
            }
            return true;
        };
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)termList);
        CssIndexUtil.processKeysInScope(CssIndex.CSS_INDEX, termList.getProject(), scope, (Processor<String>)collectProcessor);
        return ArrayUtil.toStringArray((Collection)result);
    }

    private static String getCurrentValue(PsiElement context) {
        String currentValue = context instanceof CssString ? ((CssString)context).getValue() : (context instanceof LeafElement && ((LeafElement)context).getElementType() == CssElementTypes.CSS_IDENT ? context.getText() : null);
        return currentValue;
    }

    protected CssPropertyValueImpl getInternalValue() {
        return this.myInternalValue;
    }

    @Override
    public boolean isValidValue(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/table/CssFontFamilyDescriptor", "isValidValue"));
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getPopularFontFamilies$0(Set values, String currentValue, Set result, String s) {
        String key;
        String keyLowerCase;
        CssIndexValue type = CssIndexValue.keyType(s);
        if (!(type != CssIndexValue.FONT_FAMILY || values.contains(keyLowerCase = (key = CssIndexValue.realKey(s)).toLowerCase(Locale.US)) || key.isEmpty() || currentValue != null && currentValue.toLowerCase(Locale.US).startsWith(keyLowerCase))) {
            result.remove(StringUtil.decapitalize((String)key));
            if (!result.contains(StringUtil.capitalize((String)key))) {
                result.add(key);
            }
        }
        return true;
    }
}

