/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.actions;

import com.intellij.gwt.actions.CreateGwtModuleAction;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.GuiUtils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;

public class CreateGwtModuleDialog
extends DialogWrapper {
    private JTextField myGwtModuleNameField;
    private JCheckBox myCreateHtmlFileCheckBox;
    private ComboboxWithBrowseButton myHtmlDirectoryPathField;
    private final InputValidator myValidator;
    private final PsiDirectory mySourceDirectory;
    private final Ref<String> myHtmlDirectoryRef;
    private boolean myAdjustingDirectory;
    private boolean myDirectoryWasChangedByHand;
    private final JComboBox myComboBox;
    private JPanel myContentPanel;

    public CreateGwtModuleDialog(String dialogTitle, GwtFacet facet, InputValidator validator, PsiDirectory sourceDirectory, Ref<String> htmlDirectoryRef) {
        super(facet.getModule().getProject(), true);
        this.$$$setupUI$$$();
        this.myComboBox = this.myHtmlDirectoryPathField.getComboBox();
        this.myValidator = validator;
        this.mySourceDirectory = sourceDirectory;
        this.myHtmlDirectoryRef = htmlDirectoryRef;
        this.setTitle(dialogTitle);
        this.setOKActionEnabled(false);
        this.myGwtModuleNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CreateGwtModuleDialog.this.setOKActionEnabled(CreateGwtModuleDialog.this.myGwtModuleNameField.getText().trim().length() > 0);
                CreateGwtModuleDialog.this.adjustDirectory();
            }
        });
        this.myCreateHtmlFileCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtils.enableChildren((boolean)CreateGwtModuleDialog.this.myCreateHtmlFileCheckBox.isSelected(), (Component[])new Component[]{CreateGwtModuleDialog.this.myHtmlDirectoryPathField});
            }
        });
        this.myComboBox.setEditable(true);
        ((JTextComponent)this.myComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!CreateGwtModuleDialog.this.myAdjustingDirectory) {
                    CreateGwtModuleDialog.this.myDirectoryWasChangedByHand = true;
                }
            }
        });
        this.myAdjustingDirectory = true;
        WebFacet webFacet = facet.getWebFacet();
        if (webFacet != null) {
            for (WebRoot webRoot : webFacet.getWebRoots()) {
                this.myComboBox.addItem(FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)webRoot.getDirectoryUrl())));
            }
        }
        this.myComboBox.addItem(this.computeHtmlDirectoryInSourcesPath());
        this.myComboBox.setSelectedIndex(0);
        this.myAdjustingDirectory = false;
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setRoots(ModuleRootManager.getInstance((Module)facet.getModule()).getContentRoots());
        this.myHtmlDirectoryPathField.addBrowseFolderListener(facet.getModule().getProject(), descriptor);
        this.init();
    }

    private String computeHtmlDirectoryInSourcesPath() {
        List names = StringUtil.split((String)this.myGwtModuleNameField.getText(), (String)".");
        PsiDirectory directory = names.size() > 1 ? CreateGwtModuleAction.getRootDirectory(this.mySourceDirectory) : this.mySourceDirectory;
        StringBuilder path = new StringBuilder(directory.getVirtualFile().getPath());
        for (int i = 0; i < names.size() - 1; ++i) {
            String name = (String)names.get(i);
            if (name.length() <= 0) continue;
            if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
                path.append('/');
            }
            path.append(StringUtil.decapitalize((String)name));
        }
        path.append("/").append("public");
        return FileUtil.toSystemDependentName((String)path.toString());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGwtModuleNameField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustDirectory() {
        if (this.myDirectoryWasChangedByHand) {
            return;
        }
        this.myAdjustingDirectory = true;
        try {
            int lastItemIndex = this.myComboBox.getItemCount() - 1;
            boolean isLastItemSelected = this.myComboBox.getSelectedItem().equals(this.myComboBox.getItemAt(lastItemIndex));
            String newPath = this.computeHtmlDirectoryInSourcesPath();
            if (isLastItemSelected) {
                this.myComboBox.getEditor().setItem(newPath);
            }
            this.myComboBox.removeItemAt(lastItemIndex);
            this.myComboBox.addItem(newPath);
        }
        finally {
            this.myAdjustingDirectory = false;
        }
    }

    protected JComponent createNorthPanel() {
        return this.myContentPanel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected void doOKAction() {
        String moduleName = this.myGwtModuleNameField.getText().trim();
        this.myHtmlDirectoryRef.set((Object)this.getHtmlDirectory());
        if (this.myValidator.checkInput(moduleName) && this.myValidator.canClose(moduleName)) {
            this.close(0);
        } else {
            this.close(1);
        }
    }

    @Nullable
    private String getHtmlDirectory() {
        if (this.myCreateHtmlFileCheckBox.isSelected()) {
            return FileUtil.toSystemIndependentName((String)((String)this.myComboBox.getSelectedItem()));
        }
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, "Center");
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/gwt/GwtBundle").getString("new.module.dlg.prompt"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGwtModuleNameField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        this.myCreateHtmlFileCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Create Html and Css files in directory");
        jCheckBox.setMnemonic('C');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel3, "South");
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0), null, 0, 0, null, null));
        this.myHtmlDirectoryPathField = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        jPanel3.add((Component)comboboxWithBrowseButton, "Center");
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

