/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle.css;

import com.intellij.gwt.clientBundle.css.GwtPropertyDescriptor;
import com.intellij.gwt.clientBundle.css.language.psi.impl.GwtCssFileImpl;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssPropertyDescriptorStub;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorProviderImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtCssElementDescriptorProvider
extends CssElementDescriptorProviderImpl {
    @NonNls
    public static final String GWT_IMAGE_PROPERTY_NAME = "gwt-image";

    public boolean isMyContext(@Nullable PsiElement context) {
        if (context == null || !context.isValid()) {
            return false;
        }
        PsiFile psiFile = InjectedLanguageManager.getInstance((Project)context.getProject()).getTopLevelFile(context);
        if (psiFile == null) {
            return false;
        }
        VirtualFile file = psiFile.getOriginalFile().getVirtualFile();
        return GwtFacet.findFacetBySourceFile(context.getProject(), file) != null;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
        ArrayList result = ContainerUtil.newArrayList();
        result.add(new CssPropertyDescriptorStub(GWT_IMAGE_PROPERTY_NAME));
        result.addAll(super.getAllPropertyDescriptors(context));
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/css/GwtCssElementDescriptorProvider", "getAllPropertyDescriptors"));
        }
        return arrayList;
    }

    public CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/gwt/clientBundle/css/GwtCssElementDescriptorProvider", "getPropertyDescriptor"));
        }
        if (GWT_IMAGE_PROPERTY_NAME.equals(propertyName)) {
            return new GwtPropertyDescriptor(GWT_IMAGE_PROPERTY_NAME);
        }
        return super.getPropertyDescriptor(propertyName, context);
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/gwt/clientBundle/css/GwtCssElementDescriptorProvider", "findPropertyDescriptors"));
        }
        if (GWT_IMAGE_PROPERTY_NAME.equals(propertyName)) {
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new GwtPropertyDescriptor[]{new GwtPropertyDescriptor(GWT_IMAGE_PROPERTY_NAME)});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/css/GwtCssElementDescriptorProvider", "findPropertyDescriptors"));
            }
            return arrayList;
        }
        Collection collection = super.findPropertyDescriptors(propertyName, context);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/css/GwtCssElementDescriptorProvider", "findPropertyDescriptors"));
        }
        return collection;
    }

    public boolean shouldAskOtherProviders(@Nullable PsiElement context) {
        PsiFile file = context != null ? context.getContainingFile() : null;
        return file instanceof StylesheetFile && !(file instanceof GwtCssFileImpl);
    }

    public CssContextType getCssContextType(@Nullable PsiElement context) {
        return CssContextType.ANY;
    }
}

