/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.i18n;

import com.intellij.gwt.i18n.GwtI18nManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class PropertiesSearcher
implements QueryExecutor<PsiElement, PsiElement> {
    public boolean execute(final @NotNull PsiElement sourceElement, @NotNull Processor<PsiElement> consumer) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/gwt/i18n/PropertiesSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/gwt/i18n/PropertiesSearcher", "execute"));
        }
        if (sourceElement instanceof PsiMethod) {
            IProperty[] properties;
            for (IProperty property : properties = (IProperty[])new ReadAction<IProperty[]>(){

                protected void run(@NotNull Result<IProperty[]> result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/gwt/i18n/PropertiesSearcher$1", "run"));
                    }
                    result.setResult((Object)GwtI18nManager.getInstance(sourceElement.getProject()).getProperties((PsiMethod)sourceElement));
                }
            }.execute().getResultObject()) {
                if (consumer.process((Object)property.getPsiElement())) continue;
                return false;
            }
            return true;
        }
        if (sourceElement instanceof PsiClass) {
            PropertiesFile[] files;
            for (PropertiesFile file : files = (PropertiesFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PropertiesFile[]>(){

                public PropertiesFile[] compute() {
                    return GwtI18nManager.getInstance(sourceElement.getProject()).getPropertiesFiles((PsiClass)sourceElement);
                }
            })) {
                if (consumer.process((Object)file.getContainingFile())) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

