/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.javadoc.PsiDocComment;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractClientCodeReferencesInspection
extends BaseGwtInspection {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/inspections/AbstractClientCodeReferencesInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/AbstractClientCodeReferencesInspection", "checkFile"));
        }
        if (!AbstractClientCodeReferencesInspection.shouldCheck((PsiElement)file)) {
            return null;
        }
        final GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(file.getProject());
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        final List<GwtModule> gwtModules = gwtModulesManager.findGwtModulesByClientSourceFile(virtualFile);
        if (gwtModules.isEmpty()) {
            return null;
        }
        final GwtFacet gwtFacet = GwtFacet.findFacetBySourceFile(file.getProject(), virtualFile);
        if (gwtFacet == null || !((GwtFacetConfiguration)gwtFacet.getConfiguration()).getSdk().isValid()) {
            return null;
        }
        final ArrayList problems = new ArrayList();
        file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitDocComment(PsiDocComment comment) {
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                PsiElement resolved = reference.resolve();
                if (resolved instanceof PsiClass) {
                    PsiClass referencedClass = (PsiClass)resolved;
                    String className = referencedClass.getQualifiedName();
                    if (referencedClass.isAnnotationType() || className == null) {
                        return;
                    }
                    PsiFile psiFile = referencedClass.getContainingFile();
                    if (psiFile == null) {
                        return;
                    }
                    VirtualFile vFile = psiFile.getVirtualFile();
                    if (vFile == null) {
                        return;
                    }
                    AbstractClientCodeReferencesInspection.this.checkClassReference(reference, referencedClass, className, vFile, gwtFacet, gwtModules, gwtModulesManager, manager, isOnTheFly, problems);
                } else if (resolved instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)resolved;
                    AbstractClientCodeReferencesInspection.this.checkMethodReference(reference, method, gwtFacet, gwtModules, gwtModulesManager, manager, isOnTheFly, problems);
                }
                super.visitReferenceElement(reference);
            }
        });
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    protected void checkMethodReference(PsiJavaCodeReferenceElement reference, PsiMethod method, GwtFacet facet, List<GwtModule> gwtModules, GwtModulesManager gwtModulesManager, InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> problems) {
    }

    protected abstract void checkClassReference(@NotNull PsiJavaCodeReferenceElement var1, @NotNull PsiClass var2, @NotNull String var3, @NotNull VirtualFile var4, @NotNull GwtFacet var5, List<GwtModule> var6, @NotNull GwtModulesManager var7, @NotNull InspectionManager var8, boolean var9, List<ProblemDescriptor> var10);
}

