/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.references;

import com.intellij.gwt.codeInsight.GwtReferenceUtil;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGwtReference<T extends PsiElement>
extends PsiReferenceBase<T> {
    protected final GwtModulesManager myGwtModulesManager;

    protected BaseGwtReference(T element, boolean soft) {
        super(element, soft);
        this.myGwtModulesManager = GwtModulesManager.getInstance(this.myElement.getProject());
    }

    protected BaseGwtReference(T element) {
        this(element, false);
    }

    @NotNull
    protected XmlFile[] getHtmlFilesForModule() {
        GwtModule module = this.findGwtModule();
        if (module == null) {
            if (XmlFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/references/BaseGwtReference", "getHtmlFilesForModule"));
            }
            return XmlFile.EMPTY_ARRAY;
        }
        XmlFile[] xmlFileArray = this.myGwtModulesManager.findHtmlFilesByModule(module);
        if (xmlFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/references/BaseGwtReference", "getHtmlFilesForModule"));
        }
        return xmlFileArray;
    }

    @Nullable
    protected static GwtVersion getGwtVersion(@NotNull GwtModule gwtModule) {
        if (gwtModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtModule", "com/intellij/gwt/references/BaseGwtReference", "getGwtVersion"));
        }
        GwtFacet facet = GwtFacet.getInstance(gwtModule);
        return facet != null ? facet.getSdkVersion() : null;
    }

    @Nullable
    public GwtModule findGwtModule() {
        return GwtReferenceUtil.findGwtModule(this.myElement, this.myGwtModulesManager);
    }
}

