/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GwtModuleReference<T extends PsiElement>
extends PsiPolyVariantReferenceBase<T> {
    private final GwtModulesManager myGwtModulesManager;
    private final boolean myOutputName;

    public GwtModuleReference(T element, boolean outputName) {
        super(element);
        this.myOutputName = outputName;
        this.myGwtModulesManager = GwtModulesManager.getInstance(element.getProject());
    }

    @Nullable
    protected Module getModule() {
        return ModuleUtil.findModuleForPsiElement((PsiElement)this.myElement);
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>();
        for (GwtModule module : this.myGwtModulesManager.getAllGwtModules()) {
            String fullName = this.myOutputName ? module.getOutputName() : module.getQualifiedName();
            LookupElementBuilder builder = LookupElementBuilder.create((String)fullName);
            String shortName = StringUtil.getShortName((String)fullName);
            if (!shortName.equals(fullName)) {
                builder = builder.withLookupString(shortName);
            }
            variants.add(builder);
        }
        Object[] objectArray = variants.toArray(new LookupElementBuilder[variants.size()]);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/references/GwtModuleReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ArrayList<PsiElementResolveResult> results = new ArrayList<PsiElementResolveResult>();
        String moduleName = this.getStringValue();
        if (moduleName != null) {
            Module module = this.getModule();
            GlobalSearchScope scope = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)this.myElement.getProject());
            Collection<GwtModule> gwtModules = this.myOutputName ? this.myGwtModulesManager.findGwtModulesByOutputName(moduleName, scope) : this.myGwtModulesManager.findGwtModulesByQualifiedName(moduleName, scope);
            for (GwtModule gwtModule : gwtModules) {
                results.add(new PsiElementResolveResult((PsiElement)gwtModule.getModuleXmlFile()));
            }
        }
        ResolveResult[] resolveResultArray = results.toArray(new ResolveResult[results.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/references/GwtModuleReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @Nullable
    protected abstract String getStringValue();
}

