/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseMessages;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeForeignKey;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DeleteQueryGenerator;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseTableEditor;
import com.intellij.database.view.models.builder.ForeignKeyModelBuilder;
import com.intellij.database.view.models.builder.IndexModelBuilder;
import com.intellij.database.view.models.builder.KeyModelBuilder;
import com.intellij.database.view.models.builder.TableModelBuilder;
import com.intellij.database.view.ui.DbBatchIndicesDialog;
import com.intellij.database.view.ui.DbObjectDialog;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.database.view.ui.DeleteDialog;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlActions {
    private static void deleteDataSources(@NotNull Project project, @NotNull Set<DbDataSource> dataSources) {
        String message;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/DdlActions", "deleteDataSources"));
        }
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/actions/DdlActions", "deleteDataSources"));
        }
        if (dataSources.size() == 1) {
            DbDataSource element = dataSources.iterator().next();
            message = DatabaseMessages.message((String)"confirmation.text.remove.data.source", (Object[])new Object[]{element.getName()});
        } else {
            StringBuilder sb = new StringBuilder("The following data sources will be removed:\n");
            int i2 = 0;
            for (DbDataSource o : dataSources) {
                if (i2++ > 0) {
                    sb.append(",").append(i2 % 3 == 1 ? "\n" : " ");
                }
                sb.append(o.getName());
            }
            message = sb.toString();
        }
        int ret = Messages.showOkCancelDialog((Project)project, (String)message, (String)"Confirmation", (Icon)Messages.getWarningIcon());
        if (ret != 0) {
            return;
        }
        DdlActions.closeAllFilesBeforeDataSourceRemoval(project, dataSources);
        for (DbDataSource o : dataSources) {
            o.getDbManager().removeDataSource(o);
        }
    }

    public static void closeAllFilesBeforeDataSourceRemoval(@NotNull Project project, @NotNull Set<DbDataSource> elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/DdlActions", "closeAllFilesBeforeDataSourceRemoval"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/actions/DdlActions", "closeAllFilesBeforeDataSourceRemoval"));
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (VirtualFile virtualFile : fileEditorManager.getOpenFiles()) {
            DbDataSource dataSource = DbImplUtil.findDataSource(project, virtualFile);
            if (!elements.contains(dataSource)) continue;
            fileEditorManager.closeFile(virtualFile);
        }
    }

    @NotNull
    static Pair<DbTable, Set<DbColumn>> getTableAndColumns(AnActionEvent e) {
        DbTable tableElement;
        Set<Object> columns = DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class);
        Set tables = ContainerUtil.map2Set(columns, (Function)((NullableFunction)element -> element.getDbParent()));
        DbTable dbTable = tableElement = tables.size() == 1 ? (DbTable)tables.iterator().next() : null;
        if (tableElement == null) {
            Set<DbElement> selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
            DbElement element2 = selection.size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            tableElement = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element2, DbTable.class, (boolean)false);
            columns = Collections.emptySet();
        }
        Pair pair = Pair.create((Object)tableElement, columns);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DdlActions", "getTableAndColumns"));
        }
        return pair;
    }

    public static class DropForeignKeyAction
    extends DumbAwareAction {
        public DropForeignKeyAction() {
            super("Drop Foreign Key", "Drop foreign key from selected column", DatabaseIcons.BlueKey);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$DropForeignKeyAction", "update"));
            }
            Set<DbColumn> selection = DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class);
            DbColumn column = selection.size() == 1 ? (DbColumn)ContainerUtil.getFirstItem(selection) : null;
            boolean enabled = column != null && DbImplUtil.getDatabaseDialect((DbElement)column).supportsDropForeignKey() && DbImplUtil.canConnectToAndModify((DbElement)column) && DasUtil.isForeign((DasColumn)column);
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$DropForeignKeyAction", "actionPerformed"));
            }
            DbColumn column = (DbColumn)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class));
            if (column == null) {
                return;
            }
            DeleteDialog dialog = new DeleteDialog(column.getProject(), column.getDataSource(), DropForeignKeyAction.getStatement(column));
            if (dialog.showAndGet()) {
                DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(column.getDataSource(), DasUtil.getNamespace((DasObject)column)).setStatement(dialog.getStatement());
                handler.getContext().include(column.getDbParent());
                handler.runStatements(false);
            }
        }

        private static String getStatement(@NotNull DbColumn column) {
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/actions/DdlActions$DropForeignKeyAction", "getStatement"));
            }
            DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)column, false);
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)column);
            DbTable table = column.getDbParent();
            if (table != null) {
                for (DasForeignKey key : DasUtil.getForeignKeys((DasTable)table)) {
                    if (!DasUtil.containsName((String)column.getName(), (MultiRef)key.getColumnsRef())) continue;
                    dialect.sqlDropForeignKey(builder, (DasTable)table, key, key.getName()).newStatement();
                }
            }
            return DatabaseDialogsHelper.concatQueries(builder);
        }
    }

    public static class DropPrimaryKeyAction
    extends DumbAwareAction {
        public DropPrimaryKeyAction() {
            super("Drop Primary Key", "Drop primary key from selected table", DatabaseIcons.GoldKey);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$DropPrimaryKeyAction", "update"));
            }
            Set<DbElement> selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
            DbElement element = selection.size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            DbTable tableElement = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element, DbTable.class, (boolean)false);
            boolean enabled = tableElement != null && DbImplUtil.getDatabaseDialect((DbElement)tableElement).supportsDropPrimaryKey() && DbImplUtil.canConnectToAndModify((DbElement)tableElement) && DasUtil.getPrimaryKey((DasTable)tableElement) != null;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$DropPrimaryKeyAction", "actionPerformed"));
            }
            DbElement element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class));
            DbTable table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element, DbTable.class, (boolean)false);
            if (table == null) {
                return;
            }
            DbTableKey pk = (DbTableKey)DasUtil.getPrimaryKey((DasTable)table);
            if (pk == null) {
                return;
            }
            DeleteDialog dialog = new DeleteDialog(pk.getProject(), element.getDataSource(), DropPrimaryKeyAction.generateStatement(pk));
            if (dialog.showAndGet()) {
                DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(table.getDataSource(), DasUtil.getNamespace((DasObject)element)).setStatement(dialog.getStatement());
                handler.getContext().include(table);
                handler.getContext().setElementToFocus(element);
                handler.runStatements(false);
            }
        }

        private static String generateStatement(@NotNull DbTableKey pk) {
            if (pk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/actions/DdlActions$DropPrimaryKeyAction", "generateStatement"));
            }
            DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder((DbElement)pk, false);
            DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect((DbElement)pk);
            dialect.sqlDropPrimaryKey(builder, (DasTableKey)pk);
            return DatabaseDialogsHelper.concatQueries(builder);
        }
    }

    public static class AddForeignKeyAction
    extends DumbAwareAction {
        public AddForeignKeyAction() {
            super("_Foreign Key", "Add new foreign key to selected table", DatabaseIcons.BlueKey);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddForeignKeyAction", "update"));
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean enabled = pair.first != null && DbImplUtil.canConnectToAndModify((DbElement)pair.first) && DbRefactoringDialogHelper.canAddForeignKey(new DatabaseEditorContext(((DbTable)pair.first).getDataSource(), null), (DasTable)pair.first);
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddForeignKeyAction", "actionPerformed"));
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            DbTable table = (DbTable)pair.first;
            if (table == null) {
                return;
            }
            DbTableDialog dialog = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext(table.getDataSource(), null), (DasTable)table);
            DbRefactoringDialogHelper.bootstrap(dialog, (Computable<DeObject>)((Computable)() -> {
                Ref newFk = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((TableModelBuilder.TableForeignKeyModelBuilder)((ForeignKeyModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withForeignKey(""))).addRefRefs((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog, (Iterable)pair.second))).addAndGet((Ref<DeForeignKey>)newFk)).leave()).commit();
                return (DeObject)newFk.get();
            })).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }
    }

    public static class AddPrimaryKeyAction
    extends DumbAwareAction {
        public AddPrimaryKeyAction() {
            super("_Primary Key", "Add new primary key to selected table", DatabaseIcons.GoldKey);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddPrimaryKeyAction", "update"));
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean enabled = pair.first != null && DbImplUtil.canConnectToAndModify((DbElement)pair.first) && DbImplUtil.getDatabaseDialect((DbElement)pair.first).supportsAddPrimaryKey() && DasUtil.getPrimaryKey((DasTable)((DasTable)pair.first)) == null && ((DbTable)pair.first).getKind() == ObjectKind.TABLE && !((Set)pair.second).isEmpty();
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddPrimaryKeyAction", "actionPerformed"));
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            if (pair.first == null) {
                return;
            }
            DbTable table = (DbTable)pair.first;
            Set columns = (Set)pair.second;
            DbTableDialog dialog = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext(table.getDataSource(), null), (DasTable)table);
            DbRefactoringDialogHelper.bootstrap(dialog, (Computable<DeObject>)((Computable)() -> {
                Ref newKey = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((TableModelBuilder.TableKeyModelBuilder)((KeyModelBuilder)((Object)((TableModelBuilder.TableKeyModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withKey("")).setPrimary(true, false))).addColumns((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog, columns), DasIndex.Sorting.NONE)).addAndGet((Ref<DeTableKey>)newKey)).leave()).commit();
                return (DeObject)newKey.get();
            })).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }
    }

    public static class BatchAddIndicesAction
    extends DumbAwareAction {
        public BatchAddIndicesAction() {
            super("Indice_s Per Column", "Add separate indices for selected columns", DatabaseIcons.Index);
        }

        @NotNull
        private static List<DbColumn> getColumns(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$BatchAddIndicesAction", "getColumns"));
            }
            Set<DbColumn> columns = DatabaseView.getSelectedElements(e.getDataContext(), DbColumn.class);
            DbDataSource dataSource = null;
            for (DbColumn column : columns) {
                if (dataSource == null) {
                    dataSource = column.getDataSource();
                }
                if (dataSource == column.getDataSource()) continue;
                List<DbColumn> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DdlActions$BatchAddIndicesAction", "getColumns"));
                }
                return list;
            }
            ArrayList arrayList = ContainerUtil.newArrayList(columns);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DdlActions$BatchAddIndicesAction", "getColumns"));
            }
            return arrayList;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$BatchAddIndicesAction", "update"));
            }
            List<DbColumn> columns = BatchAddIndicesAction.getColumns(e);
            boolean enabled = columns.size() > 1 && DbImplUtil.canConnectToAndModify((DbElement)columns.get(0)) && DbBatchIndicesDialog.canAddAnything(new DatabaseEditorContext(columns.get(0).getDataSource(), null), columns);
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$BatchAddIndicesAction", "actionPerformed"));
            }
            List<DbColumn> columns = BatchAddIndicesAction.getColumns(e);
            if (columns.size() < 2) {
                return;
            }
            DbBatchIndicesDialog.newBatchAddIndicesDialog(new DatabaseEditorContext(columns.get(0).getDataSource(), null), columns).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }
    }

    public static class AddIndexAction
    extends DumbAwareAction {
        public AddIndexAction() {
            super("_Index", "Add new index for selected columns", DatabaseIcons.Index);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddIndexAction", "update"));
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            boolean enabled = pair.first != null && DbImplUtil.canConnectToAndModify((DbElement)pair.first) && DbRefactoringDialogHelper.canAddIndex(new DatabaseEditorContext(((DbTable)pair.first).getDataSource(), null), (DasTable)pair.first);
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddIndexAction", "actionPerformed"));
            }
            Pair<DbTable, Set<DbColumn>> pair = DdlActions.getTableAndColumns(e);
            Set columns = (Set)pair.second;
            DbTable table = (DbTable)pair.first;
            if (table == null || columns == null) {
                return;
            }
            DbTableDialog dialog = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext(table.getDataSource(), null), (DasTable)table);
            DbRefactoringDialogHelper.bootstrap(dialog, (Computable<DeObject>)((Computable)() -> {
                Ref newIndex = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((TableModelBuilder.TableIndexModelBuilder)((IndexModelBuilder)((Object)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withIndex(""))).addColumns((Iterable<DeColumn>)DbRefactoringDialogHelper.export(dialog, columns), DasIndex.Sorting.NONE)).addAndGet((Ref<DeIndex>)newIndex)).leave()).commit();
                return (DeObject)newIndex.get();
            })).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }
    }

    public static class AddColumnAction
    extends DumbAwareAction {
        public AddColumnAction() {
            super("_Column", "Add new column to selected table", DatabaseIcons.Col);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddColumnAction", "update"));
            }
            Set<DbElement> selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
            DbElement element = selection.size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            DbTable table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element, DbTable.class, (boolean)false);
            boolean enabled = table != null && DbImplUtil.getDatabaseDialect((DbElement)table).supportsAddColumn() && DbImplUtil.canConnectToAndModify((DbElement)table) && table.getKind() == ObjectKind.TABLE;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddColumnAction", "actionPerformed"));
            }
            DbElement element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class));
            DbTable table = (DbTable)PsiTreeUtil.getParentOfType((PsiElement)element, DbTable.class, (boolean)false);
            if (table == null) {
                return;
            }
            AddColumnAction.perform(table, "new_column");
        }

        public static void perform(@NotNull DbTable table, @NotNull String colName) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/actions/DdlActions$AddColumnAction", "perform"));
            }
            if (colName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colName", "com/intellij/database/actions/DdlActions$AddColumnAction", "perform"));
            }
            DbTableDialog dialog = DbRefactoringDialogHelper.newModifyTableDialog(new DatabaseEditorContext(table.getDataSource(), null), (DasTable)table);
            DbRefactoringDialogHelper.bootstrap(dialog, (Computable<DeObject>)((Computable)() -> {
                if (colName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colName", "com/intellij/database/actions/DdlActions$AddColumnAction", "lambda$perform$0"));
                }
                Ref newCol = Ref.create();
                ((TableModelBuilder)((TableModelBuilder.TableColumnModelBuilder)((TableModelBuilder.TableColumnModelBuilder)TableModelBuilder.modify(((DatabaseTableEditor)dialog.getEditor()).getTableModel()).withColumn(colName)).addAndGet((Ref<DeColumn>)newCol)).leave()).commit();
                return (DeObject)newCol.get();
            })).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }
    }

    public static class AddSchemaAction
    extends DumbAwareAction {
        public AddSchemaAction() {
            super("_Schema", "Add new schema to selected database", DatabaseIcons.Schema);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddSchemaAction", "update"));
            }
            DbElement parent = AddSchemaAction.getSchemaParent(e);
            DbDataSource dataSource = parent == null ? null : parent.getDataSource();
            boolean enabled = dataSource != null && DbImplUtil.getDatabaseDialect((DbElement)dataSource).supportsCreateSchema() && DbImplUtil.canConnectToAndModify((DbElement)dataSource);
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        @Nullable
        private static DbElement getSchemaParent(@NotNull AnActionEvent e) {
            DbDataSource dataSource;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddSchemaAction", "getSchemaParent"));
            }
            Set<DbElement> selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
            DbElement element = selection.size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            DbNamespaceImpl parent = DatabaseView.getLowestSchema(element);
            parent = (DbElement)DasUtil.dasParents((DasObject)parent).filter(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).filter(DbElement.class).first();
            DbDataSource dbDataSource = dataSource = element == null ? null : element.getDataSource();
            if (parent == null) {
                parent = dataSource;
            }
            return parent;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddSchemaAction", "actionPerformed"));
            }
            DbElement parent = AddSchemaAction.getSchemaParent(e);
            if (parent == null) {
                return;
            }
            AddSchemaAction.perform(parent, "new_schema");
        }

        public static void perform(@NotNull DbElement parent, @NotNull String schemaName) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/actions/DdlActions$AddSchemaAction", "perform"));
            }
            if (schemaName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemaName", "com/intellij/database/actions/DdlActions$AddSchemaAction", "perform"));
            }
            DbObjectDialog dialog = DbRefactoringDialogHelper.newAddObjectDialog(new DatabaseEditorContext(parent.getDataSource(), null), (DasNamespace)ObjectUtils.tryCast((Object)parent, DasNamespace.class), schemaName, ObjectKind.SCHEMA);
            dialog.finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }
    }

    public static class AddDatabaseAction
    extends DumbAwareAction {
        public AddDatabaseAction() {
            super("_Database", "Add new database to selected data source", DatabaseIcons.Database);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddDatabaseAction", "update"));
            }
            Set<DbElement> selection = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
            DbElement element = selection.size() == 1 ? (DbElement)ContainerUtil.getFirstItem(selection) : null;
            DbDataSource dataSource = element == null ? null : element.getDataSource();
            boolean enabled = dataSource != null && DbImplUtil.getDatabaseDialect((DbElement)dataSource).supportsCreateDatabase() && DbImplUtil.canConnectToAndModify((DbElement)dataSource);
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbDataSource dataSource;
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddDatabaseAction", "actionPerformed"));
            }
            DbElement element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class));
            DbDataSource dbDataSource = dataSource = element == null ? null : element.getDataSource();
            if (dataSource == null) {
                return;
            }
            AddDatabaseAction.perform(dataSource, "new_database");
        }

        public static void perform(@NotNull DbDataSource dataSource, @NotNull String databaseName) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/actions/DdlActions$AddDatabaseAction", "perform"));
            }
            if (databaseName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseName", "com/intellij/database/actions/DdlActions$AddDatabaseAction", "perform"));
            }
            DbObjectDialog dialog = DbRefactoringDialogHelper.newAddObjectDialog(new DatabaseEditorContext(dataSource, null), null, databaseName, ObjectKind.DATABASE);
            dialog.finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }
    }

    public static class BatchModifyIndicesAction
    extends DumbAwareAction {
        public BatchModifyIndicesAction() {
            super("Modify Indices", "Batch Modify Indices", null);
        }

        @NotNull
        private static List<DbIndex> getIndicesToModify(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction", "getIndicesToModify"));
            }
            Set<DbIndex> elements = DatabaseView.getSelectedElements(e.getDataContext(), DbIndex.class);
            DbDataSource dataSource = null;
            for (DbIndex element : elements) {
                if (dataSource == null) {
                    dataSource = element.getDataSource();
                }
                if (dataSource == element) continue;
                List<DbIndex> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction", "getIndicesToModify"));
                }
                return list;
            }
            ArrayList arrayList = ContainerUtil.newArrayList(elements);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction", "getIndicesToModify"));
            }
            return arrayList;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction", "update"));
            }
            List<DbIndex> indices = BatchModifyIndicesAction.getIndicesToModify(e);
            boolean enabled = indices.size() > 1 && DbImplUtil.canConnectToAndModify((DbElement)indices.get(0)) && DbBatchIndicesDialog.canModifyAnything(new DatabaseEditorContext(indices.get(0).getDataSource(), null), indices);
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction", "actionPerformed"));
            }
            List<DbIndex> indices = BatchModifyIndicesAction.getIndicesToModify(e);
            if (indices.size() < 2) {
                return;
            }
            BatchModifyIndicesAction.showModifyIndicesDialogAndRun(indices);
        }

        public static void showModifyIndicesDialogAndRun(@NotNull List<DbIndex> indices) {
            if (indices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indices", "com/intellij/database/actions/DdlActions$BatchModifyIndicesAction", "showModifyIndicesDialogAndRun"));
            }
            DbBatchIndicesDialog.newBatchModifyIndicesDialog(new DatabaseEditorContext(indices.get(0).getDataSource(), null), indices).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }
    }

    public static class AddTableAction
    extends DumbAwareAction {
        public AddTableAction() {
            super("_Table", "Add new table to selected schema", DatabaseIcons.Table);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddTableAction", "update"));
            }
            DbElement element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class));
            DbNamespaceImpl parent = DatabaseView.getLowestSchema(element);
            boolean enabled = parent != null && DbImplUtil.canConnectToAndModify(parent);
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DdlActions$AddTableAction", "actionPerformed"));
            }
            DbElement element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class));
            if (element == null) {
                return;
            }
            DbDataSource dataSource = element.getDataSource();
            DbNamespaceImpl schema = DatabaseView.getLowestSchema(element);
            AddTableAction.showAddTableDialogAndRun(dataSource, schema, "table_name", ContainerUtil.emptyList());
        }

        public static void showAddTableDialogAndRun(@NotNull DbDataSource dataSource, @Nullable DasNamespace schema, @NotNull String defaultName, @NotNull Collection<String> columnNames) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/actions/DdlActions$AddTableAction", "showAddTableDialogAndRun"));
            }
            if (defaultName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultName", "com/intellij/database/actions/DdlActions$AddTableAction", "showAddTableDialogAndRun"));
            }
            if (columnNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/database/actions/DdlActions$AddTableAction", "showAddTableDialogAndRun"));
            }
            DbRefactoringDialogHelper.newAddTableDialog(new DatabaseEditorContext(dataSource, null), schema, defaultName, columnNames).finishAndShow();
        }

        public boolean startInTransaction() {
            return true;
        }
    }

    public static class DeleteProvider2
    implements DeleteProvider,
    TitledHandler {
        public String getActionTitle() {
            return "Drop";
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            DbDataSource dataSource;
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/DdlActions$DeleteProvider2", "canDeleteElement"));
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return false;
            }
            JBIterable selection = JBIterable.from(DatabaseView.getSelectedElements(dataContext, DbElement.class));
            if (selection.isEmpty() || !selection.filter(DbDataSource.class).isEmpty()) {
                return false;
            }
            for (DbElement e : selection) {
                if (e.isWritable()) continue;
                return false;
            }
            DbElement any = (DbElement)selection.iterator().next();
            DbDataSource dbDataSource = dataSource = any == null ? null : any.getDataSource();
            if (dataSource == null || !DbImplUtil.canConnectToAndModify((DbElement)dataSource)) {
                return false;
            }
            for (DbElement e : selection) {
                if (dataSource.equals(e.getDataSource())) continue;
                return false;
            }
            return DeleteQueryGenerator.canDeleteAnything(selection.toList());
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/DdlActions$DeleteProvider2", "deleteElement"));
            }
            final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return;
            }
            final JBIterable selection = JBIterable.from(DatabaseView.getSelectedElements(dataContext, DbElement.class));
            DbElement first = (DbElement)selection.first();
            if (first == null) {
                return;
            }
            final DbDataSource dataSource = first.getDataSource();
            final ArrayList messages = ContainerUtil.newArrayList();
            final Ref builderRef = Ref.create();
            final ArrayList toRemove = ContainerUtil.newArrayList();
            new Task.Backgroundable(project, "Generating Query"){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/actions/DdlActions$DeleteProvider2$1", "run"));
                    }
                    DeleteQueryGenerator generator = new DeleteQueryGenerator(dataSource, selection.filter(e -> !DataImporter.isBusy(e)).toList());
                    builderRef.set((Object)generator.generateQueries(messages));
                    if (DatabaseSettings.getSettings().trackNamespaces) {
                        generator.fillNamespacesToRemove(toRemove);
                    }
                }

                public void onSuccess() {
                    super.onSuccess();
                    String query = DatabaseDialogsHelper.concatQueries((DdlBuilder)builderRef.get());
                    DeleteProvider2.showDialogAndRun(project, query, dataSource, messages, (JBIterable<DbElement>)selection, toRemove);
                }
            }.queue();
        }

        private static void showDialogAndRun(@NotNull Project project, @NotNull String query, @NotNull DbDataSource dataSource, @NotNull List<String> messages, @NotNull JBIterable<DbElement> selection, @NotNull List<Pair<ObjectName, ObjectName>> toRemove) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/DdlActions$DeleteProvider2", "showDialogAndRun"));
            }
            if (query == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/actions/DdlActions$DeleteProvider2", "showDialogAndRun"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/actions/DdlActions$DeleteProvider2", "showDialogAndRun"));
            }
            if (messages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/intellij/database/actions/DdlActions$DeleteProvider2", "showDialogAndRun"));
            }
            if (selection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/database/actions/DdlActions$DeleteProvider2", "showDialogAndRun"));
            }
            if (toRemove == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRemove", "com/intellij/database/actions/DdlActions$DeleteProvider2", "showDialogAndRun"));
            }
            if (query.isEmpty()) {
                return;
            }
            DeleteDialog dialog = new DeleteDialog(project, dataSource, query, messages);
            if (dialog.showAndGet()) {
                DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(dataSource, DasUtil.getNamespace((DasObject)((DasObject)selection.first()))).setStatement(dialog.getStatement());
                LoaderContext context = handler.getContext();
                for (DbElement element : selection) {
                    if (element instanceof DbTableChild) {
                        DbTable table = ((DbTableChild)element).getTable();
                        context.include(table);
                        for (DasForeignKey fk : DasUtil.getForeignKeys((DasTable)table)) {
                            context.include(fk.getRefTable());
                        }
                    }
                    context.include(element);
                }
                for (Pair<ObjectName, ObjectName> pair : toRemove) {
                    context.getScopeUpdater().toRemove((ObjectName)pair.first, (ObjectName)pair.second);
                }
                handler.runStatements(false);
            }
        }
    }

    public static class DeleteProvider1
    implements DeleteProvider,
    TitledHandler {
        public String getActionTitle() {
            return "Remove";
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/DdlActions$DeleteProvider1", "canDeleteElement"));
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return false;
            }
            JBIterable selection = JBIterable.from(DatabaseView.getSelectedElements(dataContext, DbElement.class));
            if (selection.filter(DbDataSource.class).size() != selection.size()) {
                return false;
            }
            return !selection.isEmpty();
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/database/actions/DdlActions$DeleteProvider1", "deleteElement"));
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return;
            }
            JBIterable selection = JBIterable.from(DatabaseView.getSelectedElements(dataContext, DbDataSource.class));
            DdlActions.deleteDataSources(project, selection.toSet());
        }
    }
}

