/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenConsoleAction
extends AnAction
implements DumbAware {
    public OpenConsoleAction() {
        super(AllIcons.RunConfigurations.Ql_console);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenConsoleAction", "update"));
        }
        OpenConsoleAction.doUpdate(e, ActionPlaces.isToolbarPlace((String)e.getPlace()));
    }

    public static void doUpdate(@NotNull AnActionEvent e, boolean forceVisible) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenConsoleAction", "doUpdate"));
        }
        DbElement element = OpenConsoleAction.getElement(e);
        boolean visible = forceVisible || element != null && element.getDataSource().getDelegate() instanceof LocalDataSource;
        e.getPresentation().setEnabledAndVisible(visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenConsoleAction", "actionPerformed"));
        }
        DatabaseEditorHelper.openConsoleFile(OpenConsoleAction.getElement(e), false);
    }

    @Nullable
    private static DbElement getElement(@NotNull AnActionEvent e) {
        RootType rootType;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenConsoleAction", "getElement"));
        }
        Project project = OpenConsoleAction.getEventProject((AnActionEvent)e);
        if (project == null) {
            return null;
        }
        Object[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(e.getDataContext());
        if (elements != null && elements.length > 1) {
            return null;
        }
        PsiElement element = (PsiElement)ArrayUtil.getFirstElement((Object[])elements);
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
        if (element == null) {
            element = DbImplUtil.findElement(project, virtualFile);
        } else if (virtualFile != null && (rootType = ScratchFileService.getInstance().getRootType(virtualFile)) instanceof DbConsoleRootType) {
            element = DbConsoleRootType.getDataSource(project, virtualFile);
        }
        return element instanceof DbElement ? (DbElement)element : null;
    }

    public static class CreateNew
    extends OpenConsoleAction {
        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenConsoleAction$CreateNew", "update"));
            }
            CreateNew.doUpdate(e, false);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenConsoleAction$CreateNew", "actionPerformed"));
            }
            DatabaseEditorHelper.openConsoleFile(OpenConsoleAction.getElement(e), true);
        }
    }
}

