/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DataBus;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.actions.AssignColorAction;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanView;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.actions.ChooseConsoleAction;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.IntrospectionScopeUpdater;
import com.intellij.database.vendors.oracle.OracleCompilationErrorsObtainer;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ToggleToolbarAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRenameToClause;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class JdbcConsole
extends AbstractQueryLanguageConsole<LocalDataSource> {
    public static final String CONSOLE_TOOLWINDOW_ID = "Database Console";
    private static final Key<PlanView> PLAN_VIEW_KEY = Key.create((String)"PlanView");
    private static final Key<Boolean> SCHEDULE_REFRESH = Key.create((String)"SCHEDULE_REFRESH");
    private static final Key<IntrospectionScopeUpdater> SCOPE_UPDATER = Key.create((String)"SCOPE_UPDATER");
    private static final String TOGGLE_CONSOLE_TOOLBAR_PROP = "Database.Console";
    private AnAction myRunAction;
    private AnAction myCloseAction;
    private AnAction myTerminateAction;
    private AnAction myToggleAction;
    private final AtomicReference<SearchPath> mySearchPath;
    private final AtomicReference<Boolean> myScheduleRefresh;
    private Content myPlanContent;
    private final ScriptModel<?> myScriptModel;
    private static final Key<List<JdbcConsole>> DATABASE_CONSOLE_LIST = Key.create((String)"DATABASE_CONSOLE_LIST");

    @NotNull
    public static Builder newConsole(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/JdbcConsole", "newConsole"));
        }
        Builder builder = new Builder(project);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcConsole", "newConsole"));
        }
        return builder;
    }

    @NotNull
    public static ToggleToolbarAction createToggleConsoleToolbarAction(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/JdbcConsole", "createToggleConsoleToolbarAction"));
        }
        ToggleToolbarAction action = ToggleToolbarAction.createAction((String)TOGGLE_CONSOLE_TOOLBAR_PROP, (PropertiesComponent)PropertiesComponent.getInstance((Project)project), () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/JdbcConsole", "lambda$createToggleConsoleToolbarAction$2"));
            }
            return JBIterable.of((Object[])FileEditorManager.getInstance((Project)project).getAllEditors()).filter(o -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/JdbcConsole", "lambda$null$0"));
                }
                Editor editor = o instanceof TextEditor ? ((TextEditor)o).getEditor() : null;
                EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
                return editorEx != null && editorEx.getPermanentHeaderComponent() != null && JdbcConsole.findConsole(project, editorEx.getVirtualFile()) != null;
            }).map(o -> o.getComponent());
        });
        action.getTemplatePresentation().setText("Show Toolbar in Console");
        ToggleToolbarAction toggleToolbarAction = action;
        if (toggleToolbarAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcConsole", "createToggleConsoleToolbarAction"));
        }
        return toggleToolbarAction;
    }

    private JdbcConsole(@NotNull LanguageConsoleView languageConsole, @NotNull DataBus.Consuming messageBus, @NotNull LocalDataSource dataSource, @Nullable String query) {
        if (languageConsole == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageConsole", "com/intellij/database/console/JdbcConsole", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/console/JdbcConsole", "<init>"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/JdbcConsole", "<init>"));
        }
        super(languageConsole, messageBus, dataSource);
        this.mySearchPath = new AtomicReference();
        this.myScheduleRefresh = new AtomicReference<Boolean>(false);
        this.setCurrentTx(DataRequest.getInitialTxMarker(DbImplUtil.getLocalDataSource((DatabaseSystem)dataSource).isAutoCommit()));
        this.getLanguageConsole().setPrompt("sql> ");
        ConsoleHistoryController controller = new ConsoleHistoryController(DbConsoleRootType.getInstance(), dataSource.getUniqueId(), this.getLanguageConsole()){

            protected int insertTextMultiline(String text, Editor editor, Document document) {
                TextRange range = ScriptModelUtil.getSelectedStatementsRange(JdbcConsole.this);
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)text);
                editor.getSelectionModel().setSelection(range.getStartOffset(), range.getStartOffset() + text.length());
                return range.getStartOffset();
            }
        };
        JdbcDriverManager.getDriverManager(this.getProject()).addModificationTrackerListener(new ModificationTrackerListener<JdbcDriverManager>(){

            public void modificationCountChanged(JdbcDriverManager source) {
                FileEditorManagerEx.getInstanceEx((Project)JdbcConsole.this.getProject()).updateFilePresentation(JdbcConsole.this.getLanguageConsole().getVirtualFile());
            }
        }, this);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.console");
        JdbcConsole.getActiveConsoles(this.getProject()).add(this);
        controller.setMultiline(true).install();
        if (StringUtil.isNotEmpty((String)query) && StringUtil.isEmpty((String)this.getLanguageConsole().getEditorDocument().getText())) {
            this.getLanguageConsole().setInputText(query);
        }
        this.myScriptModel = SqlPsiFacade.getInstance((Project)this.getProject()).createScriptModel(this.getLanguageConsole().getFile());
        Disposer.register((Disposable)this, this.myScriptModel);
        this.initActions();
    }

    @Override
    public void updateConsoleOnRequestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/JdbcConsole", "updateConsoleOnRequestStarted"));
        }
        if (this.mySearchPath.get() != null) {
            return;
        }
        this.updateSearchPath(((JdbcEngine)context.producer).getSearchPath());
    }

    @Override
    public void updateConsoleOnRequestFinished(@NotNull DataRequest.Context context) {
        IntrospectionScopeUpdater scopeUpdater;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/JdbcConsole", "updateConsoleOnRequestFinished"));
        }
        ConsoleDataRequest consoleRequest = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class);
        boolean requestSearchPath = this.mySearchPath.get() == null || consoleRequest == null || consoleRequest.isLastInChain();
        boolean requestAutoSync = consoleRequest != null && consoleRequest.isLastInChain() && Boolean.TRUE.equals(consoleRequest.getSharedDataHolder().getUserData(SCHEDULE_REFRESH));
        boolean inTransaction = context.txMarker.getOwner() != null;
        IntrospectionScopeUpdater introspectionScopeUpdater = scopeUpdater = consoleRequest == null ? null : (IntrospectionScopeUpdater)consoleRequest.getSharedDataHolder().getUserData(SCOPE_UPDATER);
        if (this.isValid() && requestSearchPath && !inTransaction) {
            this.updateSearchPath(((JdbcEngine)context.producer).requestSearchPath());
        }
        if (this.isTargetValid() && requestAutoSync) {
            DataSourceUiUtil.performAutoSyncTask(this.getProject(), (LocalDataSource)((Object)this.getTarget()), scopeUpdater);
            if (inTransaction) {
                this.myScheduleRefresh.set(true);
            }
        }
    }

    @Override
    public void updateConsoleOnTxCompleted(@NotNull DataRequest.Context context, boolean commit) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/JdbcConsole", "updateConsoleOnTxCompleted"));
        }
        if (this.isTargetValid() && commit && this.myScheduleRefresh.getAndSet(false).booleanValue()) {
            DataSourceUiUtil.performAutoSyncTask(this.getProject(), (LocalDataSource)((Object)this.getTarget()));
        }
    }

    public void setSearchPath(@Nullable SearchPath schemaPaths) {
        this.updateSearchPath(schemaPaths);
    }

    private void updateSearchPath(@Nullable SearchPath schemaPaths) {
        if (Comparing.equal((Object)schemaPaths, (Object)this.mySearchPath.get())) {
            return;
        }
        this.mySearchPath.set(schemaPaths);
        DbUIUtil.invokeLaterIfNeeded(() -> this.myDataConsumer.setSearchPath(schemaPaths));
        TransactionGuard.submitTransaction((Disposable)this.getProject(), () -> {
            VirtualFile virtualFile = this.getLanguageConsole().getVirtualFile();
            DatabaseEditorHelper.initSearchPath(this.getLanguageConsole().getFile());
            ChooseSchemaAction.setSelectedSearchPath(virtualFile, this.mySearchPath.get());
            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{virtualFile});
            AssignColorAction.updateFileEditors(FileEditorManagerEx.getInstanceEx((Project)this.getProject()), virtualFile);
        });
    }

    @Override
    public Promise<Void> showConsole(boolean activateToolWindow, boolean requestFocus) {
        if (!activateToolWindow) {
            this.ensureContentInitialized(false);
            return Promises.resolvedPromise();
        }
        return super.showConsole(true, requestFocus);
    }

    public boolean isToolWindowContentPresent() {
        return JdbcConsole.getActiveConsoles(this.getProject(), this.getToolWindowId()).contains(this);
    }

    @Override
    protected void updatePendingRequestsEDT() {
        super.updatePendingRequestsEDT();
        FileEditorManagerEx.getInstanceEx((Project)this.getProject()).updateFilePresentation(this.getLanguageConsole().getVirtualFile());
    }

    public LocalDataSource getDataSource() {
        return (LocalDataSource)((Object)this.getTarget());
    }

    @Nullable
    public ObjectPath getCurrentNamespace() {
        SearchPath path = this.getSearchPath();
        return path == null ? null : path.getCurrent();
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath.get();
    }

    @Override
    @NotNull
    protected PlaceInGrid getResultPlaceInGrid() {
        PlaceInGrid placeInGrid = PlaceInGrid.center;
        if (placeInGrid == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcConsole", "getResultPlaceInGrid"));
        }
        return placeInGrid;
    }

    public static List<JdbcConsole> getActiveConsoles(Project project) {
        List data = (List)project.getUserData(DATABASE_CONSOLE_LIST);
        if (data == null) {
            data = ContainerUtil.createLockFreeCopyOnWriteList();
            project.putUserData(DATABASE_CONSOLE_LIST, (Object)data);
            DbPsiFacade.getInstance((Project)project).addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

                public void modificationCountChanged(DbPsiFacade dbFacade) {
                    Project project = dbFacade.getProject();
                    List validAndInvalidConsoles = ContainerUtil.notNullize((List)((List)project.getUserData(DATABASE_CONSOLE_LIST)));
                    for (JdbcConsole console : validAndInvalidConsoles) {
                        if (!JdbcConsole.isDataSourceValid(dbFacade, (DatabaseSystem)console.getDataSource())) {
                            console.closeToolWindowContent();
                            FileEditorManager.getInstance((Project)project).closeFile(console.getLanguageConsole().getVirtualFile());
                            continue;
                        }
                        console.updateTitle();
                    }
                }
            }, (Disposable)project);
        }
        Iterator it = data.iterator();
        while (it.hasNext()) {
            if (((JdbcConsole)it.next()).isValid()) continue;
            it.remove();
        }
        return data;
    }

    @Nullable
    public static JdbcConsole findConsole(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/JdbcConsole", "findConsole"));
        }
        return JdbcConsole.findConsole(e.getProject(), (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE));
    }

    @Nullable
    public static JdbcConsole findConsole(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        JdbcConsole console = JdbcConsole.getConsole(project, virtualFile);
        if (console != null) {
            return console;
        }
        return JdbcConsoleProvider.getAttachedConsole(project, virtualFile);
    }

    @Nullable
    public static JdbcConsole getConsole(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || file == null) {
            return null;
        }
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            if (!Comparing.equal((Object)console.getLanguageConsole().getVirtualFile(), (Object)file)) continue;
            return console;
        }
        return null;
    }

    @Override
    public String getToolWindowId() {
        return CONSOLE_TOOLWINDOW_ID;
    }

    @Override
    public Icon getToolWindowIcon() {
        return DatabaseIcons.ToolWindowConsole;
    }

    @Override
    protected String getHelpID() {
        return "reference.runToolWindow.jdbcTab";
    }

    @Override
    protected void buildConsoleUi(boolean focused) {
        this.myDataConsumer.resetOutputTabCounter();
        this.getUi().getDefaults().initTabDefaults(0, DatabaseMessages.message((String)"jdbc.console.tab.title", (Object[])new Object[0]), null);
        this.getUi().getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        loadingPanel.setLoadingText("");
        loadingPanel.add((Component)this.getLanguageConsole().getComponent(), (Object)"Center");
        final String title = DatabaseMessages.message((String)"jdbc.console.tab.title.console", (Object[])new Object[0]);
        JComponent toFocus = this.getLanguageConsole().getHistoryViewer().getContentComponent();
        Content output = this.getUi().createContent("Input", (JComponent)loadingPanel, title, AllIcons.Debugger.Console, toFocus);
        DefaultActionGroup outputActions = new DefaultActionGroup();
        JdbcConsole.addLeftToolbarConsoleActions(outputActions, (ConsoleView)this.getLanguageConsole());
        output.setActions((ActionGroup)outputActions, "RunnerToolbar", this.getLanguageConsole().getComponent());
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        AnAction specificActionGroup = actionManager.getAction("Console.Dialect.SpecificGroup");
        if (specificActionGroup != null) {
            consoleActions.add(specificActionGroup);
        }
        consoleActions.addSeparator();
        consoleActions.add(actionManager.getAction("Database.Settings"));
        consoleActions.add(this.myToggleAction);
        consoleActions.add(ConsoleHistoryController.getController((LanguageConsoleView)this.getLanguageConsole()).getBrowseHistory());
        consoleActions.add(this.getUi().getOptions().getLayoutActions());
        consoleActions.addSeparator();
        consoleActions.add(this.myTerminateAction);
        consoleActions.add(this.myCloseAction);
        for (AnAction action : consoleActions.getChildActionsOrStubs()) {
            action.registerCustomShortcutSet(action.getShortcutSet(), this.getUi().getComponent());
        }
        this.getUi().getOptions().setLeftToolbar((ActionGroup)consoleActions, "toolbar");
        this.getLanguageConsole().setConsoleEditorEnabled(false);
        if (focused) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(this.getLanguageConsole().getVirtualFile(), true);
        }
        output.setCloseable(false);
        this.getUi().addContent(output, 0, PlaceInGrid.center, false);
        this.getUi().getContentManager().addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentAdded(ContentManagerEvent event) {
                if (!JdbcConsole.this.isValid()) {
                    return;
                }
                if (title.equals(event.getContent().getDisplayName())) {
                    FileEditorManager.getInstance((Project)JdbcConsole.this.getProject()).openFile(JdbcConsole.this.getLanguageConsole().getVirtualFile(), true, true);
                }
            }
        });
    }

    @Override
    @NotNull
    public ScriptModel<?> getScriptModel() {
        ScriptModel<?> scriptModel = this.myScriptModel;
        if (scriptModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcConsole", "getScriptModel"));
        }
        return scriptModel;
    }

    public void buildConsoleHeaderComponent(Editor editor) {
        this.checkValid();
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup leftGroup = new DefaultActionGroup();
        DefaultActionGroup rightGroup = new DefaultActionGroup();
        leftGroup.add(this.myRunAction);
        leftGroup.addSeparator();
        leftGroup.add(ConsoleHistoryController.getController((LanguageConsoleView)this.getLanguageConsole()).getBrowseHistory());
        leftGroup.add(this.myToggleAction);
        leftGroup.add(actionManager.getAction("Database.Settings"));
        leftGroup.addSeparator();
        leftGroup.add(actionManager.getAction("Console.Transaction"));
        leftGroup.addSeparator();
        leftGroup.add(this.myTerminateAction);
        rightGroup.add((AnAction)new ChooseSchemaAction());
        rightGroup.add((AnAction)new ChooseConsoleAction());
        EditorHeaderComponent headerComponent = new EditorHeaderComponent();
        ActionToolbar leftToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)leftGroup, true);
        ActionToolbar rightToolbar = ActionManager.getInstance().createActionToolbar("EditorToolbar", (ActionGroup)rightGroup, true);
        rightToolbar.setReservePlaceAutoPopupIcon(false);
        leftToolbar.setTargetComponent(editor.getContentComponent());
        rightToolbar.setTargetComponent(editor.getContentComponent());
        headerComponent.add((Component)leftToolbar.getComponent(), "Center");
        headerComponent.add((Component)rightToolbar.getComponent(), "East");
        ((EditorEx)editor).setPermanentHeaderComponent((JComponent)headerComponent);
        editor.setHeaderComponent((JComponent)headerComponent);
        ToggleToolbarAction.setToolbarVisible((String)TOGGLE_CONSOLE_TOOLBAR_PROP, (PropertiesComponent)PropertiesComponent.getInstance((Project)this.getProject()), (Iterable)JBIterable.of((Object)headerComponent), null);
        DatabaseEditorHelper.updateToolbarColor(this.getProject(), this.getLanguageConsole().getVirtualFile(), (JComponent)headerComponent);
    }

    @Override
    public void executeQueries(@NotNull Editor sourceEditor, @NotNull ScriptModel<?> model) {
        boolean scheduleRefresh;
        if (sourceEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceEditor", "com/intellij/database/console/JdbcConsole", "executeQueries"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/console/JdbcConsole", "executeQueries"));
        }
        IntrospectionScopeUpdater scopeUpdater = null;
        if (this.getDataSource().isAutoSynchronize()) {
            SyntaxTraverser s = (SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoots((Iterable)model.statements().transform(ScriptModelUtil.TO_OBJECT).filter(PsiElement.class).toList());
            boolean bl = scheduleRefresh = !((SyntaxTraverser)s.filter(e -> JdbcConsole.triggersIntrospection(e))).traverse().isEmpty();
            if (scheduleRefresh && DatabaseSettings.getSettings().trackNamespaces) {
                scopeUpdater = DbSqlUtil.getScopeUpdater((SyntaxTraverser<PsiElement>)s, this.getCurrentNamespace(), ((LocalDataSource)((Object)this.getTarget())).getModel());
            }
        } else {
            scheduleRefresh = false;
        }
        ConsoleDataRequest request = ConsoleDataRequest.newConsoleRequest(this, sourceEditor, model);
        request.getSharedDataHolder().putUserData(SCHEDULE_REFRESH, (Object)scheduleRefresh);
        request.getSharedDataHolder().putUserData(SCOPE_UPDATER, scopeUpdater);
        this.getMessageBus().getDataProducer().processRequest(request);
        FeatureUsageTracker.getInstance().triggerFeatureUsed("db.console.run.intention");
    }

    private static boolean triggersIntrospection(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/JdbcConsole", "triggersIntrospection"));
        }
        if (e instanceof SqlTableDefinition) {
            return true;
        }
        if (e instanceof SqlAlterStatement) {
            ObjectKind kind;
            SqlReferenceExpression ref = ((SqlAlterStatement)e).getAlterTargetReference();
            ObjectKind objectKind = kind = ref == null ? null : ref.getReferenceElementType().getTargetKind();
            if (kind == null) {
                return false;
            }
            if (kind != ObjectKind.DATABASE && kind != ObjectKind.SCHEMA) {
                return true;
            }
            return PsiTreeUtil.getChildOfType((PsiElement)e, SqlRenameToClause.class) != null;
        }
        return e instanceof SqlDdlStatement;
    }

    public void switchSchema(@NotNull SearchPath to, boolean force) {
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/console/JdbcConsole", "switchSchema"));
        }
        this.updateSearchPath(to);
        this.getMessageBus().getDataProducer().processRequest(DataRequest.newSchemaSwitchRequest(this, to, force));
    }

    @Override
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> createGridDataHookUp(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/console/JdbcConsole", "createGridDataHookUp"));
        }
        return GridDataHookUpManager.getInstance(this.getProject()).createDatabaseHookUp(this.getMessageBus(), parent);
    }

    @NotNull
    public Content createPlanContent() {
        PlanView view2 = PlanView.createView(this.getProject());
        Content content = this.getUi().createContent("Input", view2.getComponent(), "Plan", DatabaseIcons.Table, view2.getPreferredFocusedComponent());
        content.setCloseable(true);
        PLAN_VIEW_KEY.set((UserDataHolder)content, (Object)view2);
        Disposer.register((Disposable)content, (Disposable)new Disposable(){

            public void dispose() {
                JdbcConsole.this.myPlanContent = null;
            }
        });
        Content content2 = content;
        if (content2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcConsole", "createPlanContent"));
        }
        return content2;
    }

    public void showPlan(@Nullable PlanModel plan) {
        if (plan != null) {
            this.ensureContentInitialized(true);
            if (this.myPlanContent == null) {
                this.myPlanContent = this.createPlanContent();
                this.getUi().addContent(this.myPlanContent, -1, PlaceInGrid.bottom, false);
                this.getUi().setBouncing(this.myPlanContent, true);
            }
            ((PlanView)PLAN_VIEW_KEY.get((UserDataHolder)this.myPlanContent)).setModel(plan);
            this.getUi().selectAndFocus(this.myPlanContent, true, false);
        } else if (this.myPlanContent != null) {
            this.getUi().removeContent(this.myPlanContent, true);
            this.myPlanContent = null;
        }
    }

    private void initActions() {
        this.myRunAction = ActionManager.getInstance().getAction("Console.Jdbc.Execute");
        this.myTerminateAction = new DumbAwareAction(null, null, AllIcons.Actions.Suspend){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/JdbcConsole$6", "actionPerformed"));
                }
                JdbcConsole.this.getMessageBus().getDataProducer().processRequest(new DataRequest.Cancel(JdbcConsole.this));
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/JdbcConsole$6", "update"));
                }
                e.getPresentation().setEnabled(!JdbcConsole.this.isIdle());
            }
        };
        this.myCloseAction = new DumbAwareAction("Close", "Close", AllIcons.Actions.Cancel){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/JdbcConsole$7", "actionPerformed"));
                }
                JdbcConsole.this.closeToolWindowContent();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/JdbcConsole$7", "update"));
                }
                e.getPresentation().setEnabled(true);
            }
        };
        this.myToggleAction = this.initParameterView();
        JComponent shortcutTarget = this.getLanguageConsole().getConsoleEditor().getComponent();
        EmptyAction.setupAction((AnAction)this.myCloseAction, (String)"Console.Jdbc.Close", (JComponent)shortcutTarget);
        EmptyAction.setupAction((AnAction)this.myTerminateAction, (String)"Console.Jdbc.Terminate", (JComponent)shortcutTarget);
    }

    public void closeToolWindowContent() {
        if (!this.isToolWindowContentPresent()) {
            return;
        }
        this.getContent().getManager().removeContent(this.getContent(), false);
    }

    @Override
    public boolean isTargetValid() {
        return JdbcConsole.isDataSourceValid(DbPsiFacade.getInstance((Project)this.getProject()), (DatabaseSystem)this.getDataSource());
    }

    @Override
    public void dispose() {
        JdbcConsole.getActiveConsoles(this.getProject()).remove(this);
        super.dispose();
    }

    public void updateTitle() {
        String title = JdbcConsole.getTitle(this.getProject(), this.getLanguageConsole().getVirtualFile());
        this.getLanguageConsole().setTitle(title);
        this.getContent().setDisplayName(title);
    }

    private static boolean isDataSourceValid(@NotNull DbPsiFacade dbFacade, @NotNull DatabaseSystem dataSource) {
        if (dbFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbFacade", "com/intellij/database/console/JdbcConsole", "isDataSourceValid"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/JdbcConsole", "isDataSourceValid"));
        }
        return dbFacade.findDataSource(dataSource.getUniqueId()) != null;
    }

    @NotNull
    private static String getTitle(Project project, VirtualFile file) {
        String fileTitle = EditorTabbedContainer.calcTabTitle((Project)project, (VirtualFile)file);
        String string = StringUtil.trimEnd((String)fileTitle, (String)("." + file.getExtension()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcConsole", "getTitle"));
        }
        return string;
    }

    public static class Builder {
        Project myProject;
        private String myQuery;
        private VirtualFile myVirtualFile;
        private DatabaseSystem myInfo;

        public Builder(Project project) {
            this.myProject = project;
        }

        public Builder withQuery(CharSequence query) {
            this.myQuery = query == null ? null : query.toString();
            return this;
        }

        public Builder forFile(VirtualFile file) {
            this.myVirtualFile = file;
            return this;
        }

        public Builder fromDataSource(DatabaseSystem info) {
            this.myInfo = info;
            return this;
        }

        @NotNull
        public JdbcConsole buildAndShow(boolean focused) {
            JdbcConsole console = this.build();
            console.showConsole(focused);
            JdbcConsole jdbcConsole = console;
            if (jdbcConsole == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcConsole$Builder", "buildAndShow"));
            }
            return jdbcConsole;
        }

        @NotNull
        public JdbcConsole build() {
            LocalDataSource dataSource = DbImplUtil.getLocalDataSource(this.myInfo);
            VirtualFile file = this.myVirtualFile != null ? this.myVirtualFile : DatabaseEditorHelper.getConsoleVirtualFile(this.myInfo);
            String title = JdbcConsole.getTitle(this.myProject, file);
            SimpleRequestBroker broker = SimpleRequestBroker.newInstance(this.myProject, title);
            LanguageConsoleImpl consoleView = new LanguageConsoleImpl(this.myProject, title, file);
            JdbcConsole console = new JdbcConsole((LanguageConsoleView)consoleView, (DataBus.Consuming)broker, dataSource, this.myQuery);
            JdbcEngine engine = new JdbcEngine(this.myProject, broker, dataSource, null);
            Disposer.register((Disposable)console, (Disposable)engine);
            DatabaseFamilyId dbFamilyId = DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource);
            if (dbFamilyId.isOracle()) {
                OracleCompilationErrorsObtainer errorsObtainer = new OracleCompilationErrorsObtainer(console);
                Disposer.register((Disposable)console, (Disposable)errorsObtainer);
            }
            JdbcConsole jdbcConsole = console;
            if (jdbcConsole == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/JdbcConsole$Builder", "build"));
            }
            return jdbcConsole;
        }
    }
}

