/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.TooLongStatementException;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.icons.AllIcons;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;

public class RunSqlScriptAction
extends DumbAwareAction {
    private static final int BATCH_MAX_SIZE = 1000;
    private static final int BATCH_MAX_LENGTH = 512000;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction", "update"));
        }
        Project project = e.getProject();
        JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(DbSqlUtil.SQL_FILE_FILTER(project));
        if (project == null || e.getData(PlatformDataKeys.FILE_EDITOR) instanceof DatabaseTableFileEditor || files.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean enabled = !((List)RunSqlScriptAction.getDataSources((Project)project, (JBIterable<VirtualFile>)files).second).isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(true);
        String title = files.size() == 1 ? ((VirtualFile)files.iterator().next()).getName() : files.size() + " files";
        e.getPresentation().setText(String.format("Run '%s'... ", StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)title, (int)20))));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction", "actionPerformed"));
        }
        Project project = e.getProject();
        JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(DbSqlUtil.SQL_FILE_FILTER(project));
        if (project == null || e.getData(PlatformDataKeys.FILE_EDITOR) instanceof DatabaseTableFileEditor || files.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        String title = files.size() == 1 ? ((VirtualFile)files.iterator().next()).getName() : files.size() + " files";
        String taskName = String.format("Run '%s'... ", StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)title, (int)20)));
        Couple<List<DbDataSource>> dataSources = RunSqlScriptAction.getDataSources(project, (JBIterable<VirtualFile>)files);
        RunSqlScriptAction.chooseDataSourceAndRun(project, e.getDataContext(), (List)dataSources.first, (List)dataSources.second, (Processor<List<LocalDataSource>>)((Processor)selectedDataSources -> {
            RunSqlScriptAction.perform(project, taskName, (JBIterable<VirtualFile>)files, selectedDataSources);
            return true;
        }));
    }

    private static Couple<List<DbDataSource>> getDataSources(@NotNull Project project, @NotNull JBIterable<VirtualFile> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction", "getDataSources"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/console/RunSqlScriptAction", "getDataSources"));
        }
        List allDataSources = JBIterable.from((Iterable)DbPsiFacade.getInstance((Project)project).getDataSources()).filter(DbImplUtil.CAN_CONNECT_TO).toList();
        if (allDataSources.isEmpty()) {
            return Couple.of(Collections.emptyList(), Collections.emptyList());
        }
        boolean first = true;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList dataSources = ContainerUtil.newArrayList();
        for (VirtualFile file : files) {
            boolean isDbFile = DbImplUtil.isDatabaseVirtualFile(file);
            PsiFile psiFile = psiManager.findFile(file);
            if (psiFile == null) continue;
            JBIterable<DbDataSource> o = DbImplUtil.getDataSourcesForExec(psiFile, !isDbFile, isDbFile);
            if (first) {
                o.addAllTo((Collection)dataSources);
            } else {
                dataSources.retainAll(o.toList());
            }
            first = false;
        }
        return Couple.of((Object)dataSources, (Object)allDataSources);
    }

    public static void perform(final @NotNull Project project, @NotNull String taskName, final @NotNull JBIterable<VirtualFile> files, final @NotNull List<LocalDataSource> dataSources) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction", "perform"));
        }
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/database/console/RunSqlScriptAction", "perform"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/console/RunSqlScriptAction", "perform"));
        }
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/console/RunSqlScriptAction", "perform"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
        SqlLanguageDialect preferredDialect = DbImplUtil.getSqlDialect(project, (DatabaseSystem)dataSources.get(0));
        SqlLanguageDialect genericDialect = DbSqlUtil.getGenericDialect();
        List remapDialect = files.filter(file -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction", "lambda$perform$1"));
            }
            return LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file) != preferredDialect;
        }).toList();
        if (!remapDialect.isEmpty() && preferredDialect != genericDialect) {
            WriteAction.run(() -> {
                for (VirtualFile file : remapDialect) {
                    sqlPsiFacade.setDialectMapping(file, preferredDialect);
                }
            });
        }
        final Ref reporter = Ref.create(null);
        final AtomicReference<ProgressIndicator> indicatorRef = new AtomicReference<ProgressIndicator>();
        Runnable runnable = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction", "lambda$perform$3"));
            }
            if (taskName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/database/console/RunSqlScriptAction", "lambda$perform$3"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/console/RunSqlScriptAction", "lambda$perform$3"));
            }
            if (dataSources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/console/RunSqlScriptAction", "lambda$perform$3"));
            }
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, taskName, true, null){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/console/RunSqlScriptAction$1", "run"));
                    }
                    List models = (List)ReadAction.compute(() -> {
                        if (files == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/console/RunSqlScriptAction$1", "lambda$run$2"));
                        }
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction$1", "lambda$run$2"));
                        }
                        return files.map(file -> {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction$1", "lambda$null$0"));
                            }
                            return PsiManager.getInstance((Project)project).findFile(file);
                        }).filter(Conditions.notNull()).map(file -> sqlPsiFacade.createScriptModel(file)).toList();
                    });
                    indicatorRef.set(indicator);
                    indicator.setFraction(0.0);
                    indicator.setIndeterminate(false);
                    for (ScriptModel scriptModel : models) {
                        VirtualFile virtualFile = scriptModel.getVirtualFile();
                        String title = "Run " + virtualFile.getPresentableUrl();
                        RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), title);
                        try {
                            this.runImpl(scriptModel, indicator, models.size());
                        }
                        catch (ProcessCanceledException e) {
                            RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), "Cancelled");
                        }
                        finally {
                            Disposer.dispose((Disposable)scriptModel);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void runImpl(@NotNull ScriptModel<?> scriptModel, @NotNull ProgressIndicator indicator, int progressMultiplier) {
                    if (scriptModel == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptModel", "com/intellij/database/console/RunSqlScriptAction$1", "runImpl"));
                    }
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/console/RunSqlScriptAction$1", "runImpl"));
                    }
                    long[] counter = new long[]{0L, 0L, 0L};
                    long total = 0L;
                    long t0 = System.currentTimeMillis();
                    for (LocalDataSource dataSource : dataSources) {
                        RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), "Connecting to " + dataSource.getName() + "...");
                        Ref doneAnything = Ref.create();
                        try {
                            RunSqlScriptAction.runStatements(project, dataSource, scriptModel, (DataAuditor.PrintingAdapter)reporter.get(), indicator, counter, progressMultiplier * dataSources.size(), (Ref<Boolean>)doneAnything);
                        }
                        finally {
                            if (Boolean.TRUE.equals(doneAnything.get())) {
                                DataSourceUiUtil.performAutoSyncTask(this.getProject(), dataSource);
                            }
                        }
                        if (total != 0L) continue;
                        total = counter[0] * (long)dataSources.size();
                    }
                    long t3 = System.currentTimeMillis() - t0;
                    RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), "Summary: " + counter[0] + " of " + total + " statements executed" + (counter[1] > 0L ? ", " + counter[1] + " failed" : "") + " in " + StringUtil.formatDuration((long)t3) + " (" + counter[2] + " symbols in file)");
                }
            });
        };
        ConsoleView consoleView = RunSqlScriptAction.addConsole(project, taskName, files, runnable, indicatorRef);
        reporter.set((Object)new DataAuditor.ConsoleLogger(consoleView));
        runnable.run();
    }

    private static void reportAndLog(Project project, DataAuditor.PrintingAdapter logger, String message) {
        DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message, MessageType.INFO).notify(project);
        logger.print(message);
    }

    private static ConsoleView addConsole(Project project, String taskName, final JBIterable<VirtualFile> files, final Runnable rerunRunnable, final AtomicReference<ProgressIndicator> indicatorRef) {
        final ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JPanel consoleComponent = new JPanel(new BorderLayout());
        consoleComponent.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("RunnerToolbar", (ActionGroup)toolbarActions, false);
        toolbar.setTargetComponent(consoleView.getComponent());
        consoleComponent.add((Component)toolbar.getComponent(), "West");
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)consoleView, null, consoleComponent, taskName){

            public boolean isContentReuseProhibited() {
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                return indicator != null && indicator.isRunning();
            }
        };
        Disposer.register((Disposable)consoleView, (Disposable)new Disposable(){

            public void dispose() {
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                if (indicator != null && indicator.isRunning()) {
                    indicator.cancel();
                }
            }
        });
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        toolbarActions.add((AnAction)new DumbAwareAction("Rerun", null, AllIcons.Actions.Rerun){

            public void update(@NotNull AnActionEvent e) {
                VirtualFile file;
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction$4", "update"));
                }
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                boolean enabled = indicator == null || !indicator.isRunning();
                Iterator iterator = files.iterator();
                while (iterator.hasNext() && (enabled &= (file = (VirtualFile)iterator.next()).isValid())) {
                }
                e.getPresentation().setEnabled(enabled);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction$4", "actionPerformed"));
                }
                consoleView.clear();
                rerunRunnable.run();
            }
        });
        toolbarActions.add((AnAction)new DumbAwareAction("Stop", null, AllIcons.Actions.Suspend){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction$5", "update"));
                }
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                e.getPresentation().setEnabled(indicator != null && indicator.isRunning());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction$5", "actionPerformed"));
                }
                ProgressIndicator indicator = (ProgressIndicator)indicatorRef.get();
                if (indicator != null && indicator.isRunning()) {
                    indicator.cancel();
                    consoleView.print("\nExecution aborted\n", ConsoleViewContentType.ERROR_OUTPUT);
                }
            }
        });
        toolbarActions.addSeparator();
        AbstractQueryLanguageConsole.addLeftToolbarConsoleActions(toolbarActions, consoleView);
        toolbarActions.addSeparator();
        toolbarActions.add(ActionManager.getInstance().getAction("PinActiveTab"));
        toolbarActions.add((AnAction)new CloseAction(executor, descriptor, project));
        ExecutionManager.getInstance((Project)project).getContentManager().showRunContent(executor, descriptor);
        return consoleView;
    }

    public static void runStatements(Project project, LocalDataSource dataSource, ScriptModel<?> scriptModel, DataAuditor.PrintingAdapter reporter) {
        RunSqlScriptAction.runStatements(project, dataSource, scriptModel, reporter, (ProgressIndicator)new EmptyProgressIndicator(), new long[3], 1, null);
    }

    private static void runStatements(Project project, LocalDataSource dataSource, ScriptModel<?> scriptModel, DataAuditor.PrintingAdapter reporter, ProgressIndicator progress, long[] counter, int progressMultiplier, Ref<Boolean> doneAnything) {
        Runner r = new Runner(project, dataSource, reporter);
        r.withConnected(() -> {
            try {
                r.prepare(scriptModel);
                progress.checkCanceled();
                progress.setText(dataSource.getName());
                if (r.connection == null) {
                    reporter.error("Unable to acquire connection", null);
                    return;
                }
                counter[2] = 0L;
                boolean inBatch = false;
                TokenSet dmlSet = TokenSet.create((IElementType[])new IElementType[]{SqlTokenRegistry.findCompositeType((String)"SQL_INSERT_STATEMENT"), SqlTokenRegistry.findCompositeType((String)"SQL_UPDATE_STATEMENT"), SqlTokenRegistry.findCompositeType((String)"SQL_DELETE_STATEMENT")});
                Condition notDml = o -> !dmlSet.contains(o.type());
                for (JBIterable itGroup : scriptModel.statements().split(JBIterable.Split.GROUP, notDml)) {
                    if (doneAnything != null) {
                        doneAnything.set((Object)true);
                    }
                    double fraction = -1.0;
                    if (inBatch) {
                        reporter.print("");
                    }
                    inBatch = false;
                    for (ScriptModel.StatementIt it : itGroup) {
                        progress.checkCanceled();
                        String sql = it.text();
                        if (!inBatch) {
                            reporter.println(StringUtil.first((String)sql, (int)240, (boolean)true), ConsoleViewContentType.USER_INPUT);
                            progress.setText2(StringUtil.first((String)sql, (int)120, (boolean)true));
                        }
                        counter[0] = counter[0] + 1L;
                        counter[2] = counter[2] + (long)sql.length();
                        long curOffset = it.rangeOffset() + (long)it.range().getEndOffset();
                        fraction = (double)curOffset * r.averageBytesPerChar / (double)r.fileSize / (double)progressMultiplier;
                        if (!r.batchUpdatesSupported || notDml.value((Object)it)) {
                            r.runSingle(sql);
                            progress.setFraction(fraction);
                            continue;
                        }
                        if (r.batchCount % 10L == 1L) {
                            reporter.rawPrint(".", ConsoleViewContentType.USER_INPUT);
                        }
                        inBatch = true;
                        r.addBatch(sql);
                        if (r.batchCount < 1000L && r.batchLength < 512000L) continue;
                        reporter.print("");
                        counter[1] = counter[1] + r.runBatch();
                        progress.setFraction(fraction);
                    }
                    if (!inBatch) continue;
                    reporter.print("");
                    counter[1] = counter[1] + r.runBatch();
                    progress.setFraction(fraction);
                }
            }
            catch (TooLongStatementException e) {
                reporter.error(e.getMessage() + ". Increasing memory via -Xmx may help. Aborting.", null);
            }
            finally {
                if (scriptModel != null) {
                    Disposer.dispose((Disposable)scriptModel);
                }
            }
        });
        reporter.print("\n");
    }

    private static void chooseDataSourceAndRun(Project project, DataContext context, List<DbDataSource> dataSources, List<DbDataSource> allDataSources, Processor<List<LocalDataSource>> processor) {
        ArrayList sorted = ContainerUtil.newArrayList(dataSources);
        Collections.sort(sorted, Comparator.comparing(DasObject::getName));
        if (dataSources.size() < allDataSources.size()) {
            sorted.add(null);
        }
        JBList list = new JBList((ListModel)new CollectionListModel((List)sorted));
        DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(project).getState();
        final boolean useColors = state.useColors && state.inDatabaseView;
        list.setVisibleRowCount(10);
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<DbDataSource>(){

            protected void customizeCellRenderer(@NotNull JList list, DbDataSource dataSource, int index, boolean selected, boolean hasFocus) {
                Color bg;
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/console/RunSqlScriptAction$6", "customizeCellRenderer"));
                }
                if (dataSource == null) {
                    this.append("Other\u2026");
                    return;
                }
                this.setIcon(dataSource.getIcon());
                this.append(dataSource.getName(), DbImplUtil.isConnected((DbElement)dataSource) ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                Color color = bg = !selected && useColors ? DatabaseColorManager.getColor((DbElement)dataSource) : null;
                if (bg != null) {
                    this.setBackground(bg);
                }
            }
        });
        final Consumer otherHandler = event -> {
            if (!JBIterable.from((Iterable)list.getSelectedValuesList()).contains(null)) {
                return;
            }
            event.consume();
            ((FilteringListModel)list.getModel()).replaceAll(allDataSources);
            list.setSelectedIndex(0);
            JBPopup popup = PopupUtil.getPopupContainerFor((Component)list);
            if (popup != null) {
                popup.pack(false, true);
            }
        };
        list.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction$7", "keyPressed"));
                }
                if (e.getKeyCode() == 10) {
                    otherHandler.consume((Object)e);
                }
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction$8", "onClick"));
                }
                otherHandler.consume((Object)e);
                return e.isConsumed();
            }
        }.installOn((Component)list);
        new PopupChooserBuilder((JList)list).setTitle("Choose Data Source").setMovable(true).setResizable(true).setItemChoosenCallback(() -> {
            JBIterable selection = JBIterable.from((Iterable)list.getSelectedValuesList());
            if (selection.contains(null)) {
                return;
            }
            processor.process((Object)selection.transform(o -> (LocalDataSource)o.getDelegate()).toList());
        }).setFilteringEnabled(o -> o == null ? "" : ((DasObject)o).getName()).createPopup().showInBestPositionFor(context);
    }

    private static class Runner {
        final Project project;
        final LocalDataSource dataSource;
        final DataAuditor.PrintingAdapter reporter;
        final SqlLanguageDialect dialect;
        long fileSize;
        double averageBytesPerChar;
        boolean batchUpdatesSupported;
        Connection connection;
        Statement statement;
        long failCount;
        long batchCount;
        long batchLength;

        public Runner(@NotNull Project project, @NotNull LocalDataSource dataSource, DataAuditor.PrintingAdapter reporter) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction$Runner", "<init>"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/RunSqlScriptAction$Runner", "<init>"));
            }
            this.fileSize = 1L;
            this.averageBytesPerChar = 1.0;
            this.project = project;
            this.dataSource = dataSource;
            this.reporter = reporter;
            this.dialect = DbImplUtil.getSqlDialect(project, (DatabaseSystem)dataSource);
        }

        void prepare(ScriptModel<?> scriptModel) {
            try {
                if (!this.dialect.getDatabaseDialect().getFamilyId().isTransactSql()) {
                    DatabaseMetaData metaData = this.connection.getMetaData();
                    this.batchUpdatesSupported = metaData.supportsBatchUpdates();
                    if (this.batchUpdatesSupported) {
                        this.reporter.print("Using batch mode (1000 insert/update/delete statements max)");
                    }
                }
            }
            catch (Exception ex) {
                this.reporter.error(JdbcEngine.getErrorMessage(ex, this.dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)this.dataSource)), null);
            }
            VirtualFile virtualFile = scriptModel.getVirtualFile();
            DbElement element = DbImplUtil.findElement(this.project, virtualFile);
            if (element != null) {
                DatabaseEditorHelper.setCurrentSchemaSafe(element, this.connection);
            }
            this.fileSize = virtualFile.getLength();
            this.averageBytesPerChar = virtualFile.getCharset().newEncoder().averageBytesPerChar();
        }

        public void withConnected(Runnable r) {
            ErrorHandler handler = new ErrorHandler();
            try {
                DatabaseConnectionManager.getInstance().performJdbcOperationSync(this.project, this.dataSource, handler, (connection, indicator) -> {
                    try {
                        this.connection = connection;
                        this.statement = connection.createStatement();
                        r.run();
                        Object var4_4 = null;
                        return var4_4;
                    }
                    finally {
                        this.connection = null;
                        if (this.statement != null) {
                            JdbcUtil.closeStatementSafe((Statement)this.statement);
                        }
                    }
                });
            }
            catch (ProcessCanceledException e) {
                if (handler.hasErrors()) {
                    this.reporter.error(handler.getSummary(), null);
                }
                throw e;
            }
            catch (Exception e) {
                this.reporter.error(null, e);
            }
        }

        public void runSingle(String sql) {
            try {
                int updateCount;
                long timestamp = System.currentTimeMillis();
                this.statement.execute(sql);
                ResultSet resultSet = this.statement.getResultSet();
                JdbcUtil.closeResultSetSafe((ResultSet)resultSet);
                String executionTime = StringUtil.formatDuration((long)(System.currentTimeMillis() - timestamp));
                int n = updateCount = resultSet == null ? this.statement.getUpdateCount() : 0;
                if (resultSet != null) {
                    this.reporter.print("Executed in " + executionTime);
                } else {
                    this.reporter.print(updateCount + " row(s) affected in " + executionTime);
                }
            }
            catch (Exception ex) {
                if (DbImplUtil.isRemoteProcessDown(ex)) {
                    this.reporter.error("Connection is closed", null);
                    throw new ProcessCanceledException();
                }
                this.reporter.error(JdbcEngine.getErrorMessage(ex, this.dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)this.dataSource)), null);
                ++this.failCount;
            }
        }

        public void addBatch(String sql) {
            if (!this.batchUpdatesSupported) {
                this.runSingle(sql);
                return;
            }
            try {
                this.statement.addBatch(sql);
                ++this.batchCount;
                this.batchLength += (long)sql.length();
            }
            catch (SQLException e) {
                this.batchUpdatesSupported = false;
                if (this.batchCount > 0L) {
                    this.failCount += this.runBatch();
                }
                this.runSingle(sql);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long runBatch() {
            if (!this.batchUpdatesSupported) {
                return this.failCount;
            }
            if (this.batchCount == 0L) {
                return 0L;
            }
            int failCount = 0;
            try {
                int[] longs;
                long updateCount = 0L;
                long timestamp = System.currentTimeMillis();
                int[] nArray = longs = this.statement.executeBatch();
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    long c = nArray[j];
                    if (c >= 0L) {
                        updateCount += c;
                        continue;
                    }
                    if (c != -3L) continue;
                    ++failCount;
                }
                String executionTime = StringUtil.formatDuration((long)(System.currentTimeMillis() - timestamp));
                if (updateCount == 0L) {
                    this.reporter.print("Executed in " + executionTime + " ms");
                } else {
                    this.reporter.print(updateCount + " row(s) affected in " + executionTime + " ms");
                }
            }
            catch (Exception ex) {
                this.reporter.error(JdbcEngine.getErrorMessage(ex, this.dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)this.dataSource)), null);
                failCount = (int)((long)failCount + this.batchCount);
            }
            finally {
                this.batchCount = 0L;
                this.batchLength = 0L;
            }
            return failCount;
        }
    }
}

