/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.PersistentCsvFormat;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.StreamCsvFormatParser;
import com.intellij.database.editor.CsvTableFileEditorProvider;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.VfsDependentEnum;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatResolver {
    private static final Logger LOG = Logger.getInstance(CsvFormatResolver.class);
    private static final int VERSION = 1;
    private static final FileAttribute CSV_FORMAT_ATTRIBUTES = new FileAttribute("csv_format", 1, true);
    private static final VfsDependentEnum<String> ENUM = new VfsDependentEnum("csv_format_enumerator", (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, 1);
    private static final int LIMIT = 3000;

    private CsvFormatResolver() {
    }

    @Nullable
    public static CsvFormat getFormatFromState(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/csv/CsvFormatResolver", "getFormatFromState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/csv/CsvFormatResolver", "getFormatFromState"));
        }
        CsvTableFileEditorProvider provider = CsvTableFileEditorProvider.getProvider();
        return provider == null ? null : CsvFormatResolver.getFormatFromState(project, file, provider);
    }

    @Nullable
    public static CsvFormat getFormatFromState(@NotNull Project project, @NotNull VirtualFile file, @NotNull CsvTableFileEditorProvider provider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/csv/CsvFormatResolver", "getFormatFromState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/csv/CsvFormatResolver", "getFormatFromState"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/csv/CsvFormatResolver", "getFormatFromState"));
        }
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.getInstance((Project)project);
        FileEditorState state = editorHistoryManager == null ? null : editorHistoryManager.getState(file, (FileEditorProvider)provider);
        return editorHistoryManager != null && state != null ? CsvFormatResolver.readCsvFormat(state) : null;
    }

    @Nullable
    public static CsvFormat getMoreSuitableCsvFormat(@NotNull CharSequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/csv/CsvFormatResolver", "getMoreSuitableCsvFormat"));
        }
        List<CsvFormat> formats = DatabaseSettings.getSettings().getCsvFormats();
        ArrayList results = ContainerUtil.newArrayList();
        for (CsvFormat format : formats) {
            StreamCsvFormatParser parser = new StreamCsvFormatParser(format, 3000);
            try {
                results.add(new MyParserResult(parser.parse(new StringReader(sequence.toString())), format));
            }
            catch (IOException e) {
                results.add(new MyParserResult(null, format));
            }
        }
        ContainerUtil.sort((List)results);
        MyParserResult item = (MyParserResult)ContainerUtil.getFirstItem((List)results);
        return item == null ? null : item.myFormat;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static CsvFormat getFormatFromFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/csv/CsvFormatResolver", "getFormatFromFile"));
        }
        DataInputStream stream = CSV_FORMAT_ATTRIBUTES.readAttribute(file);
        if (stream == null) {
            return null;
        }
        try (DataInputStream resource = stream;){
            int i2 = DataInputOutputUtil.readINT((DataInput)resource);
            String id = (String)ENUM.getById(i2);
            Element load = JDOMUtil.load((CharSequence)id);
            PersistentCsvFormat format = (PersistentCsvFormat)XmlSerializer.deserialize((Element)load, PersistentCsvFormat.class);
            CsvFormat csvFormat = format.immutable();
            return csvFormat;
        }
        catch (IOException | JDOMException e) {
            LOG.warn(e);
            return null;
        }
    }

    public static void saveCsvFormat(@NotNull CsvFormat format, @NotNull VirtualFile file) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/CsvFormatResolver", "saveCsvFormat"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/csv/CsvFormatResolver", "saveCsvFormat"));
        }
        PersistentCsvFormat persistentFormat = new PersistentCsvFormat(format);
        Element element = XmlSerializer.serialize((Object)persistentFormat);
        String string = JDOMUtil.write((Parent)element, (String)"\n");
        try (DataOutputStream resource = CSV_FORMAT_ATTRIBUTES.writeAttribute(file);){
            DataInputOutputUtil.writeINT((DataOutput)resource, (int)ENUM.getId((Object)string));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public static FileEditorState getState(@NotNull FileEditorStateLevel level, @NotNull CsvDocumentDataHookUp hookup) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/database/csv/CsvFormatResolver", "getState"));
        }
        if (hookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hookup", "com/intellij/database/csv/CsvFormatResolver", "getState"));
        }
        FileEditorState fileEditorState = level == FileEditorStateLevel.FULL && hookup.getRange() == null ? new State(hookup.getFormat()) : FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/CsvFormatResolver", "getState"));
        }
        return fileEditorState;
    }

    @Nullable
    public static CsvFormat readCsvFormat(@Nullable FileEditorState state) {
        State csvState = (State)ObjectUtils.tryCast((Object)state, State.class);
        return csvState != null ? csvState.format.immutable() : null;
    }

    @Nullable
    public static CsvFormat getFormat(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/csv/CsvFormatResolver", "getFormat"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/csv/CsvFormatResolver", "getFormat"));
        }
        return CsvFormatResolver.getFormat(project, file, FormatGetter.FILE, FormatGetter.STATE, FormatGetter.CONTENT);
    }

    @Nullable
    public static CsvFormat getFormat(@NotNull Project project, @NotNull VirtualFile file, FormatGetter ... getters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/csv/CsvFormatResolver", "getFormat"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/csv/CsvFormatResolver", "getFormat"));
        }
        if (getters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getters", "com/intellij/database/csv/CsvFormatResolver", "getFormat"));
        }
        for (FormatGetter getter : getters) {
            CsvFormat format = getter.get(project, file);
            if (format == null) continue;
            return format;
        }
        return null;
    }

    public static enum FormatGetter {
        STATE{

            @Override
            @Nullable
            CsvFormat get(@NotNull Project project, @NotNull VirtualFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/csv/CsvFormatResolver$FormatGetter$1", "get"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/csv/CsvFormatResolver$FormatGetter$1", "get"));
                }
                return CsvFormatResolver.getFormatFromState(project, file);
            }
        }
        ,
        FILE{

            @Override
            @Nullable
            CsvFormat get(@NotNull Project project, @NotNull VirtualFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/csv/CsvFormatResolver$FormatGetter$2", "get"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/csv/CsvFormatResolver$FormatGetter$2", "get"));
                }
                return CsvFormatResolver.getFormatFromFile(file);
            }
        }
        ,
        CONTENT{

            @Override
            @Nullable
            CsvFormat get(@NotNull Project project, @NotNull VirtualFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/csv/CsvFormatResolver$FormatGetter$3", "get"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/csv/CsvFormatResolver$FormatGetter$3", "get"));
                }
                CharSequence sequence = LoadTextUtil.loadText((VirtualFile)file, (int)3000);
                return CsvFormatResolver.getMoreSuitableCsvFormat(sequence);
            }
        };


        @Nullable
        abstract CsvFormat get(@NotNull Project var1, @NotNull VirtualFile var2);
    }

    private static class MyParserResult
    implements Comparable<MyParserResult> {
        private final StreamCsvFormatParser.CsvParserResult myResult;
        private final CsvFormat myFormat;

        private MyParserResult(@Nullable StreamCsvFormatParser.CsvParserResult result, @NotNull CsvFormat format) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/CsvFormatResolver$MyParserResult", "<init>"));
            }
            this.myResult = result;
            this.myFormat = format;
        }

        @Override
        public int compareTo(@NotNull MyParserResult o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/csv/CsvFormatResolver$MyParserResult", "compareTo"));
            }
            if (this.myResult == null) {
                return o.myResult == null ? 0 : 1;
            }
            if (o.myResult == null) {
                return -1;
            }
            StreamCsvFormatParser.Token[] header = this.myResult.getHeader();
            StreamCsvFormatParser.Token[] oHeader = o.myResult.getHeader();
            if (header == null) {
                return oHeader == null ? 0 : 1;
            }
            if (oHeader == null) {
                return -1;
            }
            int compare = Integer.compare(oHeader.length, header.length);
            return compare != 0 ? compare : Integer.compare(MyParserResult.errorsCount(this.myResult), MyParserResult.errorsCount(o.myResult));
        }

        private static int errorsCount(@NotNull StreamCsvFormatParser.CsvParserResult result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/csv/CsvFormatResolver$MyParserResult", "errorsCount"));
            }
            List<ErrorRecord> errors = result.getErrors();
            ErrorRecord item = (ErrorRecord)ContainerUtil.getLastItem(errors);
            if (item == null) {
                return 0;
            }
            String message = item.getMessage();
            return StringUtil.containsIgnoreCase((String)message, (String)"end of file") ? errors.size() - 1 : errors.size();
        }
    }

    public static class State
    implements FileEditorState {
        @Tag(value="format")
        public PersistentCsvFormat format;

        public State() {
        }

        public State(@NotNull CsvFormat format) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/CsvFormatResolver$State", "<init>"));
            }
            this.format = new PersistentCsvFormat(format);
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return false;
        }
    }
}

