/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.DomainWrapper;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomSuitabilityDomain
extends Domain
implements DomainWrapper {
    private final Domain myDelegate;

    public CustomSuitabilityDomain(@NotNull Domain delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/data/types/domain/CustomSuitabilityDomain", "<init>"));
        }
        super(delegate.getPoint(), delegate.getDomainType(), delegate.simpleName());
        this.myDelegate = delegate;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality cardinality = this.myDelegate.cardinality();
        if (cardinality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/CustomSuitabilityDomain", "cardinality"));
        }
        return cardinality;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/CustomSuitabilityDomain", "getCompatibility"));
        }
        Compatibility compatibility = this.myDelegate.getCompatibility(domain);
        if (compatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/CustomSuitabilityDomain", "getCompatibility"));
        }
        return compatibility;
    }

    @Override
    @NotNull
    public Domain unwrap() {
        Domain domain = this.myDelegate;
        if (domain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/CustomSuitabilityDomain", "unwrap"));
        }
        return domain;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/CustomSuitabilityDomain", "trim"));
        }
        return this.myDelegate.trim(o);
    }

    @Override
    @NotNull
    public String name() {
        String string = this.myDelegate.name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/CustomSuitabilityDomain", "name"));
        }
        return string;
    }

    @Override
    public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/CustomSuitabilityDomain", "isSuitable"));
        }
        return super.isSuitable(descriptor) && this.isCustomSuitable(descriptor);
    }

    protected final Domain getDelegate() {
        return this.myDelegate;
    }

    protected abstract boolean isCustomSuitable(@NotNull ColumnDescriptor var1);

    public static class Greater
    extends SizeDomain {
        public Greater(@NotNull Domain delegate, int size) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/data/types/domain/CustomSuitabilityDomain$Greater", "<init>"));
            }
            super(delegate, size);
        }

        @Override
        protected boolean isCustomSuitable(@NotNull ColumnDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/CustomSuitabilityDomain$Greater", "isCustomSuitable"));
            }
            return this.getSize() < descriptor.getSize();
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull Domain domain) {
            if (domain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/CustomSuitabilityDomain$Greater", "narrow"));
            }
            Greater greater = new Greater(this.getDelegate().narrow(domain), this.getSize());
            if (greater == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/CustomSuitabilityDomain$Greater", "narrow"));
            }
            return greater;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull SizeProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/domain/CustomSuitabilityDomain$Greater", "narrow"));
            }
            Greater greater = new Greater(this.getDelegate().narrow(provider), this.getSize());
            if (greater == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/CustomSuitabilityDomain$Greater", "narrow"));
            }
            return greater;
        }
    }

    public static class LessOrEqual
    extends SizeDomain {
        public LessOrEqual(@NotNull Domain delegate, int size) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/data/types/domain/CustomSuitabilityDomain$LessOrEqual", "<init>"));
            }
            super(delegate, size);
        }

        @Override
        protected boolean isCustomSuitable(@NotNull ColumnDescriptor descriptor) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/CustomSuitabilityDomain$LessOrEqual", "isCustomSuitable"));
            }
            return this.getSize() >= descriptor.getSize();
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull Domain domain) {
            if (domain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/CustomSuitabilityDomain$LessOrEqual", "narrow"));
            }
            LessOrEqual lessOrEqual = new LessOrEqual(this.getDelegate().narrow(domain), this.getSize());
            if (lessOrEqual == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/CustomSuitabilityDomain$LessOrEqual", "narrow"));
            }
            return lessOrEqual;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull SizeProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/domain/CustomSuitabilityDomain$LessOrEqual", "narrow"));
            }
            LessOrEqual lessOrEqual = new LessOrEqual(this.getDelegate().narrow(provider), this.getSize());
            if (lessOrEqual == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/CustomSuitabilityDomain$LessOrEqual", "narrow"));
            }
            return lessOrEqual;
        }
    }

    public static abstract class SizeDomain
    extends CustomSuitabilityDomain {
        private final int mySize;

        public SizeDomain(@NotNull Domain delegate, int size) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/data/types/domain/CustomSuitabilityDomain$SizeDomain", "<init>"));
            }
            super(delegate);
            this.mySize = size;
        }

        protected final int getSize() {
            return this.mySize;
        }
    }
}

