/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Domain {
    public static final Domain EMPTY = new Domain(ConversionPoint.UNKNOWN, PhysicalDomainType.UNKNOWN, ""){

        @Override
        @NotNull
        public Cardinality cardinality() {
            Cardinality cardinality = Cardinality.EMPTY;
            if (cardinality == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Domain$1", "cardinality"));
            }
            return cardinality;
        }

        @Override
        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/Domain$1", "getCompatibility"));
            }
            Compatibility compatibility = Compatibility.uncompatible();
            if (compatibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Domain$1", "getCompatibility"));
            }
            return compatibility;
        }

        @Override
        @Nullable
        public Object trim(@NotNull Object o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/Domain$1", "trim"));
            }
            return o;
        }
    };
    private final ConversionPoint myPoint;
    private final PhysicalDomainType myDomainType;
    private final String myName;

    protected Domain(@NotNull ConversionPoint point, @NotNull PhysicalDomainType type, @NotNull String name) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/database/data/types/domain/Domain", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/data/types/domain/Domain", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/Domain", "<init>"));
        }
        this.myPoint = point;
        this.myDomainType = type;
        this.myName = name;
    }

    @NotNull
    public PhysicalDomainType getDomainType() {
        PhysicalDomainType physicalDomainType = this.myDomainType;
        if (physicalDomainType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Domain", "getDomainType"));
        }
        return physicalDomainType;
    }

    @NotNull
    public ConversionPoint getPoint() {
        ConversionPoint conversionPoint = this.myPoint;
        if (conversionPoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Domain", "getPoint"));
        }
        return conversionPoint;
    }

    public boolean contains(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/Domain", "contains"));
        }
        return this.getCompatibility(domain).isCanContains();
    }

    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/Domain", "narrow"));
        }
        Domain domain2 = this;
        if (domain2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Domain", "narrow"));
        }
        return domain2;
    }

    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/domain/Domain", "narrow"));
        }
        Domain domain = this;
        if (domain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Domain", "narrow"));
        }
        return domain;
    }

    @NotNull
    public String name() {
        String string = this.simpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Domain", "name"));
        }
        return string;
    }

    @NotNull
    public String simpleName() {
        String string = StringUtil.toUpperCase((String)this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Domain", "simpleName"));
        }
        return string;
    }

    public String toString() {
        return this.myName + " " + this.getPoint() + " " + (Object)((Object)this.getDomainType());
    }

    public boolean isSuitable(@NotNull ColumnDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/Domain", "isSuitable"));
        }
        return StringUtil.equalsIgnoreCase((CharSequence)this.myName, (CharSequence)StringUtil.toLowerCase((String)descriptor.getTypeName()));
    }

    @NotNull
    public LogicalType getLogicType() {
        LogicalType logicalType = this.getPoint().getLogicalType();
        if (logicalType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Domain", "getLogicType"));
        }
        return logicalType;
    }

    @NotNull
    public abstract Cardinality cardinality();

    @NotNull
    public abstract Compatibility getCompatibility(@NotNull Domain var1);

    @Nullable
    public abstract Object trim(@NotNull Object var1);
}

