/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDomain
extends Domain {
    private final Cardinality.TextCardinality myCardinality;
    private final long myDefaultValue;
    private final boolean myNarrowable;
    private final long myLength;

    public TextDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long maxLength) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/TextDomain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/TextDomain", "<init>"));
        }
        this(name, descriptor, maxLength, -1L, false);
    }

    /*
     * WARNING - void declaration
     */
    public TextDomain(@NotNull String name, @NotNull ConversionPoint descriptor, long maxLength, long defaultValue, boolean bl) {
        void narrowable;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/TextDomain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/TextDomain", "<init>"));
        }
        super(descriptor, PhysicalDomainType.TEXT, name);
        this.myLength = maxLength;
        this.myCardinality = new Cardinality.TextCardinality(maxLength);
        this.myDefaultValue = defaultValue;
        this.myNarrowable = narrowable;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/TextDomain", "getCompatibility"));
        }
        Compatibility compatibility = domain instanceof BinaryDomain ? this.compareWithLength((BinaryDomain)domain) : (domain instanceof TextDomain ? (((TextDomain)domain).myLength <= this.myLength ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType())) : Compatibility.uncompatibleLossless(this.cardinality(), TextDomain.getLogicalType(domain), this.getLogicType()));
        if (compatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/TextDomain", "getCompatibility"));
        }
        return compatibility;
    }

    @NotNull
    private static LogicalType getLogicalType(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/TextDomain", "getLogicalType"));
        }
        LogicalType logicalType = domain instanceof TextPreferrable ? ((TextPreferrable)((Object)domain)).getFakeType() : domain.getLogicType();
        if (logicalType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/TextDomain", "getLogicalType"));
        }
        return logicalType;
    }

    @NotNull
    private Compatibility compareWithLength(@NotNull BinaryDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/TextDomain", "compareWithLength"));
        }
        Compatibility compatibility = domain.getUpperBound() <= this.getLength() ? Compatibility.uncompatibleLossless(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.uncompatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType());
        if (compatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/TextDomain", "compareWithLength"));
        }
        return compatibility;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.TextCardinality textCardinality = this.myCardinality;
        if (textCardinality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/TextDomain", "cardinality"));
        }
        return textCardinality;
    }

    public long getLength() {
        return this.myLength;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/TextDomain", "trim"));
        }
        return this.getLength() != 0L && o instanceof String ? ((String)o).substring(0, (int)Math.min(this.getLength(), (long)((String)o).length())) : o;
    }

    public long getDefaultValue() {
        return this.myDefaultValue;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/TextDomain", "narrow"));
        }
        TextDomain textDomain = this.myNarrowable && domain instanceof TextDomain ? new TextDomain(this.simpleName(), this.getPoint(), Math.min(((TextDomain)domain).getLength(), this.getLength()), this.myDefaultValue, true) : this;
        if (textDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/TextDomain", "narrow"));
        }
        return textDomain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/domain/TextDomain", "narrow"));
        }
        TextDomain textDomain = this.myNarrowable ? new TextDomain(this.simpleName(), this.getPoint(), Math.min((long)provider.getSize(), this.getLength()), this.myDefaultValue, true) : this;
        if (textDomain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/TextDomain", "narrow"));
        }
        return textDomain;
    }

    @Override
    @NotNull
    public String name() {
        String string = this.myLength == this.myDefaultValue || !this.myNarrowable || this.getLength() <= 0L ? super.name() : this.simpleName() + "(" + this.getLength() + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/TextDomain", "name"));
        }
        return string;
    }

    public static interface TextPreferrable {
        @NotNull
        public LogicalType getFakeType();
    }
}

