/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.google.common.primitives.Bytes;
import com.intellij.coding.CompositeText;
import com.intellij.coding.SimpleCompositeText;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchemaObject;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.impl.BlackHoleTextStorage;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.scripting.ScriptingFactory;
import com.intellij.database.scripting.ScriptingService;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TByteArrayList;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSrcBridge
implements ModelTextStorage {
    private static final CountedThreadExecutor ourStorageWriter = new CountedThreadExecutor(10);
    private static final Logger LOG = Logger.getInstance(DataSourceSrcBridge.class);
    private final ScriptingFactory myScriptingFactory;
    private boolean myLayoutInitialized;
    private final DbDataSourceLayout myLayout;
    @Nullable
    private final Project myProject;
    private final SqlLanguageDialect myDialect;
    private final List<DbSrcPath> myRemoveQueue;
    private Couple<DbSrcStorageLayout.WriteSession> mySessions;
    private int myBalanceCheck;
    private volatile Pair<BasicSourceAware, CompositeText> myCurrentSource;

    private DataSourceSrcBridge(@Nullable Project project, @NotNull String dataSourceId) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/DataSourceSrcBridge", "<init>"));
        }
        this.myLayoutInitialized = false;
        this.myRemoveQueue = ContainerUtil.newArrayList();
        this.myBalanceCheck = 0;
        this.myCurrentSource = null;
        DbSrcStorage storage = DbSrcStorage.getInstance(project);
        this.myLayout = storage.getLayout(dataSourceId);
        this.myProject = project;
        this.myDialect = this.findDialect();
        this.myScriptingFactory = (ScriptingFactory)ServiceManager.getService(ScriptingFactory.class);
    }

    private void ensureLayoutInitialized() {
        if (this.myLayoutInitialized) {
            return;
        }
        this.myLayoutInitialized = true;
        try {
            this.myLayout.initForce(this.myDialect);
        }
        catch (IOException e) {
            LOG.warn("Storage initialization failed", (Throwable)e);
        }
    }

    @Override
    public synchronized void save(@NotNull BasicSourceAware object, @Nullable CompositeText text) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge", "save"));
        }
        if (this.myBalanceCheck <= 0) {
            LOG.error("ModelTextStorage.beginWrite should be called");
        }
        if (this.mySessions == null) {
            this.initSessions();
        }
        this.flushDeleteQueue();
        DbSrcPath srcPath = DbSrcPath.of(object);
        Couple<DbSrcStorageLayout.WriteSession> sessions = this.mySessions;
        if (text == null) {
            this.dropMetadata(srcPath);
            ourStorageWriter.execute(() -> this.processDelete(sessions, srcPath));
        } else {
            CompositeText generated = this.generate(object, text);
            ourStorageWriter.execute(() -> this.processSave(sessions, srcPath, generated));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CompositeText generate(@NotNull BasicSourceAware object, @NotNull CompositeText text) {
        CompositeText compositeText;
        BasicSchemaObject so;
        BasicModel model;
        block11: {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge", "generate"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/DataSourceSrcBridge", "generate"));
            }
            this.myCurrentSource = Pair.create((Object)object, (Object)text);
            model = object.getModel();
            so = (BasicSchemaObject)ObjectUtils.tryCast((Object)object, BasicSchemaObject.class);
            if (model != null && so != null) break block11;
            CompositeText compositeText2 = text;
            this.myCurrentSource = null;
            CompositeText compositeText3 = compositeText2;
            if (compositeText3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "generate"));
            }
            return compositeText3;
        }
        try {
            ScriptingService service = this.myScriptingFactory.createScriptingService(model, null, null);
            service.makeScript(ScriptingTask.CREATE_COMPLETE, Collections.singleton(so), false);
            CompositeText compositeText4 = service.getScript();
            this.myCurrentSource = null;
            compositeText = compositeText4;
        }
        catch (Throwable e) {
            CompositeText compositeText5;
            try {
                LOG.warn("Code generation failed", e);
                CompositeText compositeText6 = text;
                compositeText5 = compositeText6;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.myCurrentSource = null;
            }
            if (compositeText5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "generate"));
            }
            return compositeText5;
        }
        if (compositeText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "generate"));
        }
        return compositeText;
    }

    private void initSessions() {
        if (this.mySessions != null) {
            throw new AssertionError((Object)"Session already initialized");
        }
        this.mySessions = Couple.of((Object)this.myLayout.createWriteSession(true), (Object)this.myLayout.createWriteSession(false));
        ourStorageWriter.acquire();
    }

    private void flushDeleteQueue() {
        if (this.mySessions == null) {
            throw new AssertionError((Object)"Session should be initialized");
        }
        if (this.myRemoveQueue.isEmpty()) {
            return;
        }
        ArrayList toRemove = ContainerUtil.newArrayList(this.myRemoveQueue);
        this.myRemoveQueue.clear();
        Couple<DbSrcStorageLayout.WriteSession> sessions = this.mySessions;
        ourStorageWriter.execute(() -> this.runWriteAction(() -> {
            for (DbSrcPath path : toRemove) {
                try {
                    this.processDelete(sessions, path);
                }
                catch (Throwable e) {
                    LOG.warn(e);
                }
            }
        }));
    }

    @Override
    public synchronized void queueDelete(@NotNull BasicSourceAware object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge", "queueDelete"));
        }
        if (this.mySessions == null) {
            DbSrcPath srcPath = DbSrcPath.of(object);
            this.dropMetadata(srcPath);
            this.myRemoveQueue.add(srcPath);
        } else {
            this.save(object, null);
        }
    }

    @Override
    public synchronized void processDeleteQueue() {
        this.beginWrite();
        this.endWrite();
    }

    @Override
    public void waitForWriteFinished() {
        if (!ourStorageWriter.isRunning()) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        ourStorageWriter.acquire();
        try {
            ourStorageWriter.execute(latch::countDown);
        }
        finally {
            ourStorageWriter.release();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public synchronized void beginWrite() {
        ++this.myBalanceCheck;
    }

    @Override
    public synchronized void endWrite() {
        --this.myBalanceCheck;
        if (this.myBalanceCheck != 0) {
            return;
        }
        if (this.mySessions == null) {
            if (this.myRemoveQueue.isEmpty()) {
                return;
            }
            this.initSessions();
            this.flushDeleteQueue();
        }
        Couple<DbSrcStorageLayout.WriteSession> sessions = this.mySessions;
        this.mySessions = null;
        ourStorageWriter.execute(() -> this.processCloseSessions(sessions));
        ourStorageWriter.release();
    }

    private void processCloseSessions(@NotNull Couple<DbSrcStorageLayout.WriteSession> sessions) {
        if (sessions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/DataSourceSrcBridge", "processCloseSessions"));
        }
        this.runWriteAction(() -> {
            if (sessions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$processCloseSessions$5"));
            }
            try {
                ((DbSrcStorageLayout.WriteSession)sessions.first).close();
            }
            catch (IOException e) {
                LOG.warn("Error closing session", (Throwable)e);
            }
            try {
                ((DbSrcStorageLayout.WriteSession)sessions.second).close();
            }
            catch (IOException e) {
                LOG.warn("Error closing session", (Throwable)e);
            }
        });
        DbSrcUtils.refresh();
    }

    private void runWriteAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/DataSourceSrcBridge", "runWriteAction"));
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            app.runWriteAction(runnable);
        } else {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                if (runnable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$runWriteAction$9"));
                }
                ModalityState current = ModalityState.current();
                TransactionGuardImpl guard = (TransactionGuardImpl)TransactionGuard.getInstance();
                TransactionGuardImpl.TransactionIdImpl context = guard.getModalityTransaction(current);
                guard.wrapLaterInvocation(() -> this.lambda$null$8(guard, app, (TransactionId)context, runnable), current).run();
            });
        }
    }

    @NotNull
    private Project getAnyProject() {
        if (this.myProject != null && !this.myProject.isDisposed()) {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "getAnyProject"));
            }
            return project;
        }
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        Project project = projects.length != 0 ? projects[0] : ProjectManager.getInstance().getDefaultProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "getAnyProject"));
        }
        return project;
    }

    @NotNull
    private SqlLanguageDialect findDialect() {
        Project project = this.getAnyProject();
        LocalDataSource dataSource = DbSrcUtils.findDataSource(project, this.myLayout.getDataSourceId());
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(project, dataSource);
        if (sqlLanguageDialect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "findDialect"));
        }
        return sqlLanguageDialect;
    }

    private void dropMetadata(@NotNull DbSrcPath srcPath) {
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/DataSourceSrcBridge", "dropMetadata"));
        }
        this.myLayout.putMetaData(srcPath, null);
    }

    private void processDelete(@NotNull Couple<DbSrcStorageLayout.WriteSession> sessions, @NotNull DbSrcPath srcPath) {
        if (sessions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/DataSourceSrcBridge", "processDelete"));
        }
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/DataSourceSrcBridge", "processDelete"));
        }
        DbSrcStorageLayout.Item baseItem = this.myLayout.getPath(srcPath, false);
        DbSrcStorageLayout.Item stagingItem = this.myLayout.getPath(srcPath, true);
        this.runWriteAction(() -> {
            boolean stagingFileExists;
            if (srcPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$processDelete$10"));
            }
            if (sessions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$processDelete$10"));
            }
            boolean bl = stagingFileExists = stagingItem != null && stagingItem.getSrcAttributes() != null;
            if (stagingFileExists) {
                DbSrcChangesTracker.markFileDirty(DbSrcFileSystem.getInstance().findFileByPath(DbSrcFileSystem.getPath(this.myProject, this.myLayout.getDataSourceId(), srcPath, true)));
            }
            try {
                if (baseItem != null) {
                    baseItem.delete(this, (DbSrcStorageLayout.WriteSession)sessions.second);
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        });
        this.dropMetadata(srcPath);
    }

    @NotNull
    private PersistentMarkup format(@NotNull DbSrcPath srcPath, @NotNull CompositeText text) {
        PersistentMarkup persistentMarkup;
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/DataSourceSrcBridge", "format"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/DataSourceSrcBridge", "format"));
        }
        try {
            Project project = this.getAnyProject();
            DocumentImpl document = new DocumentImpl((CharSequence)"", true);
            ArrayList ranges = ContainerUtil.newArrayList();
            for (CompositeText.Fragment fragment : text.getFragments()) {
                int start = document.getTextLength();
                document.insertString(start, (CharSequence)StringUtil.convertLineSeparators((String)fragment.getText().toString()));
                int end = document.getTextLength();
                CompositeText.Kind kind = fragment.getKind();
                RangeMarker marker = kind.getReformattable() ? document.createRangeMarker(start, end) : document.createGuardedBlock(start, end);
                ranges.add(Pair.create((Object)marker, (Object)((Object)kind)));
            }
            SqlPsiFacade.getInstance((Project)project).format(project, this.myDialect, (Document)document);
            PersistentMarkup.Builder builder = new PersistentMarkup.Builder();
            for (Pair range : ranges) {
                if (!((RangeMarker)range.first).isValid()) {
                    LOG.warn("Range marker died during formatting");
                    continue;
                }
                builder.add((CompositeText.Kind)((Object)range.second), ((RangeMarker)range.first).getStartOffset(), ((RangeMarker)range.first).getEndOffset());
            }
            persistentMarkup = builder.build(document.getText());
        }
        catch (Throwable e) {
            LOG.warn("Formatting for " + srcPath + " failed, passing unformatted", e);
            PersistentMarkup.Builder builder = new PersistentMarkup.Builder();
            for (CompositeText.Fragment f : text.getFragments()) {
                builder.add(f.getKind(), f.getBegin(), f.getEnd());
            }
            PersistentMarkup persistentMarkup2 = builder.build(text.getText());
            if (persistentMarkup2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "format"));
            }
            return persistentMarkup2;
        }
        if (persistentMarkup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "format"));
        }
        return persistentMarkup;
    }

    private void processSave(@NotNull Couple<DbSrcStorageLayout.WriteSession> sessions, @NotNull DbSrcPath srcPath, @NotNull CompositeText text) {
        if (sessions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/DataSourceSrcBridge", "processSave"));
        }
        if (srcPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/DataSourceSrcBridge", "processSave"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/DataSourceSrcBridge", "processSave"));
        }
        PersistentMarkup sql = this.format(srcPath, text);
        DbSrcStorageDsMetadata.MetaData data = this.myLayout.getMetaData(srcPath);
        DbSrcStorageDsMetadata.MetaData expected = sql.getExpectedMetaData(data);
        this.runWriteAction(() -> {
            if (srcPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPath", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$processSave$11"));
            }
            if (sessions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessions", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$processSave$11"));
            }
            this.ensureLayoutInitialized();
            boolean skipWrite = Comparing.equal((Object)data, (Object)expected);
            DbSrcStorageLayout.Item item = this.myLayout.getPath(srcPath, false);
            if (item == null) {
                LOG.warn("Uninitialized storage");
                return;
            }
            if (skipWrite &= item.getSrcAttributes() != null) {
                return;
            }
            try (OutputStreamWriter out = new OutputStreamWriter(item.getOutputStream(this, (DbSrcStorageLayout.WriteSession)sessions.second), CharsetToolkit.UTF8_CHARSET);){
                ((Writer)out).append(sql.getText());
                this.myLayout.putMetaData(srcPath, expected);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        });
    }

    @Override
    @Nullable
    public CompositeText load(@NotNull BasicSourceAware object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge", "load"));
        }
        if (this.myCurrentSource != null && this.myCurrentSource.first == object) {
            return (CompositeText)this.myCurrentSource.second;
        }
        DbSrcPath srcPath = DbSrcPath.of(object);
        DbSrcStorageLayout.Item item = this.myLayout.getPath(srcPath, false);
        if (item == null) {
            return null;
        }
        String text = DbSrcFileStatus.getContent(item.getSrcFile());
        if (text == null) {
            return null;
        }
        DbSrcStorageDsMetadata.MetaData md = this.myLayout.getMetaData(srcPath);
        boolean noRanges = md == null || md.kinds == null || md.kinds.length == 0;
        return noRanges ? new SimpleCompositeText(text, CompositeText.Kind.ORIGINAL_TEXT) : new PersistentMarkup(text, md.offsets, md.kinds);
    }

    @Override
    public boolean hasExistingSources(@NotNull BasicElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dataSource/DataSourceSrcBridge", "hasExistingSources"));
        }
        DbSrcPath srcPath = DbSrcPath.of(element);
        DbSrcStorageLayout.Item item = this.myLayout.getPath(srcPath, false);
        if (item == null) {
            return false;
        }
        if (item.hasChildren()) {
            return true;
        }
        if (!(element instanceof BasicSourceAware)) {
            return false;
        }
        return item.getSrcAttributes() != null;
    }

    @Override
    public Long getVersion(@NotNull BasicElement object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge", "getVersion"));
        }
        DbSrcPath srcPath = DbSrcPath.of(object);
        DbSrcStorageDsMetadata.MetaData data = this.myLayout.getMetaData(srcPath);
        return data == null ? null : data.srcVersion;
    }

    @Override
    public void setVersion(@NotNull BasicElement object, Long version) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/DataSourceSrcBridge", "setVersion"));
        }
        DbSrcPath srcPath = DbSrcPath.of(object);
        DbSrcStorageDsMetadata.MetaData data = this.myLayout.getMetaData(srcPath);
        this.myLayout.putMetaData(srcPath, DbSrcStorageDsMetadata.MetaData.modSrcVersion(data, version));
    }

    @NotNull
    public static ModelFactory createFactory(@Nullable Project project, @NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/DataSourceSrcBridge", "createFactory"));
        }
        ModelFactory modelFactory = DataSourceSrcBridge.createFactory(dataSource.isGlobal() ? null : project, dataSource.getUniqueId());
        if (modelFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "createFactory"));
        }
        return modelFactory;
    }

    @NotNull
    public static ModelFactory createFactory(@Nullable Project project, @Nullable String dataSourceId) {
        ModelFactory modelFactory = new ModelFactory(DbSrcStorage.isEnabled() && dataSourceId != null ? new DataSourceSrcBridge(project, dataSourceId) : BlackHoleTextStorage.INSTANCE);
        if (modelFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge", "createFactory"));
        }
        return modelFactory;
    }

    private /* synthetic */ void lambda$null$8(TransactionGuardImpl guard, Application app, TransactionId context, @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$null$8"));
        }
        guard.submitTransaction((Disposable)(this.myProject == null ? app : this.myProject), context, () -> {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$null$7"));
            }
            WriteAction.run(() -> {
                if (runnable == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/DataSourceSrcBridge", "lambda$null$6"));
                }
                runnable.run();
            });
        });
    }

    public static class PersistentMarkup
    implements CompositeText {
        private final CharSequence myText;
        private final int[] myOffsets;
        private final byte[] myKinds;

        private PersistentMarkup(@NotNull CharSequence text, @NotNull int[] offsets, @NotNull byte[] kinds) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/DataSourceSrcBridge$PersistentMarkup", "<init>"));
            }
            if (offsets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offsets", "com/intellij/database/dataSource/DataSourceSrcBridge$PersistentMarkup", "<init>"));
            }
            if (kinds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/database/dataSource/DataSourceSrcBridge$PersistentMarkup", "<init>"));
            }
            assert (offsets.length == kinds.length);
            this.myText = text;
            this.myOffsets = offsets;
            this.myKinds = kinds;
        }

        @Override
        @NotNull
        public Iterable<CompositeText.Fragment> getFragments() {
            Iterable<CompositeText.Fragment> iterable = () -> new JBIterator<CompositeText.Fragment>(){
                int i = 0;

                protected CompositeText.Fragment nextImpl() {
                    return this.i < myOffsets.length ? this.createFragment(this.i++) : (CompositeText.Fragment)this.stop();
                }
            };
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge$PersistentMarkup", "getFragments"));
            }
            return iterable;
        }

        @Override
        @NotNull
        public CharSequence getText() {
            CharSequence charSequence = this.myText;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge$PersistentMarkup", "getText"));
            }
            return charSequence;
        }

        public String toString() {
            return this.getText().toString();
        }

        @Override
        @Nullable
        public CompositeText.Fragment first(@NotNull CompositeText.Kind kind) {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/dataSource/DataSourceSrcBridge$PersistentMarkup", "first"));
            }
            int idx = Bytes.indexOf((byte[])this.myKinds, (byte)((byte)kind.ordinal()));
            return idx < 0 ? null : this.createFragment(idx);
        }

        @Override
        @Nullable
        public CompositeText.Fragment getContent() {
            int idx = Bytes.indexOf((byte[])this.myKinds, (byte)((byte)CompositeText.Kind.ORIGINAL_TEXT.ordinal()));
            if (idx < 0) {
                idx = Bytes.indexOf((byte[])this.myKinds, (byte)((byte)CompositeText.Kind.DECOMPILED_TEXT.ordinal()));
            }
            return idx < 0 ? null : this.createFragment(idx);
        }

        @NotNull
        private CompositeText.Fragment createFragment(final int idx) {
            CompositeText.Fragment fragment = new CompositeText.Fragment(){

                @Override
                @NotNull
                public CharSequence getText() {
                    int from = this.getBegin();
                    int to = this.getEnd();
                    int len = myText.length();
                    CharSequence charSequence = myText.subSequence(Math.min(from, len), Math.min(Math.max(to, from), len));
                    if (charSequence == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge$PersistentMarkup$2", "getText"));
                    }
                    return charSequence;
                }

                @Override
                @NotNull
                public CompositeText.Kind getKind() {
                    CompositeText.Kind[] v = CompositeText.Kind.values();
                    short k = myKinds[idx];
                    CompositeText.Kind kind = k < v.length ? v[k] : CompositeText.Kind.PLAIN_TEXT;
                    if (kind == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge$PersistentMarkup$2", "getKind"));
                    }
                    return kind;
                }

                @Override
                public int getBegin() {
                    return idx == 0 ? 0 : myOffsets[idx - 1];
                }

                @Override
                public int getEnd() {
                    return myOffsets[idx];
                }

                @Override
                public int getLength() {
                    return this.getEnd() - this.getBegin();
                }
            };
            if (fragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge$PersistentMarkup", "createFragment"));
            }
            return fragment;
        }

        @NotNull
        public DbSrcStorageDsMetadata.MetaData getExpectedMetaData(@Nullable DbSrcStorageDsMetadata.MetaData md) {
            if (md == null) {
                md = DbSrcStorageDsMetadata.MetaData.EMPTY;
            }
            DbSrcStorageDsMetadata.MetaData metaData = new DbSrcStorageDsMetadata.MetaData(md.srcVersion, DbSrcUtils.hashCode(this.myText), this.myOffsets, this.myKinds);
            if (metaData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceSrcBridge$PersistentMarkup", "getExpectedMetaData"));
            }
            return metaData;
        }

        public static class Builder {
            private final TByteArrayList kinds = new TByteArrayList();
            private final TIntArrayList offsets = new TIntArrayList();

            public void add(CompositeText.Kind k, int o) {
                if (o == 0 || !this.offsets.isEmpty() && this.offsets.get(this.offsets.size() - 1) == o) {
                    return;
                }
                int sz = this.kinds.size();
                byte ord = Builder.ord(k);
                if (k == CompositeText.Kind.PLAIN_TEXT && sz > 0 && this.kinds.get(sz - 1) == ord) {
                    this.offsets.set(sz - 1, o);
                } else {
                    this.offsets.add(o);
                    this.kinds.add(ord);
                }
            }

            public void add(CompositeText.Kind k, int from, int to) {
                this.add(CompositeText.Kind.PLAIN_TEXT, from);
                this.add(k, to);
            }

            public void clear() {
                this.kinds.clear();
                this.offsets.clear();
            }

            private static byte ord(CompositeText.Kind k) {
                return (byte)k.ordinal();
            }

            public PersistentMarkup build(CharSequence text) {
                return new PersistentMarkup(text, this.offsets.toNativeArray(), this.kinds.toNativeArray());
            }
        }
    }

    private static class CountedThreadExecutor
    implements Executor {
        private final Logger LOG = Logger.getInstance(CountedThreadExecutor.class);
        private final BlockingQueue<Runnable> myQueue = new LinkedBlockingQueue<Runnable>(100);
        private final int myTimeoutSec;
        private volatile int myRefCount = 0;
        private volatile boolean myRunning = false;

        private CountedThreadExecutor(int timeoutSec) {
            this.myTimeoutSec = timeoutSec;
        }

        public boolean isRunning() {
            return this.myRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            BlockingQueue<Runnable> blockingQueue = this.myQueue;
            synchronized (blockingQueue) {
                ++this.myRefCount;
                if (!this.myRunning) {
                    this.myRunning = true;
                    ApplicationManager.getApplication().executeOnPooledThread(this::processQueue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            BlockingQueue<Runnable> blockingQueue = this.myQueue;
            synchronized (blockingQueue) {
                assert (this.myRefCount > 0);
                assert (this.myRunning);
                --this.myRefCount;
            }
        }

        @Override
        public void execute(@NotNull Runnable command) {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dataSource/DataSourceSrcBridge$CountedThreadExecutor", "execute"));
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                throw new AssertionError((Object)"Operation not allowed from EDT");
            }
            assert (this.myRefCount > 0);
            assert (this.myRunning);
            try {
                this.myQueue.put(command);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueue() {
            block25: {
                boolean running = true;
                block19: while (true) {
                    try {
                        while (true) {
                            Runnable task;
                            if ((task = this.myQueue.poll(this.myTimeoutSec, TimeUnit.SECONDS)) == null) {
                                BlockingQueue<Runnable> blockingQueue = this.myQueue;
                                synchronized (blockingQueue) {
                                    if (this.myQueue.isEmpty() && this.myRefCount == 0) {
                                        running = false;
                                        this.myRunning = false;
                                        break block25;
                                    }
                                    continue block19;
                                }
                            }
                            try {
                                task.run();
                                continue block19;
                            }
                            catch (Throwable e2) {
                                this.LOG.warn(e2);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        BlockingQueue<Runnable> e2 = this.myQueue;
                        synchronized (e2) {
                            running = false;
                            this.myRunning = false;
                        }
                        Thread.currentThread().interrupt();
                        break block25;
                    }
                }
                finally {
                    if (running) {
                        BlockingQueue<Runnable> blockingQueue = this.myQueue;
                        synchronized (blockingQueue) {
                            Application app = ApplicationManager.getApplication();
                            if (this.myRunning) {
                                this.LOG.warn("DbSrcWriter accidentally stopped, rescheduling...");
                                app.invokeLater(() -> app.executeOnPooledThread(this::processQueue), app.getDisposed());
                            }
                        }
                    }
                    this.LOG.info("DbSrcWriter stopped");
                }
            }
        }
    }
}

