/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DataSourceExplainPlanConfiguration;
import com.intellij.database.dataSource.DataSourceSrcBridge;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.DefaultsInstaller;
import com.intellij.database.dataSource.LegacyDeserializer;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.ui.LocalDbParamEditor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicModelListener;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.serialization.ModelSerializer;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.dbm.common.IntrospectionScopes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.JDomReader;
import com.thoughtworks.xstream.io.xml.JDomWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import icons.DatabaseIcons;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDataSource
extends AbstractDataSource
implements RawConnectionConfig,
Iconable {
    static final Logger LOG = Logger.getInstance((String)"com.intellij.database.dataSource.LocalDataSource");
    public static final String ELEMENT_NAME = "data-source";
    public static final String MY_ELEMENT_FLAG = "LOCAL";
    public static final String SSH_HOST = "localhost";
    static final String MASTER_KEY = "MASTER_KEY";
    private static final String LIBRARIES_ELEMENT_NAME = "libraries";
    private static final String LIBRARY_ELEMENT_NAME = "library";
    private static final String USER_KEY = "user";
    private static final String PASSWORD_KEY = "password";
    private final DataSource.Info myInfo;
    @NotNull
    private volatile DasModel myModel;
    private boolean myLoading;
    private AtomicInteger myBatchCounter;
    private DatabaseDriver myDriver;
    private String myDriverClass;
    private String myUrl;
    private boolean mySecretStorage;
    private String myUsername;
    private String myEncodedPassword;
    @Deprecated
    public IntrospectionScope myResolveScope;
    private IntrospectionScope myIntrospectionScope;
    private String myTablePattern;
    private boolean myUseLegacyIntrospector;
    private DBIntrospectionOptions.SourceLoading mySourceLoading;
    private String myDefaultDialect;
    @Nullable
    private String myVmOptions;
    @NotNull
    private Map<String, String> myVmEnv;
    private final Map<String, String> myDriverProperties;
    @Deprecated
    private final List<SimpleClasspathElement> myClasspathElements;
    private boolean myAutoSynchronize;
    private boolean myAutoCommit;
    private boolean myDomainAuthentication;
    private ThreeState myFirstSync;
    private boolean myConfiguredByUrl;
    private DataSourceSshTunnelConfiguration mySshConfiguration;
    private DataSourceSslConfiguration mySslCfg;
    @NotNull
    private DataSourceExplainPlanConfiguration myExplainPlanConfiguration;
    private Map<String, String> myAdditionalJdbcProperties;
    private boolean myAuthRequired;
    private boolean myImported;
    private final EventDispatcher<Listener> myDispatcher;
    private final BasicModelListener myModelListener;

    public LocalDataSource() {
        this.myInfo = new DataSource.Info();
        this.myModel = DasUtil.emptyModel();
        this.myLoading = false;
        this.myBatchCounter = new AtomicInteger();
        this.myResolveScope = IntrospectionScopes.EMPTY_SCOPE;
        this.myIntrospectionScope = IntrospectionScopes.EMPTY_SCOPE;
        this.mySourceLoading = DBIntrospectionOptions.SourceLoading.USER_SOURCES;
        this.myVmEnv = ContainerUtil.newLinkedHashMap();
        this.myDriverProperties = ContainerUtil.newLinkedHashMap();
        this.myClasspathElements = ContainerUtil.newArrayList();
        this.myAutoCommit = true;
        this.myFirstSync = ThreeState.UNSURE;
        this.myConfiguredByUrl = false;
        this.myExplainPlanConfiguration = new DataSourceExplainPlanConfiguration();
        this.myAdditionalJdbcProperties = ContainerUtil.newHashMap();
        this.myAuthRequired = true;
        this.myImported = false;
        this.myDispatcher = EventDispatcher.create(Listener.class);
        this.myModelListener = (created, modified, removed) -> this.notifyConsumersThatModelIsUpdated();
    }

    public LocalDataSource(boolean imported) {
        this.myInfo = new DataSource.Info();
        this.myModel = DasUtil.emptyModel();
        this.myLoading = false;
        this.myBatchCounter = new AtomicInteger();
        this.myResolveScope = IntrospectionScopes.EMPTY_SCOPE;
        this.myIntrospectionScope = IntrospectionScopes.EMPTY_SCOPE;
        this.mySourceLoading = DBIntrospectionOptions.SourceLoading.USER_SOURCES;
        this.myVmEnv = ContainerUtil.newLinkedHashMap();
        this.myDriverProperties = ContainerUtil.newLinkedHashMap();
        this.myClasspathElements = ContainerUtil.newArrayList();
        this.myAutoCommit = true;
        this.myFirstSync = ThreeState.UNSURE;
        this.myConfiguredByUrl = false;
        this.myExplainPlanConfiguration = new DataSourceExplainPlanConfiguration();
        this.myAdditionalJdbcProperties = ContainerUtil.newHashMap();
        this.myAuthRequired = true;
        this.myImported = false;
        this.myDispatcher = EventDispatcher.create(Listener.class);
        this.myModelListener = (created, modified, removed) -> this.notifyConsumersThatModelIsUpdated();
        this.myImported = imported;
    }

    public LocalDataSource(@NotNull DatabaseDriver driver, @NotNull String url) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/LocalDataSource", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/LocalDataSource", "<init>"));
        }
        this.myInfo = new DataSource.Info();
        this.myModel = DasUtil.emptyModel();
        this.myLoading = false;
        this.myBatchCounter = new AtomicInteger();
        this.myResolveScope = IntrospectionScopes.EMPTY_SCOPE;
        this.myIntrospectionScope = IntrospectionScopes.EMPTY_SCOPE;
        this.mySourceLoading = DBIntrospectionOptions.SourceLoading.USER_SOURCES;
        this.myVmEnv = ContainerUtil.newLinkedHashMap();
        this.myDriverProperties = ContainerUtil.newLinkedHashMap();
        this.myClasspathElements = ContainerUtil.newArrayList();
        this.myAutoCommit = true;
        this.myFirstSync = ThreeState.UNSURE;
        this.myConfiguredByUrl = false;
        this.myExplainPlanConfiguration = new DataSourceExplainPlanConfiguration();
        this.myAdditionalJdbcProperties = ContainerUtil.newHashMap();
        this.myAuthRequired = true;
        this.myImported = false;
        this.myDispatcher = EventDispatcher.create(Listener.class);
        this.myModelListener = (created, modified, removed) -> this.notifyConsumersThatModelIsUpdated();
        this.myDriver = driver;
        this.myUrl = url;
        this.myConfiguredByUrl = this.checkUrlOnly();
        this.myDriverClass = this.myDriver.getDriverClass();
        this.myDriverProperties.putAll(this.myDriver.getDriverProperties());
        this.mySecretStorage = true;
        this.correctExplainPlanProvider();
    }

    public LocalDataSource(String name, String driver, String url, String uid, String pwd) {
        this.myInfo = new DataSource.Info();
        this.myModel = DasUtil.emptyModel();
        this.myLoading = false;
        this.myBatchCounter = new AtomicInteger();
        this.myResolveScope = IntrospectionScopes.EMPTY_SCOPE;
        this.myIntrospectionScope = IntrospectionScopes.EMPTY_SCOPE;
        this.mySourceLoading = DBIntrospectionOptions.SourceLoading.USER_SOURCES;
        this.myVmEnv = ContainerUtil.newLinkedHashMap();
        this.myDriverProperties = ContainerUtil.newLinkedHashMap();
        this.myClasspathElements = ContainerUtil.newArrayList();
        this.myAutoCommit = true;
        this.myFirstSync = ThreeState.UNSURE;
        this.myConfiguredByUrl = false;
        this.myExplainPlanConfiguration = new DataSourceExplainPlanConfiguration();
        this.myAdditionalJdbcProperties = ContainerUtil.newHashMap();
        this.myAuthRequired = true;
        this.myImported = false;
        this.myDispatcher = EventDispatcher.create(Listener.class);
        this.myModelListener = (created, modified, removed) -> this.notifyConsumersThatModelIsUpdated();
        this.setName(name);
        this.setDriverClass(driver);
        this.setUrl(url);
        this.myUsername = uid;
        this.myEncodedPassword = pwd == null ? null : PasswordUtil.encodePassword((String)pwd);
    }

    public static void writeTag(@NotNull HierarchicalStreamWriter serializer, String name, String value) {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/database/dataSource/LocalDataSource", "writeTag"));
        }
        if (StringUtil.isEmpty((String)value)) {
            return;
        }
        serializer.startNode(name);
        serializer.setValue(value);
        serializer.endNode();
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.forDataSource((DatabaseSystem)this);
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @Nullable
    public DatabaseDriver getDatabaseDriver() {
        return this.myDriver;
    }

    public void setDatabaseDriver(@Nullable DatabaseDriver databaseDriver) {
        if (this.myDriver == databaseDriver) {
            return;
        }
        this.myDriver = databaseDriver;
        this.myDriverClass = this.myDriver == null ? null : this.myDriver.getDriverClass();
    }

    @Nullable
    public String getUrl() {
        return this.myUrl;
    }

    public boolean isUseMasterKeyStorage() {
        return this.mySecretStorage;
    }

    public void setUseMasterKeyStorage(boolean useMasterKey) {
        this.mySecretStorage = useMasterKey;
    }

    public String getUsername() {
        return this.myUsername == null ? "" : this.myUsername;
    }

    @Deprecated
    public String getPassword() {
        if (this.myEncodedPassword == null) {
            return "";
        }
        return PasswordUtil.decodePassword((String)this.myEncodedPassword);
    }

    public void setAutoSynchronize(boolean autoSynchronize) {
        this.myAutoSynchronize = autoSynchronize;
    }

    public boolean isAutoSynchronize() {
        return this.myAutoSynchronize;
    }

    public boolean isAutoCommit() {
        return this.myAutoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.myAutoCommit = autoCommit;
    }

    public final Icon getIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.getBaseIcon();
        return ElementBase.createLayeredIcon((Iconable)this, (Icon)icon, (int)(this.isReadOnly() ? 2048 : 0));
    }

    public Icon getBaseIcon() {
        return this.myDriver != null ? this.myDriver.getIcon(0) : DatabaseIcons.Dbms;
    }

    public void resolveDriver() {
        if (this.myDriver == null) {
            DatabaseDriver driver = DbImplUtil.guessDatabaseDriver(this);
            if (driver == null) {
                LOG.warn("Failed to guess driver for data source " + this.getName() + "{" + this.getUniqueId() + "}");
            } else {
                LOG.warn("Guess data source " + this.getName() + "{" + this.getUniqueId() + "} has a " + driver.getName() + "{" + driver.getId() + "} driver");
            }
            this.setDatabaseDriver(driver);
        }
    }

    public boolean ensureDriverConfigured() {
        if (StringUtil.isEmpty((String)this.myDriverClass)) {
            return false;
        }
        if (this.myDriver != null && this.acceptsDriver(this.myDriver)) {
            return true;
        }
        DatabaseDriverManager driverManager = DatabaseDriverManager.getInstance();
        if (this.myDriver != null) {
            for (DatabaseDriver databaseDriver : driverManager.getDrivers()) {
                if (!this.acceptsDriver(databaseDriver)) continue;
                this.myDriver = databaseDriver;
                return true;
            }
            this.myDriver = ((DatabaseDriverImpl)this.myDriver).copy(this.getName() + " driver", false);
        } else {
            this.myDriver = driverManager.createDriver(this.myDriverClass, this.myDriverClass, null);
        }
        ((DatabaseDriverImpl)this.myDriver).setAdditionalClasspathElements(this.myClasspathElements);
        driverManager.updateDriver(this.myDriver);
        return true;
    }

    private boolean acceptsDriver(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/dataSource/LocalDataSource", "acceptsDriver"));
        }
        if (!Comparing.equal((String)this.myDriverClass, (String)driver.getDriverClass())) {
            return false;
        }
        HashSet set = ContainerUtil.newHashSet();
        for (SimpleClasspathElement element : driver.getClasspathElements()) {
            for (String s : element.getClassesRootUrls()) {
                set.add(PathUtil.getFileName((String)s));
            }
        }
        if (set.isEmpty()) {
            ((DatabaseDriverImpl)driver).setAdditionalClasspathElements(this.myClasspathElements);
            return true;
        }
        for (SimpleClasspathElement e : this.myClasspathElements) {
            for (String s : e.getClassesRootUrls()) {
                if (set.contains(PathUtil.getFileName((String)s))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void init() {
        super.init();
        if (this.myDriver == null && this.myDriverClass != null) {
            this.resolveDriver();
        }
    }

    @Override
    @NotNull
    public IntrospectionScope getIntrospectionScope() {
        IntrospectionScope introspectionScope = this.myIntrospectionScope;
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getIntrospectionScope"));
        }
        return introspectionScope;
    }

    public void setIntrospectionScope(@NotNull IntrospectionScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/LocalDataSource", "setIntrospectionScope"));
        }
        this.myIntrospectionScope = scope;
    }

    @Nullable
    public String getEffectiveUrl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/LocalDataSource", "getEffectiveUrl"));
        }
        return this.getEffectiveUrl(JdbcDriverManager.getDriverManager(project));
    }

    @Nullable
    public String getEffectiveUrl(@NotNull JdbcDriverManager driverManager) {
        Integer localPort;
        JdbcUrlParser parser;
        if (driverManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driverManager", "com/intellij/database/dataSource/LocalDataSource", "getEffectiveUrl"));
        }
        final String localDbInst = this.myAdditionalJdbcProperties.get("LOCAL_DB_INSTANCE");
        final String localDbExec = this.myAdditionalJdbcProperties.get("LOCAL_DB_EXECUTABLE");
        if (localDbExec != null && localDbInst != null && (parser = JdbcUrlParserUtil.statefull(JdbcUrlParserUtil.select(this.myDriver.getJDBCUrlParsers(), StringUtil.notNullize((String)this.myUrl)))) != null && parser.getParameters().contains("localdb_pipe")) {
            parser.setUrlText(this.myUrl);
            if (parser.isValid()) {
                final Ref pipe = Ref.create();
                UIUtil.invokeAndWaitIfNeeded(() -> (new Task.Modal(null, "Actualizing LocalDB Instance Info", true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/LocalDataSource$1", "run"));
                        }
                        pipe.set((Object)LocalDbParamEditor.getPipeForInstance(localDbInst, localDbExec, indicator));
                    }
                }).queue());
                if (!StringUtil.isEmpty((String)((String)pipe.get()))) {
                    parser.setParameter("localdb_pipe", (String)pipe.get());
                    return parser.getUrlText();
                }
            }
        }
        if ((localPort = driverManager.getLocalPort(this)) == null) {
            return this.myUrl;
        }
        Ref parser2 = Ref.create();
        Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(this.myDriver.getJDBCUrlParsers(), StringUtil.notNullize((String)this.myUrl), (Ref<JdbcUrlParser>)parser2);
        if (hostPort == null) {
            return this.myUrl;
        }
        ((JdbcUrlParser)parser2.get()).setParameter("host", SSH_HOST);
        ((JdbcUrlParser)parser2.get()).setParameter("port", String.valueOf(localPort));
        return ((JdbcUrlParser)parser2.get()).getUrlText();
    }

    public Properties getConnectionProperties() {
        Properties connectionProperties = new Properties();
        if (this.myDriver != null) {
            connectionProperties.putAll(this.myDriver.getDriverProperties());
        }
        connectionProperties.putAll(this.myDriverProperties);
        JdbcConsoleRunContext.addSslAndWinAuthProperties(this, connectionProperties);
        return connectionProperties;
    }

    public String getSourceName() {
        return MY_ELEMENT_FLAG;
    }

    public String getDriverClass() {
        if (this.myDriver != null) {
            return this.myDriver.getDriverClass();
        }
        return this.myDriverClass;
    }

    public void setDriverClass(String driver) {
        this.myDriverClass = driver;
    }

    public void setUrl(String url) {
        this.myUrl = url;
    }

    public void setUrlSmart(String url) {
        this.setUrl(url);
        this.setConfiguredByUrl(this.checkUrlOnly());
    }

    private boolean checkUrlOnly() {
        if (this.myUrl == null || this.myDriver == null) {
            return false;
        }
        StatelessJdbcUrlParser parser = JdbcUrlParserUtil.select(this.myDriver.getJDBCUrlParsers(), this.myUrl);
        if (parser == null) {
            return !StringUtil.isEmptyOrSpaces((String)this.myUrl);
        }
        JdbcUrlParser sparser = parser.createStatefull();
        sparser.setUrlText(this.myUrl);
        return !sparser.isValid() || !StringUtil.isEmpty((String)sparser.getParameter(USER_KEY)) || !StringUtil.isEmpty((String)sparser.getParameter(PASSWORD_KEY));
    }

    public void setUsername(String username) {
        this.myUsername = username;
    }

    @Deprecated
    public void setPassword(String password) {
        this.myEncodedPassword = password == null ? null : PasswordUtil.encodePassword((String)password);
    }

    public void serializeHeaderInner(@Nullable Project project, HierarchicalStreamWriter serializer, SaveMode mode) {
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)(project == null ? ApplicationManager.getApplication() : project));
        if (mode.includeConfig()) {
            String driverClass;
            if (this.myDriver != null && !this.myDriver.getId().equals(this.myDriverClass)) {
                LocalDataSource.writeTag(serializer, "driver-ref", this.myDriver.getId());
            }
            if (this.myAutoSynchronize) {
                LocalDataSource.writeTag(serializer, "synchronize", String.valueOf(true));
            }
            if (this.myImported) {
                LocalDataSource.writeTag(serializer, "imported", String.valueOf(true));
            }
            if (this.myConfiguredByUrl) {
                LocalDataSource.writeTag(serializer, "configured-by-url", String.valueOf(true));
            }
            if (!StringUtil.isEmpty((String)this.getComment())) {
                LocalDataSource.writeTag(serializer, "remarks", this.getComment());
            }
            if (!this.myAutoCommit) {
                LocalDataSource.writeTag(serializer, "auto-commit", String.valueOf(false));
            }
            if (StringUtil.isNotEmpty((String)(driverClass = this.getDriverClass()))) {
                LocalDataSource.writeTag(serializer, "jdbc-driver", driverClass);
            }
            if (StringUtil.isNotEmpty((String)this.myUrl)) {
                LocalDataSource.writeTag(serializer, "jdbc-url", pathMacroManager.collapsePathsRecursively(this.myUrl));
            }
            if (!this.myAdditionalJdbcProperties.isEmpty()) {
                serializer.startNode("jdbc-additional-properties");
                for (Map.Entry<String, String> entry : this.getAdditionalJdbcProperties().entrySet()) {
                    serializer.startNode("property");
                    serializer.addAttribute("name", entry.getKey());
                    serializer.addAttribute("value", entry.getValue());
                    serializer.endNode();
                }
                serializer.endNode();
            }
            if (!(this.myExplainPlanConfiguration.isEmpty() || this.myExplainPlanConfiguration.getProviderConfig().isEmpty() && this.isDefaultExplainPlanProvider(this.myExplainPlanConfiguration.getProviderClass()))) {
                serializer.startNode("explain-plan-config");
                this.myExplainPlanConfiguration.serialize(serializer);
                serializer.endNode();
            }
        }
        if (mode.includeLocalConfig()) {
            if (this.mySecretStorage) {
                LocalDataSource.writeTag(serializer, "secret-storage", StringUtil.toLowerCase((String)MASTER_KEY));
            }
            if (this.myDomainAuthentication) {
                LocalDataSource.writeTag(serializer, "domain-auth", String.valueOf(true));
            }
            if (!this.myAuthRequired) {
                LocalDataSource.writeTag(serializer, "auth-required", String.valueOf(false));
            }
            if (this.myFirstSync == ThreeState.YES) {
                LocalDataSource.writeTag(serializer, "first-sync", String.valueOf(true));
            }
            if (StringUtil.isNotEmpty((String)this.myUsername)) {
                LocalDataSource.writeTag(serializer, "user-name", this.myUsername);
            }
            LocalDataSource.writeTag(serializer, "introspection-schemas", this.myIntrospectionScope.exportState());
            if (!this.myResolveScope.isEmpty()) {
                LocalDataSource.writeTag(serializer, "resolve-scope", IntrospectionScopes.invertIf(this.myResolveScope, this.getFamilyId().isMysql()).exportState());
            }
            if (!this.myResolveScope.isEmpty()) {
                LocalDataSource.writeTag(serializer, "unqualified-resolve-schemas", this.myResolveScope.exportState());
            }
            if (StringUtil.isNotEmpty((String)this.myTablePattern)) {
                LocalDataSource.writeTag(serializer, "table-pattern", this.myTablePattern);
            }
            if (this.myUseLegacyIntrospector) {
                LocalDataSource.writeTag(serializer, "legacy-introspector", "true");
            }
            if (this.mySourceLoading != DBIntrospectionOptions.SourceLoading.USER_SOURCES) {
                LocalDataSource.writeTag(serializer, "load-sources", StringUtil.toLowerCase((String)this.mySourceLoading.name()));
            }
        }
        if (mode.includeConfig()) {
            if (StringUtil.isNotEmpty((String)this.myDefaultDialect)) {
                LocalDataSource.writeTag(serializer, "default-dialect", this.myDefaultDialect);
            }
            if (StringUtil.isNotEmpty((String)this.myVmOptions)) {
                LocalDataSource.writeTag(serializer, "vm-options", this.myVmOptions);
            }
            if (!this.myVmEnv.isEmpty()) {
                serializer.startNode("vm-env");
                for (String name : this.myVmEnv.keySet()) {
                    serializer.startNode("property");
                    serializer.addAttribute("name", name);
                    serializer.addAttribute("value", this.myVmEnv.get(name));
                    serializer.endNode();
                }
                serializer.endNode();
            }
            if (!this.myDriverProperties.isEmpty()) {
                serializer.startNode("driver-properties");
                for (String name : this.myDriverProperties.keySet()) {
                    serializer.startNode("property");
                    serializer.addAttribute("name", name);
                    serializer.addAttribute("value", this.myDriverProperties.get(name));
                    serializer.endNode();
                }
                serializer.endNode();
            }
            if (!this.myClasspathElements.isEmpty()) {
                serializer.startNode(LIBRARIES_ELEMENT_NAME);
                for (SimpleClasspathElement classpathElement : this.myClasspathElements) {
                    Element element = new Element(LIBRARY_ELEMENT_NAME);
                    try {
                        classpathElement.serialize(element);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    pathMacroManager.collapsePaths(element);
                    new HierarchicalStreamCopier().copy((HierarchicalStreamReader)new JDomReader(element), serializer);
                }
                serializer.endNode();
            }
        }
        if (mode.includeLocalConfig()) {
            if (this.mySshConfiguration != null && !this.mySshConfiguration.isEmpty()) {
                this.mySshConfiguration.serialize(serializer);
            }
            if (this.mySslCfg != null && !this.mySslCfg.isEmpty()) {
                this.mySslCfg.serialize(serializer);
            }
        }
    }

    public void deserialize(@Nullable Project project, @NotNull HierarchicalStreamReader reader, @NotNull SaveMode mode) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dataSource/LocalDataSource", "deserialize"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/dataSource/LocalDataSource", "deserialize"));
        }
        if (mode.includeConfig()) {
            this.myClasspathElements.clear();
        }
        this.deserializeInner(project, reader, mode);
        this.correctExplainPlanProvider();
    }

    private void deserializeInner(@Nullable Project project, @NotNull HierarchicalStreamReader reader, @NotNull SaveMode mode) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dataSource/LocalDataSource", "deserializeInner"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/dataSource/LocalDataSource", "deserializeInner"));
        }
        HashSet legacyTags = ContainerUtil.newHashSet((Object[])new String[]{"table", "procedure", "schema"});
        if (ELEMENT_NAME.equals(reader.getNodeName())) {
            this.setName(StringUtil.notNullize((String)reader.getAttribute("name")));
            if (mode.includeConfig()) {
                this.setReadOnly("true".equals(reader.getAttribute("read-only")));
            }
            this.setUniqueId(reader.getAttribute("uuid"));
            BasicModModel model = null;
            if (mode.includeDatabaseInfo()) {
                this.deserializeDatabaseInfo(reader, true);
            }
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                boolean skipMoveUp = false;
                String nodeName = reader.getNodeName();
                if (mode.includeDatabaseInfo() && "database-info".equals(nodeName)) {
                    this.deserializeDatabaseInfo(reader, false);
                } else if (mode.includeDatabaseInfo() && "case-sensitivity".equals(nodeName)) {
                    Case plain = Case.fromString((String)reader.getAttribute("plain-identifiers"), (Case)DasUtil.CASING_MIXED.plain);
                    Case quoted = Case.fromString((String)reader.getAttribute("quoted-identifiers"), (Case)DasUtil.CASING_MIXED.quoted);
                    this.myInfo.myCasing = Casing.create((Case)plain, (Case)quoted);
                } else if (mode.includeDatabaseInfo() && "extra-name-characters".equals(nodeName)) {
                    this.myInfo.myExtraNameCharacters = reader.getValue();
                } else if (mode.includeDatabaseInfo() && "identifier-quote-string".equals(nodeName)) {
                    this.myInfo.myIdentifierQuoteString = reader.getValue();
                } else if (!this.deserializeHeaderInner(project, reader, mode) && mode.includeSchema()) {
                    String serializerName = reader.getAttribute("serializer");
                    if (serializerName == null && legacyTags.contains(nodeName)) {
                        serializerName = "legacy";
                        skipMoveUp = true;
                    }
                    if ("legacy".equals(serializerName)) {
                        model = this.deserializeLegacyFormat(project, reader);
                    } else if ("database-model".equals(nodeName)) {
                        model = new ModelSerializer(DataSourceSrcBridge.createFactory(project, this.getUniqueId())).deserialize(reader);
                    }
                }
                if (skipMoveUp) continue;
                reader.moveUp();
            }
            if (mode.includeSchema() && model != null) {
                this.setModel(model);
                this.setLoading(false);
            }
        }
    }

    private void deserializeDatabaseInfo(@NotNull HierarchicalStreamReader xmlReader, boolean skipChildren) {
        if (xmlReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlReader", "com/intellij/database/dataSource/LocalDataSource", "deserializeDatabaseInfo"));
        }
        this.myInfo.myProductName = xmlReader.getAttribute("product");
        this.myInfo.myProductVersion = xmlReader.getAttribute("version");
        this.myInfo.myJDBCVersion = xmlReader.getAttribute("jdbc-version");
        this.myInfo.myDriverName = xmlReader.getAttribute("driver-name");
        this.myInfo.myDriverVersion = xmlReader.getAttribute("driver-version");
        if (skipChildren) {
            return;
        }
        while (xmlReader.hasMoreChildren()) {
            xmlReader.moveDown();
            String nodeName = xmlReader.getNodeName();
            if ("extra-name-characters".equals(nodeName)) {
                this.myInfo.myExtraNameCharacters = xmlReader.getValue();
            } else if ("identifier-quote-string".equals(nodeName)) {
                this.myInfo.myIdentifierQuoteString = xmlReader.getValue();
            }
            xmlReader.moveUp();
        }
    }

    protected boolean deserializeHeaderInner(@Nullable Project project, HierarchicalStreamReader xmlReader, SaveMode mode) {
        if (!mode.includeConfig() && !mode.includeLocalConfig()) {
            return false;
        }
        if (project != null && project.isDisposed()) {
            throw new ProcessCanceledException();
        }
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)(project == null ? ApplicationManager.getApplication() : project));
        String nodeName = xmlReader.getNodeName();
        if (LIBRARIES_ELEMENT_NAME.equals(nodeName)) {
            this.myClasspathElements.clear();
            while (xmlReader.hasMoreChildren()) {
                xmlReader.moveDown();
                if (LIBRARY_ELEMENT_NAME.equals(xmlReader.getNodeName())) {
                    JDomWriter writer = new JDomWriter((JDOMFactory)new DefaultJDOMFactory());
                    new HierarchicalStreamCopier().copy(xmlReader, (HierarchicalStreamWriter)writer);
                    Element element = (Element)ContainerUtil.getFirstItem((List)writer.getTopLevelNodes());
                    pathMacroManager.expandPaths(element);
                    this.myClasspathElements.addAll(SimpleClasspathElementFactory.createElements((Project)project, (Element)element));
                }
                xmlReader.moveUp();
            }
        } else if ("explain-plan-config".equals(nodeName)) {
            this.myExplainPlanConfiguration.deserialize(xmlReader);
        } else if ("driver-ref".equals(nodeName)) {
            this.myDriver = this.getDriverById(xmlReader.getValue());
        } else if ("synchronize".equals(nodeName)) {
            this.myAutoSynchronize = Boolean.valueOf(xmlReader.getValue());
        } else if ("imported".equals(nodeName)) {
            this.myImported = Boolean.valueOf(xmlReader.getValue());
        } else if ("configured-by-url".equals(nodeName)) {
            this.myConfiguredByUrl = Boolean.valueOf(xmlReader.getValue());
        } else if ("remarks".equals(nodeName)) {
            this.setComment(xmlReader.getValue());
        } else if ("auto-commit".equals(nodeName)) {
            this.myAutoCommit = Boolean.valueOf(xmlReader.getValue());
        } else if ("auth-required".equals(nodeName)) {
            this.myAuthRequired = Boolean.valueOf(xmlReader.getValue());
        } else if ("domain-auth".equals(nodeName)) {
            this.myDomainAuthentication = Boolean.valueOf(xmlReader.getValue());
        } else if ("first-sync".equals(nodeName)) {
            this.myFirstSync = ThreeState.fromBoolean((boolean)Boolean.valueOf(xmlReader.getValue()));
        } else if ("jdbc-driver".equals(nodeName)) {
            this.myDriverClass = xmlReader.getValue();
        } else if ("jdbc-url".equals(nodeName)) {
            this.myUrl = pathMacroManager.expandPath(xmlReader.getValue());
        } else if ("jdbc-additional-properties".equals(nodeName)) {
            while (xmlReader.hasMoreChildren()) {
                xmlReader.moveDown();
                if ("property".equals(xmlReader.getNodeName())) {
                    this.myAdditionalJdbcProperties.put(xmlReader.getAttribute("name"), xmlReader.getAttribute("value"));
                }
                xmlReader.moveUp();
            }
        } else if ("secret-storage".equals(nodeName)) {
            this.mySecretStorage = MASTER_KEY.equalsIgnoreCase(xmlReader.getValue());
        } else if ("user-name".equals(nodeName)) {
            this.myUsername = xmlReader.getValue();
        } else if ("schema-pattern".equals(nodeName)) {
            this.myIntrospectionScope = this.parseSchemaPattern(xmlReader.getValue());
        } else if ("default-schemas".equals(nodeName)) {
            this.myResolveScope = this.parseSchemaPattern(xmlReader.getValue());
        } else if ("introspection-scope".equals(nodeName)) {
            this.myIntrospectionScope = this.importOldScope(xmlReader.getValue());
        } else if ("resolve-scope".equals(nodeName)) {
            this.myResolveScope = this.importOldScope(xmlReader.getValue());
        } else if ("introspection-schemas".equals(nodeName)) {
            this.myIntrospectionScope = IntrospectionScopes.importScope(xmlReader.getValue());
        } else if ("unqualified-resolve-schemas".equals(nodeName)) {
            this.myResolveScope = IntrospectionScopes.importScope(xmlReader.getValue());
        } else if ("table-pattern".equals(nodeName)) {
            this.myTablePattern = xmlReader.getValue();
        } else if ("legacy-introspector".equals(nodeName)) {
            this.myUseLegacyIntrospector = "true".equals(xmlReader.getValue());
        } else if ("load-sources".equals(nodeName)) {
            this.mySourceLoading = DBIntrospectionOptions.SourceLoading.valueOf(StringUtil.toUpperCase((String)xmlReader.getValue()));
        } else if ("default-dialect".equals(nodeName)) {
            this.myDefaultDialect = xmlReader.getValue();
        } else if ("vm-options".equals(nodeName)) {
            this.myVmOptions = xmlReader.getValue();
        } else if ("use-ssl".equals(nodeName) && Boolean.valueOf(xmlReader.getValue()).booleanValue()) {
            if (this.mySslCfg == null) {
                this.mySslCfg = new DataSourceSslConfiguration("", "", "", true);
            } else {
                this.mySslCfg.myEnabled = true;
            }
        } else if ("ssl-ca-cert".equals(nodeName) && !StringUtil.isEmptyOrSpaces((String)xmlReader.getValue())) {
            if (this.mySslCfg == null) {
                this.mySslCfg = new DataSourceSslConfiguration(xmlReader.getValue(), "", "", false);
            } else {
                this.mySslCfg.myCaCertPath = xmlReader.getValue();
            }
        } else if ("driver-properties".equals(nodeName)) {
            while (xmlReader.hasMoreChildren()) {
                xmlReader.moveDown();
                if ("property".equals(xmlReader.getNodeName())) {
                    this.myDriverProperties.put(xmlReader.getAttribute("name"), xmlReader.getAttribute("value"));
                }
                xmlReader.moveUp();
            }
        } else if ("vm-env".equals(nodeName)) {
            while (xmlReader.hasMoreChildren()) {
                xmlReader.moveDown();
                if ("property".equals(xmlReader.getNodeName())) {
                    this.myVmEnv.put(xmlReader.getAttribute("name"), xmlReader.getAttribute("value"));
                }
                xmlReader.moveUp();
            }
        } else if ("ssh-properties".equals(nodeName)) {
            this.mySshConfiguration = DataSourceSshTunnelConfiguration.deserialize(xmlReader, this);
        } else if ("ssl-config".equals(nodeName)) {
            this.mySslCfg = DataSourceSslConfiguration.deserialize(xmlReader);
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    private IntrospectionScope parseSchemaPattern(@Nullable String pattern) {
        DatabaseFamilyId family = DatabaseFamilyId.forConnection((RawConnectionConfig)this);
        IntrospectionScope introspectionScope = IntrospectionScopes.invertIf(IntrospectionScopes.fromSchemaPattern(pattern), family.isMysql());
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "parseSchemaPattern"));
        }
        return introspectionScope;
    }

    @NotNull
    private IntrospectionScope importOldScope(@Nullable String pattern) {
        DatabaseFamilyId family = DatabaseFamilyId.forConnection((RawConnectionConfig)this);
        IntrospectionScope introspectionScope = IntrospectionScopes.invertIf(IntrospectionScopes.importScope(pattern), family.isMysql());
        if (introspectionScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "importOldScope"));
        }
        return introspectionScope;
    }

    @Nullable
    private DatabaseDriver getDriverById(@Nullable String id) {
        DatabaseDriver driver = DatabaseDriverManager.getInstance().getDriver(id);
        if (driver == null) {
            LOG.warn("Failed to find driver with id {" + id + "} for data source " + this.getName() + "{" + this.getUniqueId() + "}");
        }
        return driver;
    }

    @NotNull
    public List<SimpleClasspathElement> getClasspathElements() {
        if (this.myDriver != null) {
            List<SimpleClasspathElement> list = this.myDriver.getClasspathElements();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getClasspathElements"));
            }
            return list;
        }
        List<SimpleClasspathElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getClasspathElements"));
        }
        return list;
    }

    @Deprecated
    public void setClasspathElements(List<SimpleClasspathElement> classpathElements) {
        this.myClasspathElements.clear();
        this.myClasspathElements.addAll(classpathElements);
    }

    @Deprecated
    @NotNull
    public List<SimpleClasspathElement> getOwnClasspath() {
        List<SimpleClasspathElement> list = this.myClasspathElements;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getOwnClasspath"));
        }
        return list;
    }

    public String getDefaultDialect() {
        if (this.myDefaultDialect != null) {
            return this.myDefaultDialect;
        }
        if (this.myDriver != null) {
            return this.myDriver.getDialect();
        }
        return null;
    }

    public void setDefaultDialect(String defaultDialect) {
        this.myDefaultDialect = defaultDialect;
    }

    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    public void setVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    @NotNull
    public Map<String, String> getDriverProperties() {
        Map<String, String> map = this.myDriverProperties;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getDriverProperties"));
        }
        return map;
    }

    @Override
    public String getTablePattern() {
        return this.myTablePattern;
    }

    public boolean useLegacyIntrospector() {
        return this.myUseLegacyIntrospector;
    }

    public void setUseLegacyIntrospector(boolean useLegacyIntrospector) {
        this.myUseLegacyIntrospector = useLegacyIntrospector;
    }

    @NotNull
    public DBIntrospectionOptions.SourceLoading getSourceLoading() {
        DBIntrospectionOptions.SourceLoading sourceLoading = this.mySourceLoading;
        if (sourceLoading == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getSourceLoading"));
        }
        return sourceLoading;
    }

    public void setSourceLoading(@NotNull DBIntrospectionOptions.SourceLoading sourceLoading) {
        if (sourceLoading == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceLoading", "com/intellij/database/dataSource/LocalDataSource", "setSourceLoading"));
        }
        this.mySourceLoading = sourceLoading;
    }

    public void setTablePattern(String tablePattern) {
        this.myTablePattern = tablePattern;
    }

    @NotNull
    public DataSourceExplainPlanConfiguration getExplainPlanConfiguration() {
        DataSourceExplainPlanConfiguration dataSourceExplainPlanConfiguration = this.myExplainPlanConfiguration;
        if (dataSourceExplainPlanConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getExplainPlanConfiguration"));
        }
        return dataSourceExplainPlanConfiguration;
    }

    @Nullable
    public DataSourceSshTunnelConfiguration getSshConfiguration() {
        return this.mySshConfiguration;
    }

    public void setSshConfiguration(DataSourceSshTunnelConfiguration configuration) {
        this.mySshConfiguration = configuration;
    }

    @Nullable
    public DataSourceSslConfiguration getSslCfg() {
        return this.mySslCfg;
    }

    public void setSslCfg(DataSourceSslConfiguration sslCfg) {
        this.mySslCfg = sslCfg;
    }

    public boolean isDomainAuthentication() {
        return this.myDomainAuthentication;
    }

    public void setDomainAuthentication(boolean domainAuthentication) {
        this.myDomainAuthentication = domainAuthentication;
    }

    public ThreeState getFirstSync() {
        return this.myFirstSync;
    }

    public void setFirstSync(ThreeState firstSync) {
        this.myFirstSync = firstSync;
    }

    @NotNull
    public LocalDataSource copy(Project project) {
        StringBuffer buffer = this.copySettings(project);
        LocalDataSource clone = LocalDataSource.createDataSourceFromSettings(buffer, project);
        this.copyExtraParametersTo(clone);
        LocalDataSource localDataSource = clone;
        if (localDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "copy"));
        }
        return localDataSource;
    }

    public StringBuffer copySettings(@Nullable Project project) {
        StringWriter writer = new StringWriter();
        CompactWriter serializer = new CompactWriter((Writer)writer);
        this.serialize(project, (HierarchicalStreamWriter)serializer, SaveMode.WITHOUT_SCHEMA);
        serializer.close();
        return writer.getBuffer();
    }

    @NotNull
    public static LocalDataSource createDataSourceFromSettings(@NotNull StringBuffer settings, @Nullable Project project) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dataSource/LocalDataSource", "createDataSourceFromSettings"));
        }
        String uuidPrefix = "uuid=\"";
        LocalDataSource clone = new LocalDataSource();
        int idx = settings.indexOf(uuidPrefix);
        if (idx > -1) {
            settings.replace(idx, settings.indexOf("\"", idx + uuidPrefix.length()) + 1, "");
        }
        clone.deserialize(project, (HierarchicalStreamReader)new XppReader((Reader)new StringReader(settings.toString())), SaveMode.WITHOUT_SCHEMA);
        LocalDataSource localDataSource = clone;
        if (localDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "createDataSourceFromSettings"));
        }
        return localDataSource;
    }

    private void copyExtraParametersTo(@NotNull LocalDataSource ds) {
        if (ds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ds", "com/intellij/database/dataSource/LocalDataSource", "copyExtraParametersTo"));
        }
        ds.setGlobal(this.isGlobal());
        ds.setDatabaseDriver(this.getDatabaseDriver());
        ds.setIntrospectionScope(this.getIntrospectionScope());
        ds.setUseMasterKeyStorage(this.isUseMasterKeyStorage());
        ds.setUsername(this.getUsername());
    }

    @Override
    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return this;
    }

    private void setupDefaults(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/LocalDataSource", "setupDefaults"));
        }
        if (this.myFirstSync != ThreeState.YES) {
            return;
        }
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(this);
        Case casing = dialect.getCasing(ObjectKind.SCHEMA, null).choose(true);
        new DefaultsInstaller(this).setupIntrospectionScopeByDefault(connection, casing.apply(this.getUsername())).saveSchemas();
        this.myFirstSync = ThreeState.NO;
    }

    public boolean equalConfiguration(@NotNull LocalDataSource o) {
        boolean hasSsl2;
        boolean hasSsh2;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/dataSource/LocalDataSource", "equalConfiguration"));
        }
        if (this.isConfiguredByUrl() != o.isConfiguredByUrl()) {
            return false;
        }
        if (this.isImported() != o.isImported()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getComment(), (CharSequence)o.getComment())) {
            return false;
        }
        if (this.isAuthRequired() != o.isAuthRequired()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.getUrl()), (CharSequence)StringUtil.nullize((String)o.getUrl()))) {
            return false;
        }
        if (this.isAutoSynchronize() != o.isAutoSynchronize()) {
            return false;
        }
        if (this.isReadOnly() != o.isReadOnly()) {
            return false;
        }
        if (this.isAutoCommit() != o.isAutoCommit()) {
            return false;
        }
        if (this.isGlobal() != o.isGlobal()) {
            return false;
        }
        if (!LocalDataSource.driversEqual(this.getDatabaseDriver(), o.getDatabaseDriver())) {
            return false;
        }
        if (this.isDomainAuthentication() != o.isDomainAuthentication()) {
            return false;
        }
        if (!this.getDriverProperties().equals(o.getDriverProperties())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getDriverClass(), (CharSequence)o.getDriverClass())) {
            return false;
        }
        if (!Comparing.equal((Object)this.getIntrospectionScope(), (Object)o.getIntrospectionScope())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.getTablePattern(), (CharSequence)o.getTablePattern())) {
            return false;
        }
        if (this.myUseLegacyIntrospector != o.useLegacyIntrospector()) {
            return false;
        }
        if (this.mySourceLoading != o.getSourceLoading()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)this.myVmOptions), (CharSequence)StringUtil.nullize((String)o.myVmOptions))) {
            return false;
        }
        if (!LocalDataSource.equals(this.myVmEnv, o.myVmEnv)) {
            return false;
        }
        if (!LocalDataSource.equals(this.getAdditionalJdbcProperties(), o.getAdditionalJdbcProperties())) {
            return false;
        }
        if (!this.myExplainPlanConfiguration.equalConfiguration(o.myExplainPlanConfiguration)) {
            return false;
        }
        boolean hasSsh1 = this.mySshConfiguration != null && !this.mySshConfiguration.isEmpty();
        boolean bl = hasSsh2 = o.mySshConfiguration != null && !o.mySshConfiguration.isEmpty();
        if (hasSsh1 != hasSsh2) {
            return false;
        }
        if (hasSsh1 && !this.mySshConfiguration.equalConfiguration(o.mySshConfiguration)) {
            return false;
        }
        boolean hasSsl1 = this.mySslCfg != null && !this.mySslCfg.isEmpty();
        boolean bl2 = hasSsl2 = o.mySslCfg != null && !o.mySslCfg.isEmpty();
        if (hasSsl1 != hasSsl2) {
            return false;
        }
        return !hasSsl1 || this.mySslCfg.equalConfiguration(o.mySslCfg);
    }

    private static boolean driversEqual(@Nullable DatabaseDriver a, @Nullable DatabaseDriver b) {
        if (a == null || b == null) {
            return a == b;
        }
        return Comparing.equal((String)a.getId(), (String)b.getId());
    }

    private static <K, V> boolean equals(@NotNull Map<K, V> m1, @NotNull Map<K, V> m2) {
        if (m1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m1", "com/intellij/database/dataSource/LocalDataSource", "equals"));
        }
        if (m2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m2", "com/intellij/database/dataSource/LocalDataSource", "equals"));
        }
        for (Map.Entry<K, V> entry : m1.entrySet()) {
            if (Comparing.equal(entry.getValue(), m2.get(entry.getKey()))) continue;
            return false;
        }
        for (Map.Entry<K, V> entry : m2.entrySet()) {
            if (Comparing.equal(entry.getValue(), m1.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public void setAdditionalJdbcProperties(@NotNull Map<String, String> additionalJdbcProperties) {
        if (additionalJdbcProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalJdbcProperties", "com/intellij/database/dataSource/LocalDataSource", "setAdditionalJdbcProperties"));
        }
        this.myAdditionalJdbcProperties.clear();
        this.myAdditionalJdbcProperties.putAll(additionalJdbcProperties);
    }

    @NotNull
    public Map<String, String> getAdditionalJdbcProperties() {
        Map<String, String> map = this.myAdditionalJdbcProperties;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getAdditionalJdbcProperties"));
        }
        return map;
    }

    public boolean isAuthRequired() {
        return this.myAuthRequired;
    }

    public void setAuthRequired(boolean authRequired) {
        this.myAuthRequired = authRequired;
    }

    public boolean isImported() {
        return this.myImported;
    }

    private void correctExplainPlanProvider() {
        this.myExplainPlanConfiguration.setProviderClass(DataSourceExplainPlanConfiguration.resetToDefaultIfInvalid(this.myExplainPlanConfiguration.getProviderClass(), this));
    }

    private boolean isDefaultExplainPlanProvider(String className) {
        return DataSourceExplainPlanConfiguration.getDefaultProviderClass(this).equals(className);
    }

    public boolean isConfiguredByUrl() {
        return this.myConfiguredByUrl;
    }

    public void setConfiguredByUrl(boolean configuredByUrl) {
        this.myConfiguredByUrl = configuredByUrl;
    }

    @NotNull
    public Map<String, String> getVmEnv() {
        Map<String, String> map = this.myVmEnv;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getVmEnv"));
        }
        return map;
    }

    public void setVmEnv(@NotNull Map<String, String> vmEnv) {
        if (vmEnv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmEnv", "com/intellij/database/dataSource/LocalDataSource", "setVmEnv"));
        }
        this.myVmEnv.clear();
        this.myVmEnv.putAll(vmEnv);
    }

    @NotNull
    public String toString() {
        String str = super.toString();
        String dialect = this.getDefaultDialect();
        String string = str = str + (dialect != null && !dialect.isEmpty() ? " (" + dialect + ")" : " (unknown dialect)");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "toString"));
        }
        return string;
    }

    @NotNull
    public DasModel getModel() {
        DasModel dasModel = this.myModel;
        if (dasModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/LocalDataSource", "getModel"));
        }
        return dasModel;
    }

    public void setModel(@NotNull DasModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/LocalDataSource", "setModel"));
        }
        if (this.myModel == model) {
            return;
        }
        if (this.myModel instanceof BasicModModel) {
            ((BasicModModel)this.myModel).removeListener(this.myModelListener);
        }
        if (model instanceof BasicModel) {
            this.myIntrospectionScope = DatabaseModelLoader.updateIntrospectionScope((BasicModel)model, this.myIntrospectionScope, true);
        }
        this.myModel = model;
        this.incModificationCount();
        if (this.myModel instanceof BasicModModel) {
            ((BasicModModel)this.myModel).addListener(this.myModelListener);
        }
        this.notifyConsumersThatModelIsUpdated();
    }

    private void notifyConsumersThatModelIsUpdated() {
        for (Listener listener : this.myDispatcher.getListeners()) {
            try {
                listener.dataSourceModelUpdated(this);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                String message = e.getClass().getSimpleName() + "%s when attempted to notify that the model is updated: " + e.getMessage();
                LOG.error(message, (Throwable)e);
            }
        }
    }

    public void addListener(@NotNull Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dataSource/LocalDataSource", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(@NotNull Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dataSource/LocalDataSource", "removeListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public void clearModel() {
        if (this.myModel instanceof BasicModModel) {
            ((BasicModModel)this.myModel).clearModel();
        } else {
            this.myModel = DasUtil.emptyModel();
            this.notifyConsumersThatModelIsUpdated();
        }
    }

    public void refreshMetaData(@NotNull Project project, @NotNull Connection connection, @NotNull LoaderContext context, @NotNull ProgressIndicator indicator) throws SQLException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/LocalDataSource", "refreshMetaData"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/LocalDataSource", "refreshMetaData"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/LocalDataSource", "refreshMetaData"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/LocalDataSource", "refreshMetaData"));
        }
        indicator.checkCanceled();
        DatabaseMetaData metaData = connection.getMetaData();
        this.refreshDatabaseInfo(metaData);
        if (!context.loadNothing()) {
            this.setupDefaults(connection);
            context.renewFamilyId(metaData);
            ModelFactory modelFactory = DataSourceSrcBridge.createFactory(this.isGlobal() ? null : project, this.getUniqueId());
            DBIntrospectionOptions.SourceLoading withSources = DbSrcStorage.isEnabled() ? this.getSourceLoading() : DBIntrospectionOptions.SourceLoading.NO_SOURCES;
            DBIntrospectionOptions options = new DBIntrospectionOptions(withSources);
            DatabaseModelLoader.performIntrospection(modelFactory, context, this.getModel(), connection, options, indicator, (Function<IntrospectionScope, IntrospectionScope>)((Function)isc -> {
                this.myIntrospectionScope = (IntrospectionScope)ObjectUtils.notNull((Object)isc, (Object)this.myIntrospectionScope);
                return this.myIntrospectionScope;
            }));
        }
    }

    protected DataSource.Info getInfo() {
        return this.myInfo;
    }

    public void serialize(@Nullable Project project, @NotNull HierarchicalStreamWriter serializer, @NotNull SaveMode mode) {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/database/dataSource/LocalDataSource", "serialize"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/dataSource/LocalDataSource", "serialize"));
        }
        serializer.startNode(ELEMENT_NAME);
        this.serializeHeader(project, serializer, mode);
        if (mode.includeSchema()) {
            new ModelSerializer(DataSourceSrcBridge.createFactory(project, this.getUniqueId())).serialize(this.getModel(), serializer);
        }
        serializer.endNode();
        serializer.flush();
    }

    public void serializeHeader(Project project, @NotNull HierarchicalStreamWriter serializer, @NotNull SaveMode mode) {
        if (serializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializer", "com/intellij/database/dataSource/LocalDataSource", "serializeHeader"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/dataSource/LocalDataSource", "serializeHeader"));
        }
        if (mode.includeConfig()) {
            serializer.addAttribute("source", this.getSourceName());
        }
        serializer.addAttribute("name", StringUtil.notNullize((String)this.getName()));
        if (mode.includeConfig() && this.isReadOnly()) {
            serializer.addAttribute("read-only", String.valueOf(this.isReadOnly()));
        }
        serializer.addAttribute("uuid", StringUtil.notNullize((String)this.getUniqueId()));
        if (mode.includeDatabaseInfo()) {
            serializer.startNode("database-info");
            serializer.addAttribute("product", StringUtil.notNullize((String)this.getInfo().myProductName));
            serializer.addAttribute("version", StringUtil.notNullize((String)this.getInfo().myProductVersion));
            serializer.addAttribute("jdbc-version", StringUtil.notNullize((String)this.getInfo().myJDBCVersion));
            serializer.addAttribute("driver-name", StringUtil.notNullize((String)this.getInfo().myDriverName));
            serializer.addAttribute("driver-version", StringUtil.notNullize((String)this.getInfo().myDriverVersion));
            if (this.getInfo().myExtraNameCharacters != null) {
                LocalDataSource.writeTag(serializer, "extra-name-characters", this.getInfo().myExtraNameCharacters);
            }
            if (this.getInfo().myIdentifierQuoteString != null) {
                LocalDataSource.writeTag(serializer, "identifier-quote-string", this.getInfo().myIdentifierQuoteString);
            }
            serializer.endNode();
            if (this.getInfo().myCasing.plain != DasUtil.CASING_MIXED.plain || this.getInfo().myCasing.quoted != DasUtil.CASING_MIXED.quoted) {
                serializer.startNode("case-sensitivity");
                serializer.addAttribute("plain-identifiers", StringUtil.toLowerCase((String)this.getInfo().myCasing.plain.name()));
                serializer.addAttribute("quoted-identifiers", StringUtil.toLowerCase((String)this.getInfo().myCasing.quoted.name()));
                serializer.endNode();
            }
        }
        this.serializeHeaderInner(project, serializer, mode);
    }

    public void refreshDatabaseInfo(@NotNull DatabaseMetaData metaData) throws SQLException {
        if (metaData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaData", "com/intellij/database/dataSource/LocalDataSource", "refreshDatabaseInfo"));
        }
        this.getInfo().myProductName = metaData.getDatabaseProductName();
        this.getInfo().myProductVersion = metaData.getDatabaseProductVersion();
        this.getInfo().myDriverName = metaData.getDriverName();
        this.getInfo().myDriverVersion = metaData.getDriverVersion();
        try {
            this.getInfo().myJDBCVersion = metaData.getJDBCMajorVersion() + "." + metaData.getJDBCMinorVersion();
        }
        catch (Throwable e) {
            try {
                metaData.getConnection();
                this.getInfo().myJDBCVersion = "2.1";
            }
            catch (Throwable e1) {
                this.getInfo().myJDBCVersion = "1.2";
            }
        }
        try {
            this.getInfo().myIdentifierQuoteString = metaData.getIdentifierQuoteString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getInfo().myExtraNameCharacters = metaData.getExtraNameCharacters();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (StringUtil.isEmptyOrSpaces((String)this.getInfo().myIdentifierQuoteString)) {
            this.getInfo().myIdentifierQuoteString = null;
        }
        if (StringUtil.isEmptyOrSpaces((String)this.getInfo().myExtraNameCharacters)) {
            this.getInfo().myExtraNameCharacters = null;
        }
        try {
            this.getInfo().myCasing = DatabaseMetaDataWrapper.getCasing(DatabaseFamilyId.forDataSource((DatabaseSystem)this), metaData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deserialize(Project project, Reader reader) throws Exception {
        this.deserialize(project, (HierarchicalStreamReader)new XppReader(reader), SaveMode.ALL);
    }

    protected BasicModModel deserializeLegacyFormat(@Nullable Project project, @NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/dataSource/LocalDataSource", "deserializeLegacyFormat"));
        }
        DatabaseDialectEx dialect = (DatabaseDialectEx)ObjectUtils.chooseNotNull((Object)DbImplUtil.guessDatabaseDialect(this.getConnectionConfig()), (Object)GenericDialect.INSTANCE);
        return LegacyDeserializer.deserialize(reader, DataSourceSrcBridge.createFactory(project, this.getUniqueId()), dialect, this.getIntrospectionScope(), this.myResolveScope);
    }

    public void performBatch(Runnable runnable) {
        this.myBatchCounter.incrementAndGet();
        try {
            runnable.run();
        }
        finally {
            if (this.myBatchCounter.decrementAndGet() == 0) {
                this.notifyConsumersThatModelIsUpdated();
            }
        }
    }

    void copyDatabaseInfo(@NotNull AbstractDataSource other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/dataSource/LocalDataSource", "copyDatabaseInfo"));
        }
        this.myInfo.copyFrom(other.getInfo());
    }

    public boolean isLoading() {
        return this.myLoading;
    }

    public boolean isInBatch() {
        return this.myBatchCounter.get() != 0;
    }

    public void setLoading(boolean loading) {
        this.myLoading = loading;
    }

    public static enum SaveMode {
        ALL,
        CONFIG,
        LOCAL_CONFIG,
        WITHOUT_SCHEMA,
        SCHEMA;


        public boolean includeSchema() {
            return this == ALL || this == SCHEMA;
        }

        public boolean includeConfig() {
            return this == ALL || this == CONFIG || this == WITHOUT_SCHEMA;
        }

        public boolean includeLocalConfig() {
            return this == ALL || this == LOCAL_CONFIG || this == WITHOUT_SCHEMA;
        }

        public boolean includeDatabaseInfo() {
            return this.includeSchema() || this.includeLocalConfig();
        }
    }

    public static interface Listener
    extends EventListener {
        public void dataSourceModelUpdated(@NotNull LocalDataSource var1);
    }
}

