/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.ide.FileIconProvider;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.intellij.util.containers.ConcurrentFactoryMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcExtensions {

    public static class FilePresentation
    implements FileIconProvider,
    EditorTabTitleProvider {
        @Nullable
        public Icon getIcon(@NotNull VirtualFile file, @Iconable.IconFlags int flags, @Nullable Project project) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcExtensions$FilePresentation", "getIcon"));
            }
            return DbSrcUtils.isDbSrcFile(file) ? DbSrcUtils.getIcon(file.getPath()) : null;
        }

        @Nullable
        public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/srcStorage/DbSrcExtensions$FilePresentation", "getEditorTabTitle"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcExtensions$FilePresentation", "getEditorTabTitle"));
            }
            if (!DbSrcUtils.isDbSrcFile(file)) {
                return null;
            }
            final DbSrcPath path = DbSrcUtils.getFullPath(file.getPath());
            if (path == null) {
                return null;
            }
            class MyVirtualFile
            extends FakeVirtualFile {
                private final VirtualFile myBase;

                MyVirtualFile(VirtualFile base) {
                    super(base.getParent(), StringUtil.shortenTextWithEllipsis((String)(dbSrcPath.getName() + StringUtil.notNullize((String)dbSrcPath.getDisambiguator())), (int)50, (int)0));
                    this.myBase = base;
                }

                public boolean isDirectory() {
                    return this.myBase.isDirectory();
                }

                @NotNull
                public String getPath() {
                    String string = DbSrcFileSystem.getInstance().extractPresentableUrl(this.myBase.getPath());
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcExtensions$FilePresentation$1MyVirtualFile", "getPath"));
                    }
                    return string;
                }

                public boolean equals(Object obj) {
                    return obj instanceof MyVirtualFile && this.myBase.equals(((MyVirtualFile)((Object)obj)).myBase);
                }

                public int hashCode() {
                    return this.myBase.hashCode();
                }
            }
            return DatabaseElementVirtualFileImpl.getEditorTabTitleImpl(project, (VirtualFile)new MyVirtualFile(file));
        }
    }

    public static class UsageTypeExtension
    implements UsageTypeProvider {
        private static final ConcurrentFactoryMap<String, UsageType> ourUsageTypes = new ConcurrentFactoryMap<String, UsageType>(){

            @Nullable
            protected UsageType create(String key) {
                return new UsageType("Usage in " + StringUtil.capitalize((String)StringUtil.pluralize((String)key)));
            }
        };

        @Nullable
        public UsageType getUsageType(PsiElement element) {
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
            String kind = DbSrcUtils.isDbSrcFile(file) ? DbSrcUtils.getKind(file.getPath()) : null;
            return kind == null ? null : (UsageType)ourUsageTypes.get((Object)kind);
        }
    }
}

