/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.zipfs;

import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileSystem;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Formatter;

public class ZipFileAttributes
implements BasicFileAttributes {
    private final ZipFileSystem.Entry e;

    ZipFileAttributes(ZipFileSystem.Entry e) {
        this.e = e;
    }

    @Override
    public FileTime creationTime() {
        if (this.e.ctime != -1L) {
            return FileTime.fromMillis(this.e.ctime);
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        return this.e.isDir();
    }

    @Override
    public boolean isOther() {
        return false;
    }

    @Override
    public boolean isRegularFile() {
        return !this.e.isDir();
    }

    @Override
    public FileTime lastAccessTime() {
        if (this.e.atime != -1L) {
            return FileTime.fromMillis(this.e.atime);
        }
        return null;
    }

    @Override
    public FileTime lastModifiedTime() {
        return FileTime.fromMillis(this.e.mtime);
    }

    @Override
    public long size() {
        return this.e.size;
    }

    @Override
    public boolean isSymbolicLink() {
        return false;
    }

    @Override
    public Object fileKey() {
        return null;
    }

    public long compressedSize() {
        return this.e.csize;
    }

    public long crc() {
        return this.e.crc;
    }

    public int method() {
        return this.e.method;
    }

    public byte[] extra() {
        if (this.e.extra != null) {
            return Arrays.copyOf(this.e.extra, this.e.extra.length);
        }
        return null;
    }

    public byte[] comment() {
        if (this.e.comment != null) {
            return Arrays.copyOf(this.e.comment, this.e.comment.length);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        Formatter fm = new Formatter(sb);
        if (this.creationTime() != null) {
            fm.format("    creationTime    : %tc%n", this.creationTime().toMillis());
        } else {
            fm.format("    creationTime    : null%n", new Object[0]);
        }
        if (this.lastAccessTime() != null) {
            fm.format("    lastAccessTime  : %tc%n", this.lastAccessTime().toMillis());
        } else {
            fm.format("    lastAccessTime  : null%n", new Object[0]);
        }
        fm.format("    lastModifiedTime: %tc%n", this.lastModifiedTime().toMillis());
        fm.format("    isRegularFile   : %b%n", this.isRegularFile());
        fm.format("    isDirectory     : %b%n", this.isDirectory());
        fm.format("    isSymbolicLink  : %b%n", this.isSymbolicLink());
        fm.format("    isOther         : %b%n", this.isOther());
        fm.format("    fileKey         : %s%n", this.fileKey());
        fm.format("    size            : %d%n", this.size());
        fm.format("    compressedSize  : %d%n", this.compressedSize());
        fm.format("    crc             : %x%n", this.crc());
        fm.format("    method          : %d%n", this.method());
        fm.close();
        return sb.toString();
    }
}

