/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GridSortingModelImpl<Row, Column>
implements GridSortingModel<Row, Column> {
    private boolean mySortingEnabled;
    private List<RowSortOrder<ModelIndex<Column>>> myOrdering = ContainerUtil.emptyList();
    private final EventDispatcher<GridSortingModel.Listener> myEventDispatcher = EventDispatcher.create(GridSortingModel.Listener.class);

    @Override
    public boolean isSortingEnabled() {
        return this.mySortingEnabled;
    }

    @Override
    public void setSortingEnabled(boolean enabled) {
        this.mySortingEnabled = enabled;
        ((GridSortingModel.Listener)this.myEventDispatcher.getMulticaster()).orderingChanged();
    }

    @Override
    public void setOrdering(@NotNull List<RowSortOrder<ModelIndex<Column>>> ordering) {
        if (ordering == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ordering", "com/intellij/database/datagrid/GridSortingModelImpl", "setOrdering"));
        }
        this.myOrdering = ContainerUtil.newArrayList(ordering);
        ((GridSortingModel.Listener)this.myEventDispatcher.getMulticaster()).orderingChanged();
    }

    @Override
    @NotNull
    public List<RowSortOrder<ModelIndex<Column>>> getOrdering() {
        List list = this.isSortingEnabled() ? ContainerUtil.newArrayList(this.myOrdering) : ContainerUtil.newSmartList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridSortingModelImpl", "getOrdering"));
        }
        return list;
    }

    @Override
    public void addListener(@NotNull GridSortingModel.Listener l, @NotNull Disposable disposable) {
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/database/datagrid/GridSortingModelImpl", "addListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/datagrid/GridSortingModelImpl", "addListener"));
        }
        this.myEventDispatcher.addListener((EventListener)l, disposable);
    }
}

