/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.coding.CompositeText;
import com.intellij.coding.SimpleCompositeText;
import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.introspection.GenericIntrospector;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.sql.Connection;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class GenericSourceLoader
implements GenericIntrospector.SourceLoader {
    private static final Logger LOG = Logger.getInstance(GenericSourceLoader.class);
    private final DatabaseDialectEx myDialect;

    public GenericSourceLoader(@NotNull DatabaseDialectEx dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dialects/GenericSourceLoader", "<init>"));
        }
        this.myDialect = dialect;
    }

    @Override
    public void loadSources(@NotNull Iterable<BasicModSourceAware> objects, @NotNull Connection connection) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/database/dialects/GenericSourceLoader", "loadSources"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/GenericSourceLoader", "loadSources"));
        }
        Exception first = null;
        Exception last = null;
        int count = 0;
        for (BasicModSourceAware object : objects) {
            try {
                this.loadSource(object, connection);
            }
            catch (Exception e) {
                object.setSourceText(null);
                if (first == null) {
                    first = e;
                } else {
                    last = e;
                }
                ++count;
            }
        }
        if (count != 0) {
            LOG.warn("Failed to load: " + count + " sources.\nFirst exception:\n" + ExceptionUtil.getUserStackTrace((Throwable)first, (Logger)LOG) + (last == null ? null : "Last exception:\n" + ExceptionUtil.getUserStackTrace((Throwable)last, (Logger)LOG)));
        }
    }

    public void loadSource(@NotNull BasicModSourceAware object, @NotNull Connection connection) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dialects/GenericSourceLoader", "loadSource"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/GenericSourceLoader", "loadSource"));
        }
        ObjectKind k = object.getKind();
        ObjectKind p = DasUtil.getKind((DasObject)object.getDbParent());
        boolean wasSet = false;
        if (p == ObjectKind.PACKAGE && k == ObjectKind.BODY) {
            wasSet = this.loadPackage(object, connection, true);
        } else if (k == ObjectKind.PACKAGE) {
            wasSet = this.loadPackage(object, connection, false);
        } else if ((p == ObjectKind.SCHEMA || this.myDialect.getFamilyId().isSybase() && p == ObjectKind.PACKAGE) && k == ObjectKind.ROUTINE) {
            wasSet = this.loadRoutine(object, connection);
        } else if (p == ObjectKind.SCHEMA && k == ObjectKind.VIEW) {
            wasSet = this.loadView(object, connection);
        }
        if (!wasSet) {
            object.setSourceText(null);
        }
    }

    private boolean loadView(@NotNull BasicModSourceAware object, @NotNull Connection connection) throws SQLException {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dialects/GenericSourceLoader", "loadView"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/GenericSourceLoader", "loadView"));
        }
        if (!this.myDialect.supportsViewDefinition() || !(object instanceof DasTable)) {
            return false;
        }
        DatabaseFamilyId familyId = this.myDialect.getFamilyId();
        Pair<String, DbImplUtil.ConcatenationProps> query = this.myDialect.sqlViewDefinition(object);
        StringBuilder res = new StringBuilder();
        DbImplUtil.concatStringResults(connection, this.myDialect, 0, (String)query.first, res, (DbImplUtil.ConcatenationProps)query.second);
        if (res.length() == 0) {
            return false;
        }
        if (familyId.isPostgres() || familyId.isHsqldb()) {
            DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder(false);
            String fullDefinition = this.myDialect.sqlCreateView(builder, (DasTable)object, res.toString(), "").getStatement();
            res.replace(0, res.length(), fullDefinition);
        }
        if (familyId.isSybase()) {
            res.append("\nGO");
        }
        GenericSourceLoader.applySourceText(object, res, familyId.isMysql() || familyId.isH2() || familyId.isHsqldb());
        return true;
    }

    private boolean loadRoutine(@NotNull BasicModSourceAware object, @NotNull Connection connection) throws Exception {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dialects/GenericSourceLoader", "loadRoutine"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/GenericSourceLoader", "loadRoutine"));
        }
        if (!this.myDialect.supportsProcedureDefinition() || !(object instanceof DasRoutine)) {
            return false;
        }
        DatabaseFamilyId familyId = this.myDialect.getFamilyId();
        if (familyId.isMysql()) {
            String src = DbImplUtil.concatStringResults(connection, this.myDialect, "select routine_definition from information_schema.routines where routine_name = '" + object.getName().replace("'", "''") + "'   and routine_schema = '" + DasUtil.getSchema((DasObject)object).replace("'", "''") + "'", 0, DbImplUtil.ConcatenationProps.NO_CONCAT);
            if (StringUtil.isEmpty((String)src)) {
                return false;
            }
            GenericSourceLoader.applySourceText(object, src, false);
            return true;
        }
        String source = this.myDialect.tryToLoadProcedureDefinition((DasRoutine)object, connection);
        if (StringUtil.isNotEmpty((String)source)) {
            GenericSourceLoader.applySourceText(object, source, familyId.isHsqldb());
            return true;
        }
        Pair<String, DbImplUtil.ConcatenationProps> query = this.myDialect.sqlProcedureDefinition((DasRoutine)object);
        StringBuilder res = new StringBuilder();
        if (familyId.isOracle()) {
            res.append("CREATE ");
        }
        int length = res.length();
        if ((res = DbImplUtil.concatStringResults(connection, this.myDialect, (String)query.first, 0, res, (DbImplUtil.ConcatenationProps)query.second)).length() == length) {
            return false;
        }
        if (familyId.isTransactSql()) {
            res.append("\nGO");
        } else if (!res.toString().trim().endsWith(";")) {
            res.append(";");
        }
        GenericSourceLoader.applySourceText(object, res, familyId.isHsqldb());
        return true;
    }

    private boolean loadPackage(@NotNull BasicModSourceAware object, @NotNull Connection connection, boolean body) throws SQLException {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dialects/GenericSourceLoader", "loadPackage"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/GenericSourceLoader", "loadPackage"));
        }
        if (this.myDialect.supportsPackageDefinition()) {
            return false;
        }
        Pair<String, DbImplUtil.ConcatenationProps> query = body ? this.myDialect.sqlPackageBodyDefinition(object) : this.myDialect.sqlPackageDefinition(object);
        StringBuilder res = new StringBuilder("CREATE ");
        int length = res.length();
        if (length == (res = DbImplUtil.concatStringResults(connection, this.myDialect, (String)query.first, 0, res, (DbImplUtil.ConcatenationProps)query.second)).length()) {
            return false;
        }
        GenericSourceLoader.applySourceText(object, res, false);
        return true;
    }

    private static void applySourceText(@NotNull BasicModSourceAware object, CharSequence text, boolean format) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dialects/GenericSourceLoader", "applySourceText"));
        }
        if (text != null && text.length() > 0) {
            SimpleCompositeText ct = new SimpleCompositeText(text, format ? CompositeText.Kind.DECOMPILED_TEXT : CompositeText.Kind.ORIGINAL_TEXT);
            object.setSourceText(ct);
        } else {
            object.setSourceText(null);
        }
    }

    public static class Provider
    implements GenericIntrospector.SourceLoaderProvider {
        @Override
        @Nullable
        public GenericIntrospector.SourceLoader create(@NotNull DBFacade myFacade) {
            if (myFacade == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myFacade", "com/intellij/database/dialects/GenericSourceLoader$Provider", "create"));
            }
            Rdbms rdbms = myFacade.rdbms();
            if (rdbms == UnknownDatabase.RDBMS) {
                return null;
            }
            DatabaseFamilyId family = GenericIntrospectorLegacyModelUtils.findFamily(rdbms);
            if (family == null || family == DatabaseFamilyId.UNKNOWN) {
                return null;
            }
            for (DatabaseDialectEx dialect : DatabaseDialects.getSupportedDialects()) {
                if (dialect.getFamilyId() != family || dialect == GenericDialect.INSTANCE) continue;
                return new GenericSourceLoader(dialect);
            }
            return null;
        }
    }
}

