/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump.argument;

import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.database.dump.dbdump.DumpContextDescriptor;
import com.intellij.database.dump.dbdump.MysqlArguments;
import com.intellij.database.dump.dbdump.PgArguments;
import com.intellij.database.dump.dbdump.argument.BooleanDumpArgument;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public enum BooleanDumpArgumentImpl implements BooleanDumpArgument
{
    MYSQL_DELAYED_INSERTS("Delayed inserts", "--delayed-insert"),
    MYSQL_EXTENDED_INSERTS("Multiple rows inserts", ArrayUtil.mergeArrays((String[])MysqlArguments.EXTENDED_INSERTS, (String[])MysqlArguments.SKIP_EXTENDED_INSERTS)){

        @Override
        public boolean isOnByDefault() {
            return true;
        }

        @Override
        @NotNull
        public String getTurnedOffArgument() {
            String string = BooleanDumpArgumentImpl.getArgumentsOnTurnOff(MysqlArguments.SKIP_EXTENDED_INSERTS);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$1", "getTurnedOffArgument"));
            }
            return string;
        }

        @Override
        public boolean getCurrentState(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$1", "getCurrentState"));
            }
            return 1.isOn(MysqlArguments.EXTENDED_INSERTS, MysqlArguments.SKIP_EXTENDED_INSERTS, cd);
        }

        @Override
        public boolean getStateForReset(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$1", "getStateForReset"));
            }
            return BooleanDumpArgumentImpl.isTextNotContainsSkipOpt(cd);
        }

        @Override
        public boolean isAppendInTheEnd(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$1", "isAppendInTheEnd"));
            }
            return 1.isAppendInTheEnd(cd, MysqlArguments.SKIP_EXTENDED_INSERTS);
        }
    }
    ,
    MYSQL_CREATE_OPTIONS("MySQL create table options", ArrayUtil.mergeArrays((String[])MysqlArguments.CREATE_OPTIONS, (String[])MysqlArguments.SKIP_CREATE_OPTIONS)){

        @Override
        public boolean isOnByDefault() {
            return true;
        }

        @Override
        @NotNull
        public String getTurnedOffArgument() {
            String string = BooleanDumpArgumentImpl.getArgumentsOnTurnOff(MysqlArguments.SKIP_CREATE_OPTIONS);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$2", "getTurnedOffArgument"));
            }
            return string;
        }

        @Override
        public boolean getCurrentState(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$2", "getCurrentState"));
            }
            return 2.isOn(MysqlArguments.CREATE_OPTIONS, MysqlArguments.SKIP_CREATE_OPTIONS, cd);
        }

        @Override
        public boolean getStateForReset(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$2", "getStateForReset"));
            }
            return BooleanDumpArgumentImpl.isTextNotContainsSkipOpt(cd);
        }

        @Override
        public boolean isAppendInTheEnd(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$2", "isAppendInTheEnd"));
            }
            return 2.isAppendInTheEnd(cd, MysqlArguments.SKIP_CREATE_OPTIONS);
        }
    }
    ,
    MYSQL_DROP_TABLE("Add drop table", (String[])ContainerUtil.ar((Object[])new String[]{"--add-drop-table", MysqlArguments.SKIP_ADD_DROP_TABLE})){

        @Override
        public boolean isOnByDefault() {
            return true;
        }

        @Override
        @NotNull
        public String getTurnedOffArgument() {
            String string = BooleanDumpArgumentImpl.getArgumentsOnTurnOff(new String[]{MysqlArguments.SKIP_ADD_DROP_TABLE});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$3", "getTurnedOffArgument"));
            }
            return string;
        }

        @Override
        public boolean getCurrentState(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$3", "getCurrentState"));
            }
            return 3.isOn("--add-drop-table", MysqlArguments.SKIP_ADD_DROP_TABLE, cd);
        }

        @Override
        public boolean getStateForReset(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$3", "getStateForReset"));
            }
            return BooleanDumpArgumentImpl.isTextNotContainsSkipOpt(cd);
        }

        @Override
        public boolean isAppendInTheEnd(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$3", "isAppendInTheEnd"));
            }
            return 3.isAppendInTheEnd(cd, MysqlArguments.SKIP_ADD_DROP_TABLE);
        }
    }
    ,
    MYSQL_ADD_LOCKS("Add locks", (String[])ContainerUtil.ar((Object[])new String[]{"--add-locks", MysqlArguments.SKIP_ADD_LOCKS})){

        @Override
        public boolean isOnByDefault() {
            return true;
        }

        @Override
        @NotNull
        public String getTurnedOffArgument() {
            String string = BooleanDumpArgumentImpl.getArgumentsOnTurnOff(new String[]{MysqlArguments.SKIP_ADD_LOCKS});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$4", "getTurnedOffArgument"));
            }
            return string;
        }

        @Override
        public boolean getCurrentState(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$4", "getCurrentState"));
            }
            return 4.isOn("--add-locks", MysqlArguments.SKIP_ADD_LOCKS, cd);
        }

        @Override
        public boolean getStateForReset(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$4", "getStateForReset"));
            }
            return BooleanDumpArgumentImpl.isTextNotContainsSkipOpt(cd);
        }

        @Override
        public boolean isAppendInTheEnd(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$4", "isAppendInTheEnd"));
            }
            return 4.isAppendInTheEnd(cd, MysqlArguments.SKIP_ADD_LOCKS);
        }
    }
    ,
    MYSQL_LOCK_TABLES("Lock tables", ArrayUtil.mergeArrays((String[])MysqlArguments.LOCK_TABLES, (String[])MysqlArguments.SKIP_LOCK_TABLES)){

        @Override
        public boolean isOnByDefault() {
            return true;
        }

        @Override
        @NotNull
        public String getTurnedOffArgument() {
            String string = BooleanDumpArgumentImpl.getArgumentsOnTurnOff(MysqlArguments.SKIP_LOCK_TABLES);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$5", "getTurnedOffArgument"));
            }
            return string;
        }

        @Override
        public boolean getCurrentState(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$5", "getCurrentState"));
            }
            return 5.isOn(MysqlArguments.LOCK_TABLES, MysqlArguments.SKIP_LOCK_TABLES, cd);
        }

        @Override
        public boolean getStateForReset(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$5", "getStateForReset"));
            }
            return BooleanDumpArgumentImpl.isTextNotContainsSkipOpt(cd);
        }

        @Override
        public boolean isAppendInTheEnd(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$5", "isAppendInTheEnd"));
            }
            return 5.isAppendInTheEnd(cd, MysqlArguments.SKIP_LOCK_TABLES);
        }
    }
    ,
    MYSQL_DISABLE_KEYS("Disable keys", ArrayUtil.mergeArrays((String[])MysqlArguments.DISABLE_KEYS, (String[])MysqlArguments.SKIP_DISABLE_KEYS)){

        @Override
        public boolean isOnByDefault() {
            return true;
        }

        @Override
        @NotNull
        public String getTurnedOffArgument() {
            String string = BooleanDumpArgumentImpl.getArgumentsOnTurnOff(MysqlArguments.SKIP_DISABLE_KEYS);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$6", "getTurnedOffArgument"));
            }
            return string;
        }

        @Override
        public boolean getCurrentState(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$6", "getCurrentState"));
            }
            return 6.isOn(MysqlArguments.DISABLE_KEYS, MysqlArguments.SKIP_DISABLE_KEYS, cd);
        }

        @Override
        public boolean getStateForReset(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$6", "getStateForReset"));
            }
            return BooleanDumpArgumentImpl.isTextNotContainsSkipOpt(cd);
        }

        @Override
        public boolean isAppendInTheEnd(@NotNull DumpContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl$6", "isAppendInTheEnd"));
            }
            return 6.isAppendInTheEnd(cd, MysqlArguments.SKIP_DISABLE_KEYS);
        }
    }
    ,
    MYSQL_DROP_TRIGGER("Add drop trigger", "--add-drop-trigger"),
    PG_CLEAN("Clean database", PgArguments.CLEAN_DATABASE),
    PG_CREATE("Create database", PgArguments.CREATE_DATABASE),
    PG_IF_EXISTS("Add \"IF EXISTS\"", "--if-exists"),
    PG_DATA_ONLY("Data only", PgArguments.DATA_ONLY);

    private final String[] myOptions;
    private final String myUiName;

    private BooleanDumpArgumentImpl(String uiName, String ... options) {
        if (uiName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "<init>"));
        }
        this.myOptions = options;
        this.myUiName = uiName;
    }

    @Override
    public boolean isMyLexeme(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isMyLexeme"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isMyLexeme"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isMyLexeme"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isMyLexeme"));
        }
        return ArrayUtil.find((Object[])this.myOptions, (Object)current.getText()) != -1;
    }

    @Override
    @NotNull
    public String getTurnedOffArgument() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "getTurnedOffArgument"));
        }
        return "";
    }

    @Override
    @NotNull
    public String getUiName() {
        String string = this.myUiName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "getUiName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String[] getArguments() {
        if (this.myOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "getArguments"));
        }
        return this.myOptions;
    }

    @Override
    public boolean getStateForReset(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "getStateForReset"));
        }
        return false;
    }

    @Override
    @NotNull
    public String getCommandLineArgument(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "getCommandLineArgument"));
        }
        String string = this.myOptions.length == 0 ? "" : this.myOptions[0];
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "getCommandLineArgument"));
        }
        return string;
    }

    @Override
    public boolean isOnByDefault() {
        return false;
    }

    @Override
    public boolean getCurrentState(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "getCurrentState"));
        }
        return true;
    }

    @NotNull
    private static String getArgumentsOnTurnOff(String ... skipArgs) {
        if (skipArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipArgs", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "getArgumentsOnTurnOff"));
        }
        String string = DbDumpUtil.extractNonParameterizable(skipArgs);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "getArgumentsOnTurnOff"));
        }
        return string;
    }

    @Override
    public boolean isAppendInTheEnd(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isAppendInTheEnd"));
        }
        return false;
    }

    private static boolean isTextNotContainsSkipOpt(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isTextNotContainsSkipOpt"));
        }
        return BooleanDumpArgumentImpl.isNotSkipOpt(cd) && !cd.isComponentChanged();
    }

    private static boolean isNotSkipOpt(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isNotSkipOpt"));
        }
        return cd.getLexemeIndex("--skip-opt") <= cd.getLexemeIndex("--opt");
    }

    static boolean isAppendInTheEnd(@NotNull DumpContextDescriptor cd, String ... skipArgs) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isAppendInTheEnd"));
        }
        if (skipArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipArgs", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isAppendInTheEnd"));
        }
        return cd.contains(skipArgs) || cd.contains("--skip-opt") || cd.contains("--opt");
    }

    static boolean isOn(@NotNull String[] args, @NotNull String[] skipArgs, @NotNull DumpContextDescriptor cd) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isOn"));
        }
        if (skipArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipArgs", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isOn"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isOn"));
        }
        int argsIdx = cd.getLexemeIndex(args);
        int skipOptIdx = cd.getLexemeIndex("--skip-opt");
        int optIdx = cd.getLexemeIndex("--opt");
        int skipIdx = cd.getLexemeIndex(skipArgs);
        return argsIdx > skipIdx && argsIdx > skipOptIdx || optIdx > skipIdx && optIdx > skipOptIdx;
    }

    static boolean isOn(@NotNull String arg, @NotNull String skipArg, @NotNull DumpContextDescriptor cd) {
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isOn"));
        }
        if (skipArg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipArg", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isOn"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/argument/BooleanDumpArgumentImpl", "isOn"));
        }
        return BooleanDumpArgumentImpl.isOn((String[])ContainerUtil.ar((Object[])new String[]{arg}), (String[])ContainerUtil.ar((Object[])new String[]{skipArg}), cd);
    }
}

