/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump.component;

import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.database.dump.dbdump.DumpContextDescriptor;
import com.intellij.database.dump.dbdump.argument.StringDumpArgument;
import com.intellij.database.dump.dbdump.component.ArgumentComponent;
import com.intellij.database.psi.DbElement;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class DumpPathTextField
extends ArgumentComponent<StringDumpArgument> {
    private final TextFieldWithBrowseButton myField;

    public DumpPathTextField(@NotNull StringDumpArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/database/dump/dbdump/component/DumpPathTextField", "<init>"));
        }
        super(argument);
        this.myField = new TextFieldWithBrowseButton();
        this.myField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent e) {
                DumpPathTextField.this.fireComponentChanged();
            }
        });
        this.myField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor()));
    }

    @Override
    public void reset(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/component/DumpPathTextField", "reset"));
        }
        this.myField.setText("");
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myField;
        if (textFieldWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/component/DumpPathTextField", "getComponent"));
        }
        return textFieldWithBrowseButton;
    }

    @Override
    public void changeState(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/component/DumpPathTextField", "changeState"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/component/DumpPathTextField", "changeState"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/component/DumpPathTextField", "changeState"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/component/DumpPathTextField", "changeState"));
        }
        String value = ((StringDumpArgument)this.getArgument()).getComponentValue(text, current, next, cd);
        if (value == null) {
            return;
        }
        String parameter = DbDumpUtil.clearString(value, ((StringDumpArgument)this.getArgument()).getUnquoter());
        if (StringUtil.equals((CharSequence)parameter, (CharSequence)this.myField.getText())) {
            return;
        }
        this.myField.setText(parameter);
    }

    @Override
    public void configure(@NotNull Collection<DbElement> elements, @NotNull DumpContextDescriptor cd) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/component/DumpPathTextField", "configure"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/component/DumpPathTextField", "configure"));
        }
        if (this.myField.getText().isEmpty()) {
            this.myField.setText(DumpPathTextField.getDefaultText());
        }
    }

    @NotNull
    private static String getDefaultText() {
        String string = SystemProperties.getUserHome() + File.separator + "dump.sql";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/component/DumpPathTextField", "getDefaultText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFullArgument(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/component/DumpPathTextField", "getFullArgument"));
        }
        StringDumpArgument argument = (StringDumpArgument)this.getArgument();
        String string = StringUtil.isEmptyOrSpaces((String)this.myField.getText()) ? "" : DbDumpUtil.fromListToArgument(ContainerUtil.list((Object[])new String[]{this.myField.getText()}), argument.getPrefix(), argument.getQuoter());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/component/DumpPathTextField", "getFullArgument"));
        }
        return string;
    }

    @Override
    public boolean isHideable() {
        return false;
    }
}

